/*
 * Decompiled with CFR 0.152.
 */
package com.zohocorp.zoho.ztiadapter;

import HTTPClient.AuthorizationInfo;
import HTTPClient.CookieModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.NVPair;
import com.zohocorp.zoho.ztiadapter.ConfManager;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.BASE64Encoder;

public class ZohoHTTPClient {
    private int timeout = 20000;
    private boolean discardCookies = false;
    private String authenticationType = "Basic";
    private static Logger logger = Logger.getLogger(ZohoHTTPClient.class.getName());

    public static void main(String[] args) {
        ZohoHTTPClient client = new ZohoHTTPClient();
    }

    public void setDiscardCookies(boolean val) {
        this.discardCookies = val;
    }

    public void setAuthenticationType(String auth) {
        this.authenticationType = auth;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public byte[] get(String urlStr, int timeout) throws SocketTimeoutException {
        this.timeout = timeout;
        return this.get(urlStr, null, null, null);
    }

    public byte[] get(String urlStr) throws SocketTimeoutException {
        return this.get(urlStr, null, null, null);
    }

    public byte[] get(String urlStr, String realm, String username, String password) throws SocketTimeoutException {
        if (!this.discardCookies) {
            CookieModule.setCookiePolicyHandler(null);
        } else {
            CookieModule.setCookiePolicyHandler(null);
            CookieModule.discardAllCookies();
        }
        if (urlStr != null && urlStr.indexOf("https:") == 0) {
            System.getProperties().put("java.protocol.handler.pkgs", "HTTPClient");
        }
        byte[] b = null;
        if (!ConfManager.isProxyEnabled()) {
            try {
                URL url = new URL(urlStr);
                HTTPResponse response = this.doGet(url, false, realm, username, password);
                if (response == null) {
                    return null;
                }
                int statusCode = response.getStatusCode();
                if (statusCode == 200) {
                    b = response.getData();
                }
                logger.log(Level.INFO, " Http Status code " + statusCode);
            }
            catch (SocketTimeoutException se) {
                throw se;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error while ZohoHTTPClient.get  ", e);
            }
        } else {
            String pPort = ConfManager.getProxyPort();
            String pHost = ConfManager.getProxyHost();
            String pUserName = ConfManager.getProxyUserName();
            String pPassword = ConfManager.getProxyPasswd();
            try {
                URL url = new URL(urlStr);
                HTTPConnection.setProxyServer((String)pHost, (int)new Integer(pPort));
                AuthorizationInfo.addBasicAuthorization((String)pHost, (int)new Integer(pPort), (String)"Squid proxy-caching web server", (String)pUserName, (String)pPassword);
                HTTPResponse response = this.doGet(url, true, realm, username, password);
                if (response == null) {
                    logger.log(Level.INFO, "RESPONSE NULL--------------------");
                    return null;
                }
                int statusCode = response.getStatusCode();
                logger.log(Level.INFO, "statusCode : " + statusCode);
                if (statusCode == 200) {
                    b = response.getData();
                }
            }
            catch (SocketTimeoutException se) {
                logger.log(Level.WARNING, "Error while ZohoHTTPClient.get : SocketTimeoutException ", se);
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Error while ZohoHTTPClient.get : IOException ", ioe);
            }
            catch (Exception ee) {
                logger.log(Level.WARNING, "Error while ZohoHTTPClient.get  ", ee);
            }
        }
        return b;
    }

    public HTTPResponse getResponse(String urlStr, String realm, String username, String password) {
        CookieModule.setCookiePolicyHandler(null);
        if (urlStr != null && urlStr.indexOf("https:") == 0) {
            System.getProperties().put("java.protocol.handler.pkgs", "HTTPClient");
        }
        if (!ConfManager.isProxyEnabled()) {
            try {
                URL url = new URL(urlStr);
                HTTPResponse response = this.doGet(url, false, realm, username, password);
                return response;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error while ZohoHTTPClient.getResponse  ", e);
            }
        } else {
            try {
                URL url = new URL(urlStr);
                String pPort = ConfManager.getProxyPort();
                String pHost = ConfManager.getProxyHost();
                String pUserName = ConfManager.getProxyUserName();
                String pPassword = ConfManager.getProxyPasswd();
                HTTPConnection.setProxyServer((String)pHost, (int)new Integer(pPort));
                AuthorizationInfo.addBasicAuthorization((String)pHost, (int)new Integer(pPort), (String)"Squid proxy-caching web server", (String)pUserName, (String)pPassword);
                HTTPResponse response = this.doGet(url, true, realm, username, password);
                return response;
            }
            catch (Exception ee) {
                logger.log(Level.WARNING, "Error while ZohoHTTPClient.getResponse  ", ee);
            }
        }
        return null;
    }

    public HTTPResponse postResponse(String urlStr, String realm, String username, String password, byte[] data) {
        CookieModule.setCookiePolicyHandler(null);
        Object b = null;
        if (urlStr != null && urlStr.indexOf("https:") == 0) {
            System.getProperties().put("java.protocol.handler.pkgs", "HTTPClient");
        }
        if (!ConfManager.isProxyEnabled()) {
            try {
                URL url = new URL(urlStr);
                HTTPResponse response = this.doPost(url, data, false, realm, username, password);
                return response;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error while ZohoHTTPClient.postResponse  ", e);
            }
        } else {
            try {
                URL url = new URL(urlStr);
                String pPort = ConfManager.getProxyPort();
                String pHost = ConfManager.getProxyHost();
                String pUserName = ConfManager.getProxyUserName();
                String pPassword = ConfManager.getProxyPasswd();
                HTTPConnection.setProxyServer((String)pHost, (int)new Integer(pPort));
                AuthorizationInfo.addBasicAuthorization((String)pHost, (int)new Integer(pPort), (String)"Squid proxy-caching web server", (String)pUserName, (String)pPassword);
                HTTPResponse response = this.doPost(url, data, true, realm, username, password);
                return response;
            }
            catch (Exception exp) {
                logger.log(Level.WARNING, "Error while ZohoHTTPClient.postResponse  ", exp);
            }
        }
        return null;
    }

    public byte[] post(String urlStr, byte[] data) {
        return this.post(urlStr, null, null, null, data);
    }

    public byte[] post(String urlStr, String realm, String username, String password, byte[] data) {
        CookieModule.setCookiePolicyHandler(null);
        byte[] b = null;
        if (urlStr != null && urlStr.indexOf("https:") == 0) {
            System.getProperties().put("java.protocol.handler.pkgs", "HTTPClient");
        }
        if (!ConfManager.isProxyEnabled()) {
            try {
                URL url = new URL(urlStr);
                HTTPResponse response = this.doPost(url, data, false, realm, username, password);
                int statusCode = response.getStatusCode();
                if (statusCode == 200 || statusCode == 201) {
                    b = response.getData();
                } else {
                    logger.log(Level.INFO, " Http StatusCode " + statusCode);
                }
                return b;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error while ZohoHTTPClient.post ", e);
            }
        } else {
            try {
                String pPort = ConfManager.getProxyPort();
                String pHost = ConfManager.getProxyHost();
                String pUserName = ConfManager.getProxyUserName();
                String pPassword = ConfManager.getProxyPasswd();
                URL url = new URL(urlStr);
                HTTPConnection.setProxyServer((String)pHost, (int)new Integer(pPort));
                AuthorizationInfo.addBasicAuthorization((String)pHost, (int)new Integer(pPort), (String)"Squid proxy-caching web server", (String)pUserName, (String)pPassword);
                HTTPResponse response = this.doPost(url, data, true, realm, username, password);
                if (response == null) {
                    return null;
                }
                int statusCode = response.getStatusCode();
                if (statusCode == 200 || statusCode == 201) {
                    b = response.getData();
                }
                return b;
            }
            catch (Exception exp) {
                logger.log(Level.WARNING, "Error while ZohoHTTPClient.post ", exp);
            }
        }
        return b;
    }

    private HTTPResponse doGet(URL url, boolean proxy, String realm, String username, String password) throws Exception {
        if (!proxy) {
            HTTPConnection.dontProxyFor((String)url.getHost());
        } else {
            HTTPConnection.doProxyFor((String)url.getHost());
        }
        HTTPConnection.setDefaultTimeout((int)20000);
        HTTPConnection connection = new HTTPConnection(url);
        NVPair[] headers = null;
        if ("WSSE".equals(this.authenticationType) && username != null && password != null) {
            headers = new NVPair[]{new NVPair("X-WSSE", ZohoHTTPClient.getWSSEHeader(username, password))};
        }
        if (headers != null) {
            connection.setDefaultHeaders(headers);
        }
        connection.setAllowUserInteraction(false);
        connection.setTimeout(this.timeout);
        if (realm != null && username != null && password != null && "Basic".equals(this.authenticationType)) {
            connection.addBasicAuthorization(realm, username, password);
        }
        String fileName = url.getFile();
        HTTPResponse response = null;
        response = connection.Get(fileName);
        if (response.getStatusCode() != 200 && response.getStatusCode() != 201) {
            response = connection.Get(URLEncoder.encode(fileName, StandardCharsets.UTF_8.toString()));
        }
        return response;
    }

    private HTTPResponse doPost(URL url, byte[] data, boolean proxy, String realm, String username, String password) throws Exception {
        if (!proxy) {
            HTTPConnection.dontProxyFor((String)url.getHost());
        } else {
            HTTPConnection.doProxyFor((String)url.getHost());
        }
        HTTPConnection connection = new HTTPConnection(url);
        NVPair[] headers = new NVPair[]{new NVPair("Content-Type", "text/xml")};
        if ("WSSE".equals(this.authenticationType) && username != null && password != null) {
            headers = new NVPair[]{new NVPair("Content-Type", "text/xml"), new NVPair("X-WSSE", ZohoHTTPClient.getWSSEHeader(username, password))};
        }
        if (realm != null && username != null && password != null && "Basic".equals(this.authenticationType)) {
            connection.addBasicAuthorization(realm, username, password);
        }
        connection.setAllowUserInteraction(false);
        if (headers != null) {
            connection.setDefaultHeaders(headers);
        }
        String fileName = url.getFile();
        HTTPResponse response = connection.Post(fileName, data);
        return response;
    }

    private static String getWSSEHeader(String username, String password) throws Exception {
        byte[] nonceB = ZohoHTTPClient.generateNonce();
        String nonce = ZohoHTTPClient.base64Encode(nonceB);
        String created = ZohoHTTPClient.generateTimestamp();
        String password64 = ZohoHTTPClient.getBase64Digest(nonceB, created.getBytes(StandardCharsets.UTF_8.toString()), password.getBytes(StandardCharsets.UTF_8.toString()));
        StringBuffer header = new StringBuffer("UsernameToken Username=\"");
        header.append(username);
        header.append("\", ");
        header.append("PasswordDigest=\"");
        header.append(password64);
        header.append("\", ");
        header.append("Nonce=\"");
        header.append(nonce);
        header.append("\", ");
        header.append("Created=\"");
        header.append(created);
        header.append("\"");
        return header.toString();
    }

    private static byte[] generateNonce() {
        String nonce = Long.toString(new Date().getTime());
        return nonce.getBytes();
    }

    private static String generateTimestamp() {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        return dateFormatter.format(new Date());
    }

    private static synchronized String getBase64Digest(byte[] nonce, byte[] created, byte[] password) {
        try {
            MessageDigest messageDigester = MessageDigest.getInstance("SHA-1");
            messageDigester.reset();
            messageDigester.update(nonce);
            messageDigester.update(created);
            messageDigester.update(password);
            return ZohoHTTPClient.base64Encode(messageDigester.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static synchronized String getBase64Digest(byte[] password) {
        try {
            MessageDigest messageDigester = MessageDigest.getInstance("SHA-1");
            messageDigester.reset();
            messageDigester.update(password);
            return ZohoHTTPClient.base64Encode(messageDigester.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String base64Encode(byte[] bytes) {
        return new BASE64Encoder().encode(bytes);
    }
}

