/*
 * Decompiled with CFR 0.152.
 */
package com.zohocorp.zoho.ztiadapter;

import com.zohocorp.zoho.ztiadapter.ConfManager;
import com.zohocorp.zoho.ztiadapter.ZohoTeleAdapter;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TeleAdapterEngine {
    private static HashMap<String, ZohoTeleAdapter> protocolMap = new HashMap();
    private static Logger logger = Logger.getLogger(TeleAdapterEngine.class.getName());
    private static int retryIntravelTime = 30000;
    private static PBXServerMonitor pbxServerMonitor;
    private static boolean isPBXServerMonitoring;
    private static boolean isPBXServerDown;
    private static int runningServerIdx;
    private static int totalNoOfServers;
    private static int lastRunServerIdx;

    public static boolean initialize() {
        TeleAdapterEngine.startMonitoring();
        Properties classMap = ConfManager.getProperties(ConfManager.getTeleAdapterConfFilePath());
        Enumeration<?> e = classMap.propertyNames();
        while (e.hasMoreElements()) {
            String protocol = (String)e.nextElement();
            String pvalue = (String)classMap.get(protocol);
            int checkInterval = new Integer(pvalue.split(",")[1]);
            String className = pvalue.split(",")[0];
            try {
                Class<?> adptclass = Class.forName(className);
                Constructor<?> cons = adptclass.getConstructor(String.class, Integer.class);
                Object[] argObj = new Object[]{protocol, checkInterval};
                ZohoTeleAdapter padapter = (ZohoTeleAdapter)cons.newInstance(argObj);
                if (!"avaya".equals(protocol)) {
                    TeleAdapterEngine.stopMonitoring();
                }
                if (!padapter.init(TeleAdapterEngine.getRunningServerIdx())) {
                    throw new Exception("Unable to initialize");
                }
                protocolMap.put(protocol, padapter);
            }
            catch (Exception exp) {
                logger.log(Level.INFO, "Unable to load protocol {0}", protocol);
                isPBXServerDown = Boolean.TRUE;
            }
        }
        return true;
    }

    private static void startMonitoring() {
        if (!isPBXServerMonitoring) {
            logger.log(Level.INFO, "The PBX server monitor is triggered");
            pbxServerMonitor = new PBXServerMonitor(TeleAdapterEngine.getRetryIntravelTime());
            pbxServerMonitor.start();
        }
    }

    public static void startRetry() {
        isPBXServerDown = Boolean.TRUE;
        logger.log(Level.INFO, "startRetry - {0}", TeleAdapterEngine.pbxServerMonitor.serverId);
    }

    public static void pauseRetry() {
        isPBXServerDown = Boolean.FALSE;
        logger.log(Level.INFO, "pauseRetry - {0}", TeleAdapterEngine.pbxServerMonitor.serverId);
        TeleAdapterEngine.setRunningServerIdx(lastRunServerIdx);
    }

    public static void stopMonitoring() {
        isPBXServerMonitoring = Boolean.FALSE;
        if (pbxServerMonitor != null) {
            pbxServerMonitor.stopThread();
        }
        logger.log(Level.INFO, "The monitor stopped to monitoring the PBX server({0}).", TeleAdapterEngine.getRunningServerIdx());
    }

    private static void updateServerIdxToRun() {
        lastRunServerIdx = TeleAdapterEngine.getRunningServerIdx();
        TeleAdapterEngine.setRunningServerIdx(TeleAdapterEngine.getRunningServerIdxPlusOne() < TeleAdapterEngine.getTotalNoOfServers() ? TeleAdapterEngine.getRunningServerIdxPlusOne() : 0);
    }

    public static ZohoTeleAdapter getAdapter(String protocol) {
        return protocolMap.get(protocol);
    }

    public static int getTotalNoOfServers() {
        return totalNoOfServers;
    }

    public static void setTotalNoOfServers(int totalNoOfServers) {
        TeleAdapterEngine.totalNoOfServers = totalNoOfServers;
    }

    public static int getRunningServerIdx() {
        return runningServerIdx;
    }

    public static int getRunningServerIdxPlusOne() {
        return runningServerIdx + 1;
    }

    public static void setRunningServerIdx(int runningServerIdx) {
        TeleAdapterEngine.runningServerIdx = runningServerIdx;
    }

    public static int getRetryIntravelTime() {
        return retryIntravelTime;
    }

    public static void setRetryIntravelTime(int retryIntravelTime) {
        TeleAdapterEngine.retryIntravelTime = retryIntravelTime;
    }

    static {
        isPBXServerMonitoring = Boolean.FALSE;
        isPBXServerDown = Boolean.FALSE;
        runningServerIdx = 0;
        totalNoOfServers = 1;
        lastRunServerIdx = 0;
    }

    static class PBXServerMonitor
    extends Thread {
        long serverId = 1L;
        private int intravelTime = 60000;
        private Logger logger1 = Logger.getLogger(PBXServerMonitor.class.getName());

        public PBXServerMonitor(int intravelTime) {
            super("PBX Server Monitor");
            this.intravelTime = intravelTime;
            this.serverId = System.currentTimeMillis();
            this.logger1.log(Level.INFO, "The monitor is ready to monitor the PBX server({0}).", TeleAdapterEngine.getRunningServerIdxPlusOne());
        }

        @Override
        public void run() {
            logger.log(Level.INFO, "The monitor starts to monitoring the PBX server({0}).", TeleAdapterEngine.getRunningServerIdxPlusOne());
            isPBXServerMonitoring = Boolean.TRUE;
            while (isPBXServerMonitoring) {
                try {
                    logger.log(Level.INFO, "The monitor is monitoring the PBX server({0}). Is PBX Server is Down? {1} ", new Object[]{TeleAdapterEngine.getRunningServerIdxPlusOne(), isPBXServerDown});
                    if (isPBXServerDown) {
                        this.logger1.log(Level.INFO, "Our monitor is waiting for PBX server({0}) wakeup.", TeleAdapterEngine.getRunningServerIdxPlusOne());
                        TeleAdapterEngine.initialize();
                        TeleAdapterEngine.updateServerIdxToRun();
                    }
                    Thread.sleep(this.intravelTime);
                }
                catch (Exception exp) {
                    this.logger1.log(Level.WARNING, "Error while monitoring PBX Server", exp);
                }
            }
            isPBXServerMonitoring = Boolean.FALSE;
        }

        public void stopThread() {
            isPBXServerMonitoring = Boolean.FALSE;
        }
    }
}

