/*
 * Decompiled with CFR 0.152.
 */
package com.zohocorp.zoho.ztiadapter;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.servercommon.BufferedQueue;
import com.zohocorp.zoho.ztiadapter.ConfManager;
import com.zohocorp.zoho.ztiadapter.ZohoHTTPClient;
import com.zohocorp.zoho.ztiadapter.util.AuthUtil;
import java.io.File;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RetryEngine {
    private static final Logger logger = Logger.getLogger(RetryEngine.class.getName());
    private static RetryQueue retryque;
    private static Thread retrythread;
    private static Object rlock;

    public static boolean initialize() {
        retryque = new RetryQueue();
        retrythread = new RetryQueueProcessor(retryque);
        retrythread.start();
        logger.info("RSRetryEngine started sucessfully");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startNow() {
        logger.fine("Notifying retryengine on notification");
        Object object = rlock;
        synchronized (object) {
            rlock.notify();
        }
    }

    public static void add(Hashtable event) {
        Hashtable<String, Object> retryevt = new Hashtable<String, Object>();
        retryevt.put("retrytime", "" + System.currentTimeMillis());
        retryevt.put("data", event);
        retryque.add(retryevt);
    }

    private static void addAgain(Hashtable retryevt) {
        retryque.add(retryevt);
    }

    public static void close() {
        retryque.close();
        logger.fine(" RSRetryEngine closed Successfully ..");
    }

    private static boolean dispatch(Hashtable event) {
        try {
            String dispatchURL = ConfManager.getNotifyServer() + "/wms/newZtilistener.do?event=" + URLEncoder.encode(HttpDataWraper.getString((Object)event), StandardCharsets.UTF_8.toString()) + "&zapikey=" + URLEncoder.encode(AuthUtil.getZAPIKey(), StandardCharsets.UTF_8.toString());
            logger.log(Level.WARNING, "dispatch URL : {0}", dispatchURL);
            ZohoHTTPClient cli = new ZohoHTTPClient();
            cli.setDiscardCookies(true);
            cli.get(dispatchURL);
            return true;
        }
        catch (Exception exp) {
            logger.info("Unable to dispatch event " + event);
            logger.log(Level.WARNING, "Error while RetryEngine.dispatch : ", exp);
            return false;
        }
    }

    static {
        rlock = new Object();
    }

    static class RetryQueue {
        private BufferedQueue bq = new BufferedQueue(ConfManager.getAdapterHome() + File.separator + "retry_temp", "rty", 100);

        RetryQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void add(Object obj) {
            this.bq.add(obj);
            logger.fine("Message added in the retry que " + obj);
            if (retrythread.getState() == Thread.State.WAITING) {
                logger.info("Thread under indefnite sleep notifying");
                Object object = rlock;
                synchronized (object) {
                    rlock.notify();
                }
            }
        }

        public synchronized Object remove() {
            Object obj = this.bq.get();
            return obj;
        }

        public synchronized int size() {
            return this.bq.size();
        }

        public synchronized boolean isEmpty() {
            return this.bq.isEmpty();
        }

        public void close() {
            this.bq.close();
        }
    }

    static class RetryQueueProcessor
    extends Thread {
        private RetryQueue queue;

        public RetryQueueProcessor(RetryQueue que) {
            super("ZohoRetryEngineProcessor");
            this.queue = que;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        int snapsize = this.queue.size();
                        logger.info("retyr running for snap size " + snapsize);
                        for (int i = 0; i < snapsize; ++i) {
                            boolean status;
                            Hashtable rtyevent = (Hashtable)retryque.remove();
                            long rtytime = Long.parseLong("" + rtyevent.get("retrytime"));
                            Hashtable data = (Hashtable)rtyevent.get("data");
                            if (System.currentTimeMillis() - rtytime > (long)ConfManager.getRetrythreshold()) {
                                logger.severe("event dropped retry failed after retrythreshold :" + data);
                            }
                            if (status = RetryEngine.dispatch(data)) continue;
                            RetryEngine.addAgain(rtyevent);
                        }
                        Object object = rlock;
                        synchronized (object) {
                            if (this.queue.isEmpty()) {
                                try {
                                    rlock.wait();
                                }
                                catch (Exception exp) {
                                    logger.log(Level.WARNING, "Error while RetryEngine.run : ", exp);
                                }
                            }
                            if (!this.queue.isEmpty()) {
                                try {
                                    rlock.wait(10000L);
                                }
                                catch (Exception exp) {
                                    logger.log(Level.WARNING, "Error while RetryEngine.run : ", exp);
                                }
                            }
                        }
                    }
                }
                catch (Exception exp) {
                    logger.log(Level.WARNING, "Error while RetryEngine.run : ", exp);
                    continue;
                }
                break;
            }
        }
    }
}

