/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.desk.websocket;

import com.zoho.desk.websocket.DMSClient;
import com.zoho.desk.websocket.DMSStatusHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DMSReconnect
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(DMSReconnect.class.getName());
    private static int reconnectSleepTime;
    private static DMSClient dmsClient;
    private static DMSReconnect dmsReconnect;
    private static ExecutorService executor;

    public DMSReconnect() {
        reconnectSleepTime = 1500;
    }

    public static synchronized DMSReconnect getInstance() {
        dmsReconnect = new DMSReconnect();
        executor = Executors.newSingleThreadExecutor();
        return dmsReconnect;
    }

    public static void setDmsReconnect(DMSReconnect dmsReconnect) {
        DMSReconnect.dmsReconnect = dmsReconnect;
    }

    public static synchronized DMSReconnect getDmsReconnect() {
        return dmsReconnect;
    }

    @Override
    public void run() {
        try {
            LOGGER.log(Level.INFO, "STARTING RECONNECT - AGENT THREAD");
            Thread.sleep(reconnectSleepTime * 1000 - 35000);
            LOGGER.log(Level.INFO, "RECONNECTING - AGENT");
            dmsClient = DMSClient.getInstance();
            dmsClient.initializeConnectivity();
            DMSStatusHandler.setAgentDisconnect(true);
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.WARNING, "INTERRUPTING - AGENT - RECONNECT THREAD", ex);
            DMSStatusHandler.setAgentDisconnect(false);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "ERROR OCCURED - RECONNECT THREAD", e);
        }
    }

    public synchronized void execute() {
        executor.execute(dmsReconnect);
    }

    public static synchronized void interruptReconnectThread() {
        if (!executor.isTerminated()) {
            LOGGER.log(Level.INFO, "INTERRUPTING - RECONNECT THREAD");
            executor.shutdownNow();
        }
    }

    static {
        dmsClient = null;
        executor = Executors.newSingleThreadExecutor();
    }
}

