/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.util;

import com.adventnet.wms.common.ChatId;
import com.adventnet.wms.common.UserId;
import com.adventnet.wms.common.exception.WMSException;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class CommonWMSUtil {
    private static Logger logger = Logger.getLogger(CommonWMSUtil.class.getName());

    public static String getChatMessageType(String msg) {
        try {
            if (msg.matches("http://twitter.com/.*")) {
                return "twitter";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean isZohoUser(String wmsid) {
        return CommonWMSUtil.isZuid(wmsid);
    }

    public static boolean isAnnonUser(String wmsid) {
        return wmsid.indexOf("$") == 0;
    }

    public static boolean isMPUser(String wmsid) {
        return wmsid.indexOf("*") == 0;
    }

    public static boolean isRTCPUser(String wmsid) {
        return wmsid.indexOf("RT_") == 0;
    }

    public static boolean isBotUser(String wmsid) {
        return wmsid.indexOf("b-") == 0;
    }

    public static boolean isPortalUser(String wmsid) {
        try {
            String[] us = wmsid.split("_");
            if (us.length == 3) {
                return us[0].length() == 2 && !"-1".equals(us[1]) && us[1].length() <= 100 && !"-1".equals(us[2]) && us[2].length() <= 100;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isOrgUser(String wmsid) {
        try {
            String[] us = wmsid.split("-");
            if (us.length == 4) {
                return us[0].equals("o") && us[1].length() == 2 && !"-1".equals(us[2]) && us[2].length() <= 100 && !"-1".equals(us[3]) && us[3].length() <= 100;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isWmsId(String uname) {
        return CommonWMSUtil.isZuid(uname) || CommonWMSUtil.isAnnonUser(uname) || CommonWMSUtil.isMPUser(uname) || CommonWMSUtil.isPortalUser(uname);
    }

    public static boolean isNonZohoWmsId(String uname) {
        return CommonWMSUtil.isAnnonUser(uname) || CommonWMSUtil.isMPUser(uname);
    }

    public static void checkForNonZohoWmsId(String uname) throws WMSException {
        if (!CommonWMSUtil.isNonZohoWmsId(uname)) {
            throw new WMSException("Invalid User");
        }
    }

    public static String getMPUser(String wmsid, String mpuser) {
        String mpid = "*" + wmsid + "|" + mpuser;
        return mpid;
    }

    public static String getMPLoginIdfromMPUser(String mpuser) {
        return mpuser.split("\\|")[1];
    }

    public static String getMPContactIdfromMPUser(String mpuser) {
        return mpuser.split("\\|")[2];
    }

    public static String getMPProtocolfromMPUser(String mpuser) {
        return mpuser.split("\\|")[3];
    }

    public static void checkWmsId(String uname) throws WMSException {
        if (!CommonWMSUtil.isWmsId(uname)) {
            throw new WMSException("Invalid WmsId " + uname);
        }
    }

    public static boolean isZuid(String id) {
        try {
            Long zuid = new Long(id);
            return true;
        }
        catch (NumberFormatException nexp) {
            return false;
        }
    }

    public static String getBotWmsId(String botid) {
        return "b-" + botid;
    }

    public static String getWMSPortalUser(String prd, String scopeid, String userid) {
        return new UserId(prd, scopeid, userid).get();
    }

    public static String getUserIdFromWmsId(String wmsid) {
        return UserId.parseUserId(wmsid);
    }

    public static String getScopeIdFromWmsId(String wmsid) {
        return UserId.parseScopeId(wmsid);
    }

    public static String getProductIdFromWmsId(String wmsid) {
        return UserId.parsePrd(wmsid);
    }

    public static String getRestoreKeyFromChatId(String chid) {
        return ChatId.parseRestoreKey(chid);
    }

    public static boolean isSerializable(Object obj) {
        ObjectOutputStream os = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            os = new ObjectOutputStream(baos);
            os.writeObject(obj);
            os.flush();
            os.close();
            return true;
        }
        catch (Exception ex) {
            logger.severe("Problem in serializing - " + obj + " , " + ex.getMessage());
            try {
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    public static String getCallEventAsString(int callevent) {
        switch (callevent) {
            case 1: {
                return "CALL_INITIATED";
            }
            case 2: {
                return "CALL_REQUESTED";
            }
            case 3: {
                return "CALL_RECEIVED";
            }
            case 4: {
                return "CALL_UI_SHOWN";
            }
            case 5: {
                return "CALL_ANSWERED";
            }
            case 6: {
                return "CALL_REJECTED";
            }
            case 7: {
                return "CALL_CANCELLED";
            }
            case 8: {
                return "CALL_CONNECTED";
            }
            case 9: {
                return "CALL_COMPLETED";
            }
            case 10: {
                return "CALL_ERROR_APP";
            }
            case 11: {
                return "CALL_ERROR_WEBRTC";
            }
            case 12: {
                return "CALL_ERROR_OTHERS";
            }
            case 13: {
                return "CALL_MISSED_SENDER";
            }
            case 14: {
                return "CALL_MISSED_RECEIVER";
            }
            case 15: {
                return "CALL_CANDIDATEPAIR";
            }
            case 16: {
                return "OTHER_INFO";
            }
            case 17: {
                return "CALL_ANSWERED_FALLBACK";
            }
            case 18: {
                return "CALL_RECONNECTION";
            }
            case 19: {
                return "CALL_ICECANDIDATE";
            }
            case 21: {
                return "CALL_RECONNECTION_SUCCESS";
            }
            case 22: {
                return "CALL_RECONNECTION_FAILURE";
            }
            case 20: {
                return "CALL_SWITCH";
            }
            case 23: {
                return "CALL_RINGING";
            }
            case 24: {
                return "CALL_PEX_CONNECTION_TIME";
            }
            case 25: {
                return "CALL_ANSWERED_ACK";
            }
            case 26: {
                return "NTT_RTT_POOR";
            }
            case 27: {
                return "WMS_RTT_POOR";
            }
            case 28: {
                return "CANDIDATE_NOT_GENERATED";
            }
            case 29: {
                return "CANDIDATE_NOT_RECEIVED";
            }
            case 30: {
                return "GEO_NOT_CONNECTED";
            }
            case 31: {
                return "PRIMARY_NOT_CONNECTED";
            }
            case 32: {
                return "SEC_NOT_CONNECTED";
            }
            case 33: {
                return "POLLING_FALLBACK";
            }
        }
        return "UNKNOWN TYPE " + callevent;
    }

    public static String encryptData(String uid) {
        try {
            char[] arr0 = new char[]{'b', '1', 'y', 's', 'd', '2', 'c', 'q', 'f', '3'};
            char[] arr1 = new char[]{'w', 'o', 'h', '4', 'd', 'm', 'j', '5', 'u', 'k'};
            char[] arr2 = new char[]{'p', '6', 'f', 'i', 'r', '7', 'a', 'g', 't', '8'};
            char[] arr3 = new char[]{'k', 'c', 'x', '9', 'a', 'z', '0', 'v', 'a', 'l'};
            int val = Integer.parseInt("" + uid.replaceAll("\\D+", "").charAt(0)) % 4;
            String encrypteddata = "" + val;
            switch (val) {
                case 1: {
                    encrypteddata = encrypteddata + CommonWMSUtil.encrypt(arr1, uid);
                    break;
                }
                case 2: {
                    encrypteddata = encrypteddata + CommonWMSUtil.encrypt(arr2, uid);
                    break;
                }
                case 3: {
                    encrypteddata = encrypteddata + CommonWMSUtil.encrypt(arr3, uid);
                    break;
                }
                case 0: {
                    encrypteddata = encrypteddata + CommonWMSUtil.encrypt(arr0, uid);
                }
            }
            return encrypteddata;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encrypt(char[] arr, String str) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            try {
                if (Pattern.matches("[0-9]+", String.valueOf(str.charAt(i)))) {
                    res.append(arr[Integer.parseInt(String.valueOf(str.charAt(i)))]);
                    continue;
                }
                res.append(str.charAt(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return res.toString();
    }

    public static String decryptData(String encrypteddata) {
        try {
            String decrypteddata = "";
            char[] arr0 = new char[]{'b', '1', 'y', 's', 'd', '2', 'c', 'q', 'f', '3'};
            char[] arr1 = new char[]{'w', 'o', 'h', '4', 'd', 'm', 'j', '5', 'u', 'k'};
            char[] arr2 = new char[]{'p', '6', 'f', 'i', 'r', '7', 'a', 'g', 't', '8'};
            char[] arr3 = new char[]{'k', 'c', 'x', '9', 'a', 'z', '0', 'v', 'a', 'l'};
            int revval = Integer.parseInt(String.valueOf(encrypteddata.charAt(0)));
            switch (revval) {
                case 1: {
                    decrypteddata = decrypteddata + CommonWMSUtil.decrypt(arr1, encrypteddata);
                    break;
                }
                case 2: {
                    decrypteddata = decrypteddata + CommonWMSUtil.decrypt(arr2, encrypteddata);
                    break;
                }
                case 3: {
                    decrypteddata = decrypteddata + CommonWMSUtil.decrypt(arr3, encrypteddata);
                    break;
                }
                case 0: {
                    decrypteddata = decrypteddata + CommonWMSUtil.decrypt(arr0, encrypteddata);
                }
            }
            return decrypteddata;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String decrypt(char[] arr, String str) {
        StringBuilder res = new StringBuilder();
        for (int i = 1; i < str.length(); ++i) {
            try {
                if (Pattern.matches("[a-z0-9]+", String.valueOf(str.charAt(i)))) {
                    res.append(new String(arr).indexOf(str.charAt(i)));
                    continue;
                }
                res.append(str.charAt(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return res.toString();
    }

    public static boolean isOrgWmsid(String wmsid) {
        return wmsid.indexOf("o-") == 0;
    }

    public static String getZuidFromOrgWmsid(String wmsid) {
        if (CommonWMSUtil.isOrgUser(wmsid)) {
            return wmsid.split("-")[3];
        }
        throw new IllegalArgumentException("Invalid orgid specified.");
    }

    public static String getPrdFromOrgWmsid(String wmsid) {
        if (CommonWMSUtil.isOrgUser(wmsid)) {
            return wmsid.split("-")[1];
        }
        throw new IllegalArgumentException("Invalid orgid specified.");
    }
}

