/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.transcript;

import com.adventnet.wms.common.HttpDataWraper;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class MsgHeaderUtil {
    public static final String UNIT_DELIMITER = "%20";
    private static final int MAX_SEQUENCEID = 21;

    public static int getSequenceID(String msgid) {
        return MsgHeaderUtil.getSequenceID(MsgHeaderUtil.getUniqueid(msgid));
    }

    public static int getSequenceID(long uniqueID) {
        return (int)(uniqueID >>> 32 & 0xFFFFFFL);
    }

    public static long getUniqueid(String msgID) {
        return Long.parseLong(msgID.split(UNIT_DELIMITER)[1]);
    }

    public static long getMsgTime(String msgID) {
        return Long.parseLong(msgID.split(UNIT_DELIMITER)[0]);
    }

    public static int getNumberOfLines(String msgID1, String msgID2) {
        int numberOfLines = MsgHeaderUtil.getSequenceID(msgID1) - MsgHeaderUtil.getSequenceID(msgID2);
        if (numberOfLines < 0 && MsgHeaderUtil.getMsgTime(msgID1) > MsgHeaderUtil.getMsgTime(msgID2)) {
            numberOfLines = 21 - MsgHeaderUtil.getSequenceID(msgID1) + MsgHeaderUtil.getSequenceID(msgID2);
        }
        return numberOfLines;
    }

    public static JSONObject parseHeader(String header) throws JSONException {
        String[] headerDetails;
        header = header.substring(header.indexOf("<!--") + 4);
        header = header.substring(0, header.indexOf("-->"));
        JSONObject headerJson = new JSONObject();
        for (String tuple : headerDetails = header.split(",")) {
            String[] tupleDetails = tuple.split("=");
            headerJson.put(tupleDetails[0], (Object)tupleDetails[1]);
        }
        return headerJson;
    }

    public static String getMsgID(String header) throws JSONException {
        JSONObject details = MsgHeaderUtil.parseHeader(header);
        return (String)details.get("msgid");
    }

    public static String getMsgID(JSONObject header) throws JSONException {
        return (String)header.get("msgid");
    }

    public static boolean isEdited(JSONObject header) throws NumberFormatException, JSONException {
        Long flag = Long.parseLong((String)header.get("flags"));
        return (flag >> 2 & 1L) == 1L;
    }

    public static boolean isDeleted(JSONObject header) throws NumberFormatException, JSONException {
        Long flag = Long.parseLong((String)header.get("flags"));
        return (flag >> 6 & 1L) == 1L;
    }

    public static boolean isInternal(JSONObject header) throws NumberFormatException, JSONException {
        Long flag = Long.parseLong((String)header.get("flags"));
        return (flag >> 8 & 1L) == 1L;
    }

    public static boolean isInfoVisibility(JSONObject header) throws NumberFormatException, JSONException {
        Long flag = Long.parseLong((String)header.get("flags"));
        return (flag >> 9 & 1L) == 1L;
    }

    public static boolean allRead(JSONObject header) throws NumberFormatException, JSONException {
        Long flag = Long.parseLong((String)header.get("flags"));
        return (flag >> 4 & 1L) == 1L;
    }

    public static ArrayList formatMsg(String msgLine) {
        return (ArrayList)HttpDataWraper.getObject(msgLine);
    }

    public static JSONObject formatMsgAsJSON(String msgLine) throws JSONException {
        return null;
    }

    public static boolean isMsgRead(long flag) {
        return (flag >> 4 & 1L) == 1L;
    }

    public static boolean isThreadFlagSet(long flag) {
        return (flag >> 10 & 1L) == 1L;
    }

    public static boolean isMsgBlocked(long flag) {
        return (flag >> 11 & 1L) == 1L;
    }

    public static boolean isMsgRead(JSONObject header) throws NumberFormatException, JSONException {
        Long flag = Long.parseLong((String)header.get("flags"));
        return MsgHeaderUtil.isMsgRead(flag);
    }

    public static boolean isMsgBlocked(JSONObject header) throws NumberFormatException, JSONException {
        Long flag = Long.parseLong((String)header.get("flags"));
        return MsgHeaderUtil.isMsgBlocked(flag);
    }

    public static boolean isThreadFlagSet(JSONObject header) throws NumberFormatException, JSONException {
        Long flag = Long.parseLong((String)header.get("flags"));
        return MsgHeaderUtil.isThreadFlagSet(flag);
    }
}

