/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.stats.influx.conf;

import com.adventnet.wms.common.stats.influx.StatsDB;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StatsConf {
    private static String serverIP;
    private static int serversMapIndex;
    private static List<String> seedList;
    private static final ConcurrentHashMap<String, String> STATS_DEFS;

    public static boolean initialize(Map<String, String> statsDefs) {
        try {
            STATS_DEFS.putAll(statsDefs);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static List<String> getSeedList() {
        return seedList;
    }

    public static String getServer() {
        int size = seedList.size();
        if (size <= 0) {
            return null;
        }
        if (size == 1) {
            return seedList.get(0);
        }
        if (serversMapIndex >= size) {
            serversMapIndex = 0;
        }
        return seedList.get(serversMapIndex++);
    }

    public static void setSeedList(List<String> seedList) {
        StatsConf.seedList = seedList;
    }

    public static boolean loadStatsKeyDef(Hashtable<String, String> defs) {
        try {
            STATS_DEFS.putAll(defs);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static ConcurrentHashMap<String, String> getStatDefs() {
        return STATS_DEFS;
    }

    public static String getServerIp() {
        return serverIP;
    }

    public static void initErrorMonitoring() {
        StatsConf.errorInstrumentation();
        StatsConf.moduleInstrumentation();
        StatsConf.monitorInfluxUsage();
    }

    private static void errorInstrumentation() {
        STATS_DEFS.put("statsdberror", "[[\"metric\",\"statsdb_api\",\"\",\"error\",false],[\"statskey\",\"responsecode\",\"prd\",\"errortype\"],[],[\"count\"]]");
    }

    private static void moduleInstrumentation() {
        STATS_DEFS.put("moduleerror", "[[\"metric\",\"errorinfo_api\",\"\",\"" + StatsDB.getPrd() + "_error\",false],[\"modulecode\",\"errorcode\"],[],[\"count\"]]");
        STATS_DEFS.put("modulefailure", "[[\"metric\",\"errorinfo_api\",\"\",\"overall\",false],[\"servertype\",\"modulecode\"],[],[\"count\"]]");
    }

    private static void monitorInfluxUsage() {
        STATS_DEFS.put("influx_write_usage", "[[\"qos\",\"qos_statsdb_api\",\"\",\"influx_write_usage\",false],[\"db\",\"msr\",\"prd\"],[],[\"count\"]]");
    }

    static {
        serversMapIndex = 0;
        seedList = new ArrayList<String>();
        STATS_DEFS = new ConcurrentHashMap();
        try {
            serverIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

