/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.stats.influx;

import com.adventnet.wms.common.stats.influx.AppStats;
import com.adventnet.wms.common.stats.influx.StatRecord;
import com.adventnet.wms.common.stats.influx.StatsByteArrayUploader;
import com.adventnet.wms.common.stats.influx.StatsDB;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StatsCollector
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(StatsCollector.class.getName());

    public StatsCollector() {
        this.setName("StatsCollector");
    }

    public static long getTimeKey() {
        Calendar cal = Calendar.getInstance();
        cal.set(12, cal.get(12) + 1);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    @Override
    public void run() {
        block6: while (true) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, "PS --> StatsCollector -> Thread.sleep error. InterruptedException occurred", e);
            }
            try {
                long timems = StatsCollector.getTimeKey();
                Hashtable statMap = StatsDB.getStatsMap();
                Enumeration enu = statMap.elements();
                block7: while (true) {
                    if (!enu.hasMoreElements()) continue block6;
                    try {
                        StatRecord stat = (StatRecord)enu.nextElement();
                        if (stat.isInstantDispatch()) continue;
                        if (stat.isSampleTimeAvailable()) {
                            ConcurrentHashMap statMapWithTime = stat.getStatsData();
                            Enumeration timeKeyEnum = statMapWithTime.keys();
                            while (true) {
                                if (!timeKeyEnum.hasMoreElements()) continue block7;
                                String timeStrKey = (String)timeKeyEnum.nextElement();
                                long time = Long.parseLong(timeStrKey);
                                AppStats appstats = new AppStats(time * stat.getSampleTimeInMills(), stat, (ConcurrentHashMap)statMapWithTime.get(timeStrKey));
                                LOGGER.info("PS-PS --> Inside isSampleTimeAvailable with data as below : " + appstats.toString());
                                StatsByteArrayUploader.add(appstats);
                            }
                        }
                        AppStats appstats = new AppStats(timems, stat, stat.getStatsData());
                        StatsByteArrayUploader.add(appstats);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.INFO, "StatsCollector Unable to collect data", e);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "StatsCollector Unable to collect data", e);
                continue;
            }
            break;
        }
    }
}

