/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.stats.influx;

import com.adventnet.wms.common.components.constants.ComponentConstants;
import com.adventnet.wms.common.counters.RangeCounter;
import com.adventnet.wms.common.stats.influx.StatsDB;
import com.adventnet.wms.common.stats.influx.StatsDispatchManager;
import com.adventnet.wms.common.stats.influx.conf.StatsConf;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONArray;

public class StatRecord {
    private String stattype = null;
    private String db = null;
    private String rp = null;
    private String statkey = null;
    private int strFieldStartingPos = -1;
    private int nonStrFieldStartingPos = -1;
    private int datalength = 0;
    private int keylength = 0;
    private boolean instantDispatch = false;
    private long sampleTimeInMills = -1L;
    private boolean rangeData = false;
    private long minrange = 1000L;
    private long maxrange = 120000L;
    private int rangeDataType = 1;
    private JSONArray nonStrFieldKeys = null;
    private ConcurrentHashMap<Long, ConcurrentHashMap> statsDataMap = new ConcurrentHashMap();
    private byte[] msr = null;
    private byte[][] tagAndFieldKeyBytes = null;
    private static final byte[] SPACE = " ".getBytes();
    private static final byte[] NEWLINE = "\n".getBytes();
    private static final byte[] SERVERIP = (",serverip=" + StatsConf.getServerIp()).getBytes();
    private boolean excludeServerIP = false;
    private boolean highPrecisionRange = true;
    private JSONArray jsonDef;

    public StatRecord(String key, String def) throws Exception {
        this.statkey = key;
        JSONArray jsonDef = new JSONArray(def);
        JSONArray metaData = jsonDef.getJSONArray(0);
        JSONArray tags = jsonDef.getJSONArray(1);
        JSONArray strFields = jsonDef.getJSONArray(2);
        this.nonStrFieldKeys = jsonDef.getJSONArray(3);
        this.stattype = metaData.getString(0);
        this.db = metaData.getString(1);
        this.rp = !metaData.isNull(2) ? metaData.getString(2) : "";
        this.msr = metaData.getString(3).getBytes();
        this.instantDispatch = !metaData.isNull(4) ? metaData.getBoolean(4) : false;
        if (!metaData.isNull(5)) {
            this.rangeData = metaData.getBoolean(5);
        }
        if (!metaData.isNull(6)) {
            this.minrange = metaData.getLong(6);
        }
        if (!metaData.isNull(7)) {
            this.maxrange = metaData.getLong(7);
        }
        if (!metaData.isNull(8)) {
            this.sampleTimeInMills = metaData.getLong(8);
        }
        if (!metaData.isNull(9)) {
            this.excludeServerIP = metaData.getBoolean(9);
        }
        if (!metaData.isNull(10)) {
            this.highPrecisionRange = metaData.getBoolean(10);
        }
        if (!metaData.isNull(11)) {
            this.rangeDataType = metaData.getInt(11);
        }
        this.datalength = this.excludeServerIP ? this.msr.length + 21 : this.msr.length + SERVERIP.length + 21;
        this.keylength = tags.length() + strFields.length() + this.nonStrFieldKeys.length();
        this.tagAndFieldKeyBytes = new byte[this.keylength][];
        this.addKeyBytes(0, tags);
        this.strFieldStartingPos = tags.length();
        this.addKeyBytes(this.strFieldStartingPos, strFields);
        this.nonStrFieldStartingPos = tags.length() + strFields.length();
        this.addKeyBytes(this.nonStrFieldStartingPos, this.nonStrFieldKeys);
    }

    protected JSONArray getStatDef() {
        return this.jsonDef;
    }

    private void addKeyBytes(int frompostion, JSONArray keys) {
        try {
            for (int i = 0; i < keys.length(); ++i) {
                byte[] keybyte = null;
                keybyte = this.strFieldStartingPos == frompostion ? (" " + keys.get(i) + "=").getBytes() : ("," + keys.get(i) + "=").getBytes();
                this.tagAndFieldKeyBytes[frompostion++] = keybyte;
                this.datalength += keybyte.length;
            }
        }
        catch (Exception e) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_COL_HEADER_MALFORMED.getErrorCode(), 1L);
        }
    }

    protected void addData(Object ... values) {
        try {
            int nonStrFieldPos = 0;
            ConcurrentHashMap tempStatsMap = this.statsDataMap;
            for (int i = 1; i < values.length; ++i) {
                String value = "" + values[i];
                if ((value = this.encodeValue(value, i <= this.strFieldStartingPos)).isEmpty()) {
                    throw new Exception("NULL value for " + new String(this.tagAndFieldKeyBytes[i - 1]));
                }
                if (i <= values.length - this.nonStrFieldKeys.length() && tempStatsMap.containsKey(value)) {
                    tempStatsMap = tempStatsMap.get(value);
                    continue;
                }
                if (i >= values.length - this.nonStrFieldKeys.length()) {
                    Object notStrFieldKey;
                    AtomicLong al;
                    ConcurrentHashMap<Object, AtomicLong> nonStrFieldsMap = (ConcurrentHashMap<Object, AtomicLong>)tempStatsMap.get("fields");
                    if (nonStrFieldsMap == null) {
                        nonStrFieldsMap = new ConcurrentHashMap<Object, AtomicLong>();
                        tempStatsMap.put("fields", nonStrFieldsMap);
                    }
                    if ((al = (AtomicLong)nonStrFieldsMap.get(notStrFieldKey = this.nonStrFieldKeys.get(nonStrFieldPos))) == null) {
                        al = new AtomicLong(0L);
                        nonStrFieldsMap.put(notStrFieldKey, al);
                    }
                    ++nonStrFieldPos;
                    if (value.equals("null") || value.isEmpty()) continue;
                    al.addAndGet(Long.parseLong(value));
                    continue;
                }
                ConcurrentHashMap temp = new ConcurrentHashMap();
                tempStatsMap.put(value, temp);
                tempStatsMap = temp;
            }
        }
        catch (Exception e) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_ERR_IN_ADD_DATA.getErrorCode(), 1L);
        }
    }

    protected void addRangeData(Object ... values) {
        try {
            int nonStrFieldPos = 0;
            ConcurrentHashMap tempStatsMap = this.statsDataMap;
            for (int i = 1; i < values.length; ++i) {
                String value = "" + values[i];
                value = this.encodeValue(value, i <= this.strFieldStartingPos);
                if (i <= values.length - this.nonStrFieldKeys.length() && tempStatsMap.containsKey(value)) {
                    tempStatsMap = tempStatsMap.get(value);
                    continue;
                }
                if (i >= values.length - this.nonStrFieldKeys.length()) {
                    Object notStrFieldKey;
                    RangeCounter rangeCounter;
                    ConcurrentHashMap<Object, RangeCounter> nonStrFieldsMap = (ConcurrentHashMap<Object, RangeCounter>)tempStatsMap.get("fields");
                    if (nonStrFieldsMap == null) {
                        nonStrFieldsMap = new ConcurrentHashMap<Object, RangeCounter>();
                        tempStatsMap.put("fields", nonStrFieldsMap);
                    }
                    if ((rangeCounter = (RangeCounter)nonStrFieldsMap.get(notStrFieldKey = this.nonStrFieldKeys.get(nonStrFieldPos))) == null) {
                        rangeCounter = new RangeCounter(this.minrange, this.maxrange, this.highPrecisionRange);
                        nonStrFieldsMap.put(notStrFieldKey, rangeCounter);
                    }
                    ++nonStrFieldPos;
                    if (value.equals("null") || value.isEmpty()) continue;
                    rangeCounter.add(Long.parseLong(value));
                    break;
                }
                ConcurrentHashMap temp = new ConcurrentHashMap();
                tempStatsMap.put(value, temp);
                tempStatsMap = temp;
            }
        }
        catch (Exception e) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_ERR_IN_ADD_DATA.getErrorCode(), 1L);
        }
    }

    protected void dispatchUpdatedData(long timeMillis, Object ... values) {
        ArrayList<Integer> nullValuesPos = new ArrayList<Integer>();
        int length = this.datalength;
        byte[][] tempValBuf = new byte[values.length - 1][];
        try {
            for (int i = 1; i < values.length; ++i) {
                if (values[i] == null) {
                    tempValBuf[i - 1] = "".getBytes();
                    nullValuesPos.add(i - 1);
                    continue;
                }
                String value = "" + values[i];
                if ((value = this.encodeValue(value, i <= this.strFieldStartingPos)).equals("null") || value.isEmpty()) {
                    if (i >= this.nonStrFieldStartingPos) {
                        value = "0";
                    } else {
                        return;
                    }
                }
                tempValBuf[i - 1] = value.getBytes();
                length += tempValBuf[i - 1].length;
            }
            byte[] timeNanos = ("" + timeMillis * 1000000L).getBytes();
            this.sendUpdatedDataToDispatcher(new ByteArrayOutputStream(length), tempValBuf, timeNanos, nullValuesPos);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_ARRAY_OUT_OF_BOUNDS_EXCEPTION.getErrorCode(), 1L);
        }
        catch (Exception e) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_STRING_TO_BYTE_CONVERSION_ERROR.getErrorCode(), 1L);
        }
    }

    public ConcurrentHashMap getStats() {
        return this.statsDataMap;
    }

    protected synchronized ConcurrentHashMap getStatsData() {
        ConcurrentHashMap<Long, ConcurrentHashMap> stats = this.statsDataMap;
        this.statsDataMap = new ConcurrentHashMap();
        return stats;
    }

    protected void dispatchDataAccumulated(int hlevel, ConcurrentHashMap stats, long timems) {
        this.dispatchDataAccumulated(0, new byte[this.keylength][], null, stats, timems);
    }

    private void dispatchDataAccumulated(int hlevel, byte[][] temp, byte[][] hptemp, ConcurrentHashMap stats, long timems) {
        int length = this.datalength;
        if (this.rangeData && this.highPrecisionRange && hptemp == null) {
            hptemp = new byte[this.keylength][];
        }
        try {
            Enumeration enu = stats.keys();
            while (enu.hasMoreElements()) {
                Object key = enu.nextElement();
                ConcurrentHashMap keymap = (ConcurrentHashMap)stats.get(key);
                if (!key.equals("fields")) {
                    byte[] keyBytes = ("" + key).getBytes();
                    if (this.rangeData && this.highPrecisionRange) {
                        hptemp[hlevel] = keyBytes;
                    }
                    temp[hlevel] = keyBytes;
                    length += keyBytes.length;
                }
                if (key.equals("fields") || this.nonStrFieldKeys.length() == 0 && keymap.isEmpty()) {
                    byte[] timens = Long.toString(timems).getBytes();
                    if (this.rangeData) {
                        String fieldname = this.nonStrFieldKeys.getString(0);
                        RangeCounter rangecounter = (RangeCounter)keymap.get(fieldname);
                        temp[hlevel] = StatRecord.getRangeStat(rangecounter.getSpread()).getBytes();
                        if (this.highPrecisionRange) {
                            hptemp[hlevel] = StatRecord.getRangeStat(rangecounter.getPercentageRange()).getBytes();
                        }
                    } else {
                        for (int i = 0; i < this.nonStrFieldKeys.length(); ++i) {
                            String fieldname = this.nonStrFieldKeys.getString(i);
                            AtomicLong adder = (AtomicLong)keymap.get(fieldname);
                            byte[] fieldBytes = ("" + adder.doubleValue()).getBytes();
                            if (this.rangeData && this.highPrecisionRange) {
                                hptemp[hlevel] = fieldBytes;
                            }
                            temp[hlevel++] = fieldBytes;
                            length += fieldBytes.length;
                        }
                    }
                    this.sendDataToDispatcher(new ByteArrayOutputStream(length), temp, timens);
                    if (hptemp != null) {
                        this.sendDataToDispatcher(new ByteArrayOutputStream(length), (byte[][])hptemp, timens, true);
                    }
                    break;
                }
                this.dispatchDataAccumulated(hlevel + 1, temp, (byte[][])hptemp, keymap, timems++);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_ARRAY_OUT_OF_BOUNDS_EXCEPTION.getErrorCode(), 1L);
        }
        catch (Exception e) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_STRING_TO_BYTE_CONVERSION_ERROR.getErrorCode(), 1L);
        }
    }

    protected void dispatchData(long timems, Object ... values) {
        int length = this.datalength;
        byte[][] tempValBuf = new byte[values.length - 1][];
        try {
            for (int i = 1; i < values.length; ++i) {
                String value = "" + values[i];
                if ((value = value.replace(" ", "")).equals("null") || value.isEmpty()) {
                    if (i >= this.nonStrFieldStartingPos) {
                        value = "0";
                    } else {
                        return;
                    }
                }
                tempValBuf[i - 1] = value.getBytes();
                length += tempValBuf[i - 1].length;
            }
            byte[] timens = ("" + timems * 1000000L).getBytes();
            this.sendDataToDispatcher(new ByteArrayOutputStream(length), tempValBuf, timens);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_ARRAY_OUT_OF_BOUNDS_EXCEPTION.getErrorCode(), 1L);
        }
        catch (Exception e) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_STRING_TO_BYTE_CONVERSION_ERROR.getErrorCode(), 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDataToDispatcher(ByteArrayOutputStream bos, byte[][] values, byte[] timens, boolean highPrecision) {
        String measurement = new String(this.msr);
        try {
            if (highPrecision) {
                measurement = measurement + "_hp";
            }
            bos.write(measurement.getBytes());
            if (!this.excludeServerIP) {
                bos.write(SERVERIP);
            }
            for (int k = 0; k < this.tagAndFieldKeyBytes.length; ++k) {
                if (!this.rangeData || k != this.tagAndFieldKeyBytes.length - 1) {
                    bos.write(this.tagAndFieldKeyBytes[k]);
                }
                if (k >= this.strFieldStartingPos && k < this.nonStrFieldStartingPos) {
                    bos.write("\"".getBytes());
                    bos.write(values[k]);
                    bos.write("\"".getBytes());
                    continue;
                }
                bos.write(values[k]);
            }
            bos.write(SPACE);
            bos.write(timens);
            bos.write(NEWLINE);
            try {
                StatsDispatchManager.dispatch(this.db, this.rp, this.stattype, bos.toByteArray(), measurement);
                bos.close();
            }
            catch (Exception e) {
                StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_SEND_DATA_TO_DISPATCHER_ERROR.getErrorCode(), 1L);
            }
            finally {
                try {
                    bos.close();
                }
                catch (IOException e) {}
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_OUTOFBOUNDSEXCEPTION_IN_ADD_DATA.getErrorCode(), 1L);
        }
        catch (Exception e) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_DISPTACH_UNKNOWN_ERR.getErrorCode(), 1L);
        }
    }

    private void sendDataToDispatcher(ByteArrayOutputStream bos, byte[][] values, byte[] timens) {
        this.sendDataToDispatcher(bos, values, timens, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUpdatedDataToDispatcher(ByteArrayOutputStream bos, byte[][] values, byte[] timeNanos, ArrayList<Integer> nullValuesPos) {
        int spaceAddedAt = -1;
        boolean isSpaceNeeded = false;
        if (nullValuesPos.contains(this.strFieldStartingPos)) {
            isSpaceNeeded = true;
            spaceAddedAt = this.strFieldStartingPos + 1;
        }
        try {
            bos.write(this.msr);
            if (!this.excludeServerIP) {
                bos.write(SERVERIP);
            }
            for (int k = 0; k < this.tagAndFieldKeyBytes.length; ++k) {
                if (nullValuesPos.contains(k)) {
                    if (!isSpaceNeeded || k != spaceAddedAt) continue;
                    ++spaceAddedAt;
                    continue;
                }
                if (!this.rangeData || k != this.tagAndFieldKeyBytes.length - 1) {
                    if (isSpaceNeeded && k == spaceAddedAt) {
                        String fieldName = new String(this.tagAndFieldKeyBytes[k]);
                        fieldName = fieldName.replace(",", " ");
                        bos.write(fieldName.getBytes());
                        isSpaceNeeded = false;
                        spaceAddedAt = -1;
                    } else {
                        bos.write(this.tagAndFieldKeyBytes[k]);
                    }
                }
                if (k >= this.strFieldStartingPos && k < this.nonStrFieldStartingPos) {
                    bos.write("\"".getBytes());
                    bos.write(values[k]);
                    bos.write("\"".getBytes());
                    continue;
                }
                bos.write(values[k]);
            }
            bos.write(SPACE);
            bos.write(timeNanos);
            bos.write(NEWLINE);
            try {
                StatsDispatchManager.dispatch(this.db, this.rp, this.stattype, bos.toByteArray(), new String(this.msr));
                bos.close();
            }
            catch (Exception e) {
                StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_SEND_DATA_TO_DISPATCHER_ERROR.getErrorCode(), 1L);
            }
            finally {
                try {
                    bos.close();
                }
                catch (IOException e) {}
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_OUTOFBOUNDSEXCEPTION_IN_ADD_DATA.getErrorCode(), 1L);
        }
        catch (Exception e) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_DISPTACH_UNKNOWN_ERR.getErrorCode(), 1L);
        }
    }

    protected boolean isInstantDispatch() {
        return this.instantDispatch;
    }

    protected boolean isRangeData() {
        return this.rangeData;
    }

    protected boolean isSampleTimeAvailable() {
        return this.sampleTimeInMills != -1L;
    }

    protected long getSampleTimeInMills() {
        return this.sampleTimeInMills;
    }

    private static String getRangeStat(ArrayList spreads) {
        StringBuilder sb = new StringBuilder(" ");
        for (int i = 0; i < spreads.size(); ++i) {
            Hashtable ht = (Hashtable)spreads.get(i);
            sb.append(ht.get("re"));
            sb.append("=");
            sb.append(ht.get("count"));
            if (i == spreads.size() - 1) {
                sb.append(" ");
                continue;
            }
            sb.append(",");
        }
        return sb.toString();
    }

    private static String getRangeStat(LinkedHashMap<Double, Long> spreads) {
        StringBuilder sb = new StringBuilder(" ");
        Set<Double> keySet = spreads.keySet();
        for (Double key : keySet) {
            sb.append(key).append("=").append(spreads.get(key)).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ");
        return sb.toString();
    }

    private String encodeValue(String value, boolean isTag) {
        if (isTag) {
            return this.encodeValue(value);
        }
        return value.replace(" ", "");
    }

    private String encodeValue(String value) {
        try {
            if (value.startsWith("{") || value.startsWith("[")) {
                return value;
            }
            StringBuilder stringBuilder = new StringBuilder();
            value.chars().mapToObj(item -> Character.valueOf((char)item)).forEach(n -> {
                if (n.charValue() != ' ') {
                    if (n.charValue() == ',' || n.charValue() == '=') {
                        stringBuilder.append("\\");
                    }
                    stringBuilder.append(n);
                }
            });
            return stringBuilder.toString();
        }
        catch (Exception e) {
            StatsDB.addData("statsdberror", "encodeValue", value, StatsDB.getPrd(), "stats_error", 1);
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.ENCODE_VALUE_EXCEPTION.getErrorCode(), 1L);
            return value;
        }
    }
}

