/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.service.callback;

import java.io.Serializable;
import java.util.Hashtable;

public class WMSServiceCBEvent
implements Serializable {
    private Hashtable<String, String> header = new Hashtable();
    private Hashtable<String, String> data = new Hashtable();
    private long ctime = -1L;
    public static final String RKEY_DELIMITER = "-";

    public WMSServiceCBEvent(String apiName, String prd, String category, String listener) {
        this.header.put("prd", prd);
        this.header.put("category", category);
        this.header.put("listener", listener);
        this.header.put("apiname", apiName);
        StringBuffer engineBuffer = new StringBuffer();
        engineBuffer.append(category).append(".").append(listener);
        this.header.put("engine", engineBuffer.toString());
        StringBuffer rkeyBuffer = new StringBuffer();
        rkeyBuffer.append(apiName).append(RKEY_DELIMITER).append(prd).append(RKEY_DELIMITER).append(category).append(RKEY_DELIMITER).append(listener);
        this.header.put("rkey", rkeyBuffer.toString());
        StringBuffer apinameBuffer = new StringBuffer();
        apinameBuffer.append(apiName).append(RKEY_DELIMITER).append(prd);
        this.header.put("wcpapiname", apinameBuffer.toString());
        this.header.put("response", "false");
        this.ctime = System.currentTimeMillis();
    }

    public WMSServiceCBEvent(Hashtable event) {
        this.header = (Hashtable)event.get("header");
        this.data = (Hashtable)event.get("data");
        this.ctime = event.containsKey("ctime") ? (Long)event.get("ctime") : System.currentTimeMillis();
    }

    public void setPrd(String prd) {
        this.header.put("prd", prd);
    }

    public String getPrd() {
        return this.header.get("prd");
    }

    public void setCategory(String category) {
        this.header.put("category", category);
    }

    public String getCategory() {
        return this.header.get("category");
    }

    public void setListener(String listener) {
        this.header.put("listener", listener);
    }

    public String getListener() {
        return this.header.get("listener");
    }

    public String getEngine() {
        return this.header.get("engine");
    }

    public void setALSNfid(String nfid) {
        this.header.put("alsnfid", nfid);
    }

    public String getALSNfid() {
        return this.header.get("alsnfid");
    }

    public void setNfid(String nfid) {
        this.header.put("nfid", nfid);
    }

    public String getNfid() {
        return this.header.get("nfid");
    }

    public void setAppServerIp(String appServerIP) {
        this.header.put("appserverip", appServerIP);
    }

    public String getAppServerIp() {
        return this.header.get("appserverip");
    }

    public void setOpr(String opr) {
        this.header.put("opr", opr);
    }

    public String getOpr() {
        return this.header.get("opr");
    }

    public String getRkey() {
        return this.header.get("rkey");
    }

    public String getAPIName() {
        return this.header.get("apiname");
    }

    public String getAPINameForWCP() {
        return this.header.get("wcpapiname");
    }

    public void setSourceIP(String ip) {
        this.header.put("sourceip", ip);
    }

    public String getSourceIP() {
        return this.header.get("sourceip");
    }

    public void setSourceCluster(String cluster) {
        this.header.put("cluster", cluster);
    }

    public String getSourceCluster() {
        return this.header.get("cluster");
    }

    public void enableResponse() {
        this.header.put("response", "true");
    }

    public String isResponseEnabled() {
        return this.header.get("response");
    }

    public void setExpiryTime(long timeInSecs) {
        this.header.put("expirytime", Long.toString(timeInSecs));
    }

    public long getExpiryTime() {
        if (this.header.containsKey("expiryTime")) {
            return Long.parseLong(this.header.get("expiryTime"));
        }
        return 30L;
    }

    public void setDispatchTime(long time) {
        this.header.put("dispatchtime", Long.toString(time));
    }

    public long getDispatchTime() {
        if (this.header.containsKey("dispatchtime")) {
            return Long.parseLong(this.header.get("dispatchtime"));
        }
        return 0L;
    }

    public void setResponseData(String data) {
        this.data.put("response_data", data);
    }

    public String getResponseData() {
        return this.data.get("response_data");
    }

    public void setResponseCode(String code) {
        this.data.put("response_code", code);
    }

    public String getResponseCode() {
        return this.data.get("response_code");
    }

    public void putData(String key, String value) {
        this.data.put(key, value);
    }

    public void setRetryCount(String count) {
        this.header.put("retrycount", count);
    }

    public String getRetryCount() {
        return this.header.get("retrycount");
    }

    public Hashtable<String, String> getDataAsTable() {
        return this.data;
    }

    public String getData(String key) {
        return this.data.get(key);
    }

    public Hashtable<String, Object> wrap() {
        Hashtable<String, Object> event = new Hashtable<String, Object>();
        event.put("header", this.header);
        event.put("data", this.data);
        event.put("ctime", this.ctime);
        return event;
    }
}

