/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.service.callback;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.components.net.WCPAPIDispatcher;
import com.adventnet.wms.common.components.net.servlet.WCPFuture;
import com.adventnet.wms.common.components.net.servlet.WCPRequest;
import com.adventnet.wms.common.components.net.servlet.WCPResponse;
import com.adventnet.wms.common.service.callback.AbsServiceCBListener;
import com.adventnet.wms.common.service.callback.CallBackSubscriber;
import com.adventnet.wms.common.service.callback.ServiceCBResponse;
import com.adventnet.wms.common.service.callback.WMSServiceCBEvent;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServiceCBManager {
    private static Logger logger = Logger.getLogger(ServiceCBManager.class.getName());
    private static String serverIP;
    private static AutoRenewal autorenwal;
    private static final long THRESHOLD_INTERVAL = 120000L;
    private static ConcurrentHashMap<String, String> apiMap;
    private static ConcurrentHashMap<String, AbsServiceCBListener> listenerMap;
    private static ConcurrentHashMap<String, ThreadPoolExecutor> tpeMap;

    private static void initialise(String prd, String apiname) throws Exception {
        try {
            serverIP = InetAddress.getLocalHost().getHostAddress();
            String adminurl = System.getProperty("scbn.adminurl");
            WCPAPIDispatcher.createWCPConnPool(apiname + "-" + "servicecb", apiname + "-" + "servicecbengine", prd, apiname, adminurl, "Unknown");
            Properties prop = new Properties();
            prop.setProperty("scn/sendservicecb", "com.adventnet.wms.common.service.callback.servlet.ServiceCBServlet");
            WCPAPIDispatcher.loadServlets(prop);
            autorenwal = new AutoRenewal();
            autorenwal.start();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WMS Service CB -> unable to initlize ServiceCBManager", e);
            throw e;
        }
    }

    public static void registerListener(String category, AbsServiceCBListener listener) throws Exception {
        if (!apiMap.containsKey(listener.getAPIName())) {
            ServiceCBManager.initialise(listener.getPrd(), listener.getAPIName());
        }
        String prd = listener.getPrd();
        String listenerName = listener.getListner();
        int corePoolSize = listener.getCorePoolSize();
        int maxConnCBRequest = listener.getMaxConnCBRequest();
        String name = category + "." + listenerName;
        if (!listenerMap.containsKey(name)) {
            CallBackSubscriber subscriber = new CallBackSubscriber(prd, serverIP, category, listenerName, maxConnCBRequest, listener.getAPIName());
            ArrayList<CallBackSubscriber> list = new ArrayList<CallBackSubscriber>();
            list.add(subscriber);
            WCPRequest req = new WCPRequest("scn/registerservicecb");
            req.addParam("cbsubscriber", HttpDataWraper.getString(list));
            WCPResponse response = null;
            try {
                WCPFuture future = WCPAPIDispatcher.sendRequest(listener.getAPIName() + "-" + "servicecb", req, null);
                response = future.get();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "WMS Service CB -> Dispatch Error category - " + category + " listener - " + listenerName, e);
            }
            listenerMap.put(name, listener);
            LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
            ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maxConnCBRequest, 30L, TimeUnit.SECONDS, queue);
            tpeMap.put(name, executor);
            logger.info("WMS Service CB -> New listener registered category - " + category + " listener - " + listenerName);
            logger.info("WMS Service CB -> New listener registered category - " + category + " listener - " + listenerName + " response = " + response.getResponseData() + " response code = " + response.getResponseCode());
        }
    }

    public static void add(WMSServiceCBEvent event, WCPResponse response) {
        String name = event.getEngine();
        if (listenerMap.containsKey(name)) {
            tpeMap.get(name).execute(new CBHandler(event, listenerMap.get(name), response));
        } else {
            logger.info("WMS Service CB ->  listener not registered " + name);
        }
    }

    static {
        apiMap = new ConcurrentHashMap();
        listenerMap = new ConcurrentHashMap();
        tpeMap = new ConcurrentHashMap();
    }

    private static class AutoRenewal
    extends Thread {
        private AutoRenewal() {
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Iterator iterator = listenerMap.entrySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block4;
                    Map.Entry entry = iterator.next();
                    AbsServiceCBListener listener = (AbsServiceCBListener)entry.getValue();
                    if (System.currentTimeMillis() - listener.getLastProcessedTime() <= 120000L) continue;
                    CallBackSubscriber subscriber = new CallBackSubscriber(listener.getPrd(), serverIP, listener.getCategory(), listener.getListner(), listener.getMaxConnCBRequest(), listener.getAPIName());
                    ArrayList<CallBackSubscriber> list = new ArrayList<CallBackSubscriber>();
                    list.add(subscriber);
                    WCPRequest req = new WCPRequest("scn/registerservicecb");
                    req.addParam("cbsubscriber", HttpDataWraper.getString(list));
                    try {
                        WCPAPIDispatcher.sendRequest(listener.getAPIName() + "-" + "servicecb", req, null);
                        continue;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "WMS Service CB -> Dispatch Error ", e);
                        continue;
                    }
                    break;
                }
                break;
            }
        }
    }

    private static class CBHandler
    implements Runnable {
        WMSServiceCBEvent event;
        AbsServiceCBListener listener;
        WCPResponse wcpResponse;

        public CBHandler(WMSServiceCBEvent event, AbsServiceCBListener listener, WCPResponse response) {
            this.event = event;
            this.listener = listener;
            this.wcpResponse = response;
        }

        @Override
        public void run() {
            ServiceCBResponse response = new ServiceCBResponse();
            try {
                this.listener.handle(this.event, response);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "WMS Service CB -> handle exception", e);
                response.setResponseCode("500");
            }
            this.listener.updateLastProcessedTime();
            this.wcpResponse.setResponseCode(response.getResponseCode());
            if (response.getResponseData() != null) {
                this.wcpResponse.setResponseData(HttpDataWraper.getString(response.getResponseData()));
            }
            try {
                this.wcpResponse.sendResponse();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "WMS Service CB -> Unable to send response ", e);
            }
        }
    }
}

