/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.pns;

import com.adventnet.wms.common.ChatId;
import com.adventnet.wms.common.pns.PushNotificationHandler;
import java.util.Hashtable;

public class LDPushNotificationHandler
implements PushNotificationHandler {
    @Override
    public Hashtable<String, Boolean> isEligible(String wmsid, long mask, Hashtable msg) {
        Hashtable<String, Boolean> resp = new Hashtable<String, Boolean>();
        resp.put("PNSEligible", this.isAllowed(wmsid, mask, msg));
        resp.put("UnreadEligible", true);
        return resp;
    }

    public boolean isAllowed(String wmsid, long mask, Hashtable msg) {
        boolean eventNotificationEnabled;
        if (mask == -1L) {
            return true;
        }
        String chid = (String)msg.get("chid");
        int chatType = LDPushNotificationHandler.getChatTypeFromChatID(chid);
        EventTypes event = EventTypes.getEventType(chatType);
        boolean allNotificationEnable = (int)(mask & 1L) == 1;
        boolean bl = eventNotificationEnabled = (int)(mask >> event.getBitPosition() & 1L) == 1;
        return eventNotificationEnabled && allNotificationEnable;
    }

    private static int getChatTypeFromRestoreKey(String restorekey) {
        return Integer.parseInt(restorekey.substring(0, 1));
    }

    private static int getChatTypeFromChatID(String chatid) {
        ChatId chatId = new ChatId(chatid);
        return LDPushNotificationHandler.getChatTypeFromRestoreKey(chatId.getRestoreKey());
    }

    public static enum EventTypes {
        CUSTOMER_CHAT(1, 1),
        INTERNAL_CHAT(2, 2),
        MSGBOARD_CHAT(3, 3);

        private int chattype;
        private int bitposition;

        private EventTypes(int chattype, int bitposition) {
            this.chattype = chattype;
            this.bitposition = bitposition;
        }

        public int getBitPosition() {
            return this.bitposition;
        }

        public static EventTypes getEventType(int chattype) {
            switch (chattype) {
                case 1: {
                    return CUSTOMER_CHAT;
                }
                case 2: {
                    return INTERNAL_CHAT;
                }
                case 3: {
                    return MSGBOARD_CHAT;
                }
            }
            return CUSTOMER_CHAT;
        }
    }

    public static class ChatType {
        public static final int CUSTOMER_CHAT = 1;
        public static final int INTERNAL_CHAT = 2;
        public static final int MSGBOARD_CHAT = 3;
    }
}

