/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.pex.io;

import com.adventnet.wms.common.HttpDataWraper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;

public class ProgressiveJSONInputStream {
    private static Logger logger = Logger.getLogger(ProgressiveJSONInputStream.class.getName());
    private InputStream is;
    private int lastChunkLength = 0;

    public ProgressiveJSONInputStream(InputStream is) {
        this.is = is;
    }

    public void pipe(OutputStream os) throws IOException {
        try {
            int chunkLength = -1;
            while ((chunkLength = this.readChunkSize()) > 0) {
                int offset;
                byte[] chunk = new byte[chunkLength];
                int numRead = 0;
                for (offset = 0; offset < chunkLength && (numRead = this.is.read(chunk, offset, chunkLength - offset)) >= 0; offset += numRead) {
                }
                if (offset < chunkLength) {
                    throw new IOException("Unable to read full chunk off/len = (" + offset + " / " + chunkLength + " )");
                }
                os.write(chunk, 0, chunkLength);
                os.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("PJIS : Unable to pipe stream");
        }
        finally {
            this.close();
        }
    }

    public Object readObject() throws IOException {
        try {
            int chunkLength = -1;
            this.lastChunkLength = chunkLength = this.readChunkSize();
            if (chunkLength > 0) {
                int offset;
                byte[] chunk = new byte[chunkLength];
                int numRead = 0;
                for (offset = 0; offset < chunkLength && (numRead = this.is.read(chunk, offset, chunkLength - offset)) >= 0; offset += numRead) {
                }
                if (offset < chunkLength) {
                    throw new IOException("Unable to read full chunk off/len = (" + offset + " / " + chunkLength + " )");
                }
                return HttpDataWraper.getObject(new String(chunk, "UTF-8"));
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("PJIS : Unable to read object");
        }
    }

    public boolean isEOF() {
        return this.lastChunkLength <= 0;
    }

    public int getLastChunkLength() {
        return this.lastChunkLength;
    }

    public void close() {
        try {
            if (this.is != null) {
                this.is.close();
                this.is = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int readChunkSize() throws IOException {
        int result;
        int cr = this.is.read();
        int lf = this.is.read();
        if (cr != 13 || lf != 10) {
            throw new IOException("Unable to read CRLF @ behining : " + cr + "/" + lf);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int state = 0;
        block15: while (state != -1) {
            int b = this.is.read();
            if (b == -1) {
                throw new IOException("Chunked stream ended unexpectedly");
            }
            switch (state) {
                case 0: {
                    switch (b) {
                        case 13: {
                            state = 1;
                            continue block15;
                        }
                        case 34: {
                            state = 2;
                        }
                    }
                    baos.write(b);
                    continue block15;
                }
                case 1: {
                    if (b == 10) {
                        state = -1;
                        continue block15;
                    }
                    throw new IOException("Newline character not proper in chunk size");
                }
                case 2: {
                    switch (b) {
                        case 92: {
                            b = this.is.read();
                            baos.write(b);
                            continue block15;
                        }
                        case 34: {
                            state = 0;
                        }
                    }
                    baos.write(b);
                    continue block15;
                }
            }
            throw new IOException("Unable to read chunk size");
        }
        String dataString = new String(baos.toByteArray(), "UTF-8");
        int separator = dataString.indexOf(59);
        dataString = separator > 0 ? dataString.substring(0, separator).trim() : dataString.trim();
        try {
            result = Integer.parseInt(dataString.trim(), 16);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid chunk size: " + dataString);
        }
        return result;
    }
}

