/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.pex;

import com.adventnet.wms.common.exception.WMSEventException;
import com.adventnet.wms.common.pex.LibProperty;
import com.adventnet.wms.common.pex.LibProps;
import com.adventnet.wms.common.pex.PEXEventHandler;
import com.adventnet.wms.common.pex.PEXResponse;
import com.adventnet.wms.common.pex.internal.PEXEventIDGenerator;
import java.util.Hashtable;

public abstract class PEXEvent {
    private int type = -1;
    private String id = PEXEventIDGenerator.getRandomId();
    private Hashtable<String, String> header;
    private Hashtable<String, String> config;
    private Object data;
    private PEXEventHandler handler;
    private int status = 0;
    private long ctime;
    private PEXResponse response;

    public PEXEvent(int type, Object data) {
        this.type = type;
        this.ctime = System.currentTimeMillis();
        this.data = data;
        this.header = new Hashtable();
        this.config = new Hashtable();
    }

    public void setHandler(PEXEventHandler handler) {
        this.handler = handler;
    }

    public PEXEventHandler getHandler() {
        return this.handler;
    }

    public void addData(String key, LibProperty value) throws WMSEventException {
        String keystr = value.getKey();
        if (keystr.startsWith("_")) {
            throw new WMSEventException("Unable to add data for " + key + ". (Why? : _* values not supported for LibProperty)");
        }
        if (!LibProps.containsKey(keystr)) {
            throw new WMSEventException("Unable to add data for " + key + ". (Why? : Invalid LibProperty given)");
        }
        this.config.put(key, LibProps.getValue(keystr));
    }

    public void addHeader(String key, String value) throws WMSEventException {
        if (!key.startsWith("X-")) {
            throw new WMSEventException("Unable to add Header " + key + ", (Why? : Only X-* headers supported)");
        }
        this.header.put(key, value);
    }

    public void setCookie(String cookie) {
        this.header.put("Cookie", cookie);
    }

    public int getStatus() {
        return this.status;
    }

    public long getCreatedTime() {
        return this.ctime;
    }

    public String getId() {
        return this.id;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setResponse(PEXResponse response) {
        this.response = response;
    }

    public PEXResponse getResponse() {
        return this.response;
    }

    public boolean isTask() {
        return this.type == 1;
    }

    public boolean isRequest() {
        return this.type == 2;
    }

    public boolean isProgRequest() {
        return this.type == 3;
    }

    protected abstract String getOperation();

    public Hashtable getObject() {
        Hashtable<String, Object> obj = new Hashtable<String, Object>();
        obj.put("i", this.id);
        obj.put("o", this.getOperation());
        if (!this.header.isEmpty()) {
            obj.put("h", this.header);
        }
        obj.put("d", this.data);
        if (!this.config.isEmpty()) {
            obj.put("c", this.config);
        }
        return obj;
    }

    public String toString() {
        return "" + this.getObject();
    }
}

