/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.pex;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.exception.WMSCommunicationException;
import com.adventnet.wms.common.pex.PEXConnectionHandler;
import com.adventnet.wms.common.pex.PEXError;
import com.adventnet.wms.common.pex.PEXEvent;
import com.adventnet.wms.common.pex.PEXEventHandler;
import com.adventnet.wms.common.pex.PEXException;
import com.adventnet.wms.common.pex.PEXReadyState;
import com.adventnet.wms.common.pex.PEXResponse;
import com.adventnet.wms.common.pex.PEXTimeOutListener;
import com.adventnet.wms.common.pex.credentials.PEXCredentials;
import com.adventnet.wms.common.websocket.WebSocket;
import com.adventnet.wms.common.websocket.WebSocketFactory;
import com.adventnet.wms.common.websocket.WebSocketHandler;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;

public class PEX {
    private static PEXConnectionHandler conhandler;
    private static final String DEF_SOCK_URL = "ws://wms.zoho.com/pconnect";
    private static String IAMTICKET_COOKIENAME;
    private static int PEX_CONN_STATUS;
    private static Object conLock;
    private static WSHandler wshandler;
    private static WebSocket ws;
    private static ConcurrentHashMap<String, PEXEvent> pexevents;
    private static long evttimeoutmsec;
    private static PEXCredentials credentials;
    private static String sockurl;
    private static HashMap headers;
    private static HashMap cookies;
    private static long sTime;

    public static void process(PEXEvent evt) throws PEXException, WMSCommunicationException {
        if (evt.getStatus() != 0) {
            throw new PEXException(107, "Invalid State");
        }
        if (PEX_CONN_STATUS != 1) {
            throw new PEXException(101, "No connection available");
        }
        evt.getHandler().onBeforeSend(evt);
        pexevents.put(evt.getId(), evt);
        PEXTimeOutListener.TRACKER.touch(evt);
        evt.setStatus(1);
        ws.write(HttpDataWraper.getString(evt.getObject()));
    }

    public static void setEventTimeout(int secs) {
        evttimeoutmsec = (long)secs * 1000L;
    }

    public static void process(PEXEvent evt, PEXEventHandler handler) throws PEXException, WMSCommunicationException {
        evt.setHandler(handler);
        PEX.process(evt);
    }

    public static void setHandler(PEXConnectionHandler conhandler) {
        PEX.conhandler = conhandler;
    }

    public static void init(String url, PEXCredentials credentials) throws WMSCommunicationException {
        PEX.init(url, credentials, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String url, PEXCredentials credentials, HashMap headers) throws WMSCommunicationException {
        Object object = conLock;
        synchronized (object) {
            if (PEX_CONN_STATUS > 0) {
                return;
            }
            PEX_CONN_STATUS = 2;
        }
        PEX.credentials = credentials;
        String connect_url = System.getProperty("pex.url");
        connect_url = connect_url == null ? (url == null ? DEF_SOCK_URL : url) : connect_url;
        connect_url = connect_url + "?nocache=" + System.currentTimeMillis();
        String prd = System.getProperty("pex.prd");
        String config = System.getProperty("pex.config");
        IAMTICKET_COOKIENAME = System.getProperty("iamticket.cookiename", IAMTICKET_COOKIENAME);
        if (prd != null) {
            connect_url = connect_url + "&prd=" + prd;
        }
        if (config != null) {
            connect_url = connect_url + "&config=" + config;
        }
        connect_url = connect_url + "&authtype=" + credentials.getType();
        if (credentials.getUserName() != null) {
            connect_url = connect_url + "&wmsid=" + credentials.getUserName();
        }
        if (credentials.getDisplayName() != null) {
            connect_url = connect_url + PEX.getParamString("dname", credentials.getDisplayName());
        }
        HashMap<String, String> cookies = new HashMap<String, String>();
        if (credentials.getKey() != null) {
            switch (credentials.getType()) {
                case 0: {
                    cookies.put(IAMTICKET_COOKIENAME, credentials.getKey());
                    break;
                }
                case 5: {
                    connect_url = connect_url + PEX.getParamString("ticket", credentials.getKey());
                    connect_url = connect_url + PEX.getParamString("bundleid", credentials.getAddInfo("bundleid"));
                    break;
                }
                case 1: {
                    connect_url = connect_url + PEX.getParamString("ticket", credentials.getKey());
                    connect_url = connect_url + PEX.getParamString("iscscope", credentials.getAddInfo("iscscope"));
                    break;
                }
                case 3: {
                    cookies.put(IAMTICKET_COOKIENAME, credentials.getKey());
                    connect_url = connect_url + PEX.getParamString("domain", credentials.getAddInfo("domain"));
                    break;
                }
                case 10: {
                    cookies.put(IAMTICKET_COOKIENAME, credentials.getKey());
                    connect_url = connect_url + PEX.getParamString("domain", credentials.getAddInfo("domain"));
                    break;
                }
                case 6: {
                    connect_url = connect_url + PEX.getParamString("key", credentials.getKey());
                    connect_url = connect_url + PEX.getParamString("zuid", credentials.getAddInfo("zuid"));
                }
            }
        }
        sockurl = connect_url;
        ws = WebSocketFactory.createSocket(connect_url);
        if (!cookies.isEmpty()) {
            PEX.cookies = cookies;
            ws.addCookies(cookies);
        }
        if (credentials.getUserAgent() != null) {
            ws.addHeader("User-Agent", credentials.getUserAgent());
        }
        if (headers != null) {
            PEX.headers = headers;
            ws.addHeaders(headers);
        }
        ws.setHandler(wshandler);
        ws.connect();
    }

    private static String getParamString(String name, Object value) {
        return "&" + name + "=" + URLEncoder.encode("" + value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reconnect() throws WMSCommunicationException {
        Object object = conLock;
        synchronized (object) {
            if (PEX_CONN_STATUS != 0) {
                return;
            }
            PEX_CONN_STATUS = 2;
        }
        ws = WebSocketFactory.createSocket(sockurl);
        if (cookies != null && !cookies.isEmpty()) {
            ws.addCookies(cookies);
        }
        if (credentials.getUserAgent() != null) {
            ws.addHeader("User-Agent", credentials.getUserAgent());
        }
        if (headers != null) {
            ws.addHeaders(headers);
        }
        ws.setHandler(wshandler);
        ws.connect();
    }

    public static void init(PEXCredentials credentials) throws WMSCommunicationException, PEXException {
        PEX.init(null, credentials);
    }

    public static void shutDown() throws WMSCommunicationException {
        if (ws != null) {
            ws.close();
        }
    }

    public static void hold() throws WMSCommunicationException {
        if (ws != null) {
            ws.hold();
        }
    }

    public static void resume() throws WMSCommunicationException {
        if (ws != null) {
            ws.resume();
        }
    }

    public static Long getConnectionTime() {
        return sTime;
    }

    static long getEventTimeout() {
        return evttimeoutmsec;
    }

    static void handleExpired(PEXEvent evt) {
        evt.getHandler().onTimeOut(evt);
        pexevents.remove(evt.getId());
    }

    static {
        IAMTICKET_COOKIENAME = "IAMAGENTTICKET";
        PEX_CONN_STATUS = -1;
        conLock = new Object();
        wshandler = new WSHandler();
        pexevents = new ConcurrentHashMap(500, 0.8f, 32);
    }

    static class WSHandler
    implements WebSocketHandler {
        WSHandler() {
        }

        @Override
        public void onOpen() {
            sTime = System.currentTimeMillis() - sTime;
            PEX_CONN_STATUS = 1;
            conhandler.onConnect();
        }

        @Override
        public void onMessage(String data) {
            ArrayList responsearr = (ArrayList)HttpDataWraper.getObject(data);
            for (Hashtable response : responsearr) {
                String eid = (String)response.get("eid");
                Integer seq = (Integer)response.get("seq");
                if (seq != null) {
                    try {
                        Hashtable<String, String> ack = new Hashtable<String, String>();
                        ack.put("s", String.valueOf(seq));
                        ws.write(HttpDataWraper.getString(ack));
                    }
                    catch (WMSCommunicationException ack) {
                        // empty catch block
                    }
                }
                if (eid == null) {
                    conhandler.onMessage(response);
                    continue;
                }
                int readstate = Integer.parseInt("" + response.get("rs"));
                PEXEvent evt = (PEXEvent)pexevents.get(eid);
                PEXEventHandler evh = evt.getHandler();
                if (evh == null) continue;
                if (readstate >= 0) {
                    PEXResponse pexres = evt.getResponse();
                    if (pexres != null && pexres.isProgressive()) {
                        pexres.addResponse((String)response.get("res"));
                    } else {
                        pexres = evt.isTask() ? new PEXResponse((Hashtable)response.get("res")) : new PEXResponse(response.get("res"), evt.isProgRequest());
                    }
                    evh.onProgress(pexres);
                    if (readstate != PEXReadyState.COMPLETED.getReadyState()) continue;
                    evh.onSuccess(pexres);
                    evh.onComplete(pexres, true);
                    PEXTimeOutListener.TRACKER.remove(evt);
                    pexevents.remove(eid);
                    continue;
                }
                PEXError pexerr = new PEXError((Hashtable)response.get("err"));
                evh.onFailure(pexerr);
                evh.onComplete(null, false);
                PEXTimeOutListener.TRACKER.remove(evt);
                pexevents.remove(eid);
            }
        }

        @Override
        public void onClose(int code) {
            PEX_CONN_STATUS = 0;
            conhandler.onDisconnect();
        }
    }
}

