/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.nio;

import com.adventnet.wms.common.Base64;
import com.adventnet.wms.common.exception.WMSCommunicationException;
import com.adventnet.wms.common.exception.WMSException;
import com.adventnet.wms.common.nio.EventDispatcher;
import com.adventnet.wms.common.nio.HttpRequest;
import com.adventnet.wms.common.nio.HttpRequestEventListener;
import com.adventnet.wms.common.nio.PingTimeOutListener;
import com.adventnet.wms.common.nio.ReadTimeOutListener;
import com.adventnet.wms.common.nio.SelectorPoolFactory;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;

public class WebSocketRequest
extends HttpRequest {
    private static Logger logger = Logger.getLogger(WebSocketRequest.class.getName());
    private boolean handshakedone = false;
    private ByteBuffer wsdataBuffer = null;
    private ReadFrame rf = null;
    private Random random = new Random(System.currentTimeMillis());
    private final int VERSION = 13;
    protected int readtimeout = 300000;
    public static final int OPCODE_CONTINUATION = 0;
    public static final int OPCODE_TEXT = 1;
    public static final int OPCODE_BINARY = 2;
    public static final int OPCODE_CLOSE = 8;
    public static final int OPCODE_PING = 9;
    public static final int OPCODE_PONG = 10;
    private int ping_interval = 15000;
    private long lastpingtime = System.currentTimeMillis();
    private long lastresptime = System.currentTimeMillis();
    private ConcurrentLinkedQueue writeQueue = new ConcurrentLinkedQueue();

    public WebSocketRequest(String url, int port, HttpRequestEventListener listener) throws Exception {
        super(url, port, "GET", listener);
    }

    @Override
    public void connect() throws IOException {
        this.addHeader("Upgrade", "websocket");
        this.addHeader("Connection", "Upgrade");
        this.addHeader("Sec-WebSocket-Version", "13");
        this.addHeader("Sec-WebSocket-Key", Base64.encodeByte(this.getRandomBytes(16)));
        this.createRequestWrapper();
        SelectorPoolFactory.getInstance(this.port).connect(this.host, this.port, this);
    }

    public void setPingInterval(int seconds) {
        this.ping_interval = seconds * 1000;
    }

    @Override
    public void readData(SelectionKey key) throws IOException, CancelledKeyException {
        if (this.key == null) {
            this.key = key;
        }
        int count = -1;
        if (this.isSSL) {
            if (this.ssl.doHandshake(key)) {
                count = this.ssl.read();
                this.byteBuffer = this.ssl.getDataBuffer();
            }
        } else {
            count = ((SocketChannel)key.channel()).read(this.byteBuffer);
        }
        if (count > 0) {
            this.zeroReadCount = 0;
            this.lastresptime = System.currentTimeMillis();
            if (this.isHeaderComplete(this.byteBuffer) && this.handshakedone) {
                block26: {
                    int pendingcount = count;
                    while (true) {
                        if (this.wsdataBuffer == null) {
                            try {
                                this.rf = this.getReadFrame(this.byteBuffer);
                            }
                            catch (WMSException wex) {
                                this.key.interestOps(1);
                                break block26;
                            }
                            if (this.rf.isCloseFrame()) {
                                this.close();
                                EventDispatcher.process(this, -4);
                                return;
                            }
                            int plsize = this.rf.getPayloadSize();
                            if (plsize < 0) {
                                this.close();
                                EventDispatcher.process(this, -4);
                                return;
                            }
                            if (plsize == 0) continue;
                            this.wsdataBuffer = ByteBuffer.allocate(plsize);
                            int clen = plsize;
                            if (this.byteBuffer.remaining() < plsize) {
                                clen = this.byteBuffer.remaining();
                            }
                            if (clen > 0) {
                                byte[] wsresponse = new byte[clen];
                                this.byteBuffer.get(wsresponse);
                                this.wsdataBuffer.put(wsresponse);
                                if (clen == plsize) {
                                    if (this.rf.isValidFrame()) {
                                        this.response.addChunk(wsresponse);
                                        EventDispatcher.process(this, 3);
                                    }
                                    this.rf = null;
                                    key.interestOps(1);
                                    int chunkDatalen = wsresponse.length;
                                    pendingcount -= chunkDatalen;
                                    wsresponse = null;
                                    this.wsdataBuffer = null;
                                    if (this.byteBuffer.hasRemaining()) {
                                        continue;
                                    }
                                } else {
                                    key.interestOps(1);
                                }
                            } else {
                                key.interestOps(1);
                            }
                        }
                        if (!this.byteBuffer.hasRemaining()) {
                            key.interestOps(1);
                            this.clearBuffer(this.byteBuffer);
                            return;
                        }
                        if (this.wsdataBuffer.limit() - this.wsdataBuffer.position() > pendingcount) break;
                        byte[] data = new byte[this.wsdataBuffer.limit() - this.wsdataBuffer.position()];
                        this.byteBuffer.get(data);
                        this.wsdataBuffer.put(data);
                        int dataLen = data.length;
                        byte[] wsData = new byte[this.wsdataBuffer.limit()];
                        this.wsdataBuffer.flip();
                        this.wsdataBuffer.get(wsData);
                        if (this.rf.isValidFrame()) {
                            this.response.addChunk(wsData);
                            EventDispatcher.process(this, 3);
                        }
                        this.rf = null;
                        wsData = null;
                        this.wsdataBuffer = null;
                        key.interestOps(1);
                        pendingcount -= dataLen;
                        data = null;
                    }
                    byte[] data = new byte[pendingcount];
                    this.byteBuffer.get(data);
                    this.wsdataBuffer.put(data);
                    data = null;
                    this.clearBuffer(this.byteBuffer);
                    key.interestOps(1);
                    return;
                }
                this.clearBuffer(this.byteBuffer);
            } else {
                key.interestOps(1);
            }
        } else {
            if (count < 0) {
                throw new IOException("Read -1");
            }
            if (count == 0) {
                ++this.zeroReadCount;
                key.interestOps(1);
                if (this.zeroReadCount > this.maxZeroReadCount) {
                    throw new IOException("Key Read Count = 0 : Max Crossed");
                }
            }
        }
    }

    public ReadFrame getReadFrame(ByteBuffer bb) throws WMSException {
        int i = bb.position();
        int payloadSize = -1;
        boolean finSet = true;
        int opcode = 0;
        if (bb.remaining() == 0) {
            throw new WMSException("Insufficient Data");
        }
        byte header = bb.get(i);
        ++i;
        finSet = (header >> 7 & 1) == 1;
        opcode = header & 0xF;
        if (opcode == 8) {
            ReadFrame rf = new ReadFrame(opcode);
            return rf;
        }
        if (bb.remaining() < 2) {
            throw new WMSException("Insufficient Data");
        }
        byte plen = bb.get(i);
        ++i;
        if (plen > 0 && plen < 126) {
            payloadSize = plen;
        } else if (plen == 126) {
            if (bb.remaining() < 4) {
                throw new WMSException("Insufficient Data");
            }
            payloadSize = bb.get(i) << 8 | bb.get(i + 1) & 0xFF;
            i += 2;
        } else if (plen == 127) {
            if (bb.remaining() < 10) {
                throw new WMSException("Insufficient Data");
            }
            payloadSize = (((((((bb.get(i) & 0xFF) << 8 | bb.get(i + 1) & 0xFF) << 8 | bb.get(i + 2) & 0xFF) << 8 | bb.get(i + 3) & 0xFF) << 8 | bb.get(i + 4) & 0xFF) << 8 | bb.get(i + 5) & 0xFF) << 8 | bb.get(i + 6) & 0xFF) << 8 | bb.get(i + 7) & 0xFF;
            i += 8;
        }
        if (payloadSize < 1) {
            payloadSize = 0;
        }
        bb.position(i);
        ReadFrame rf = new ReadFrame(opcode, payloadSize, finSet);
        return rf;
    }

    @Override
    public void parseResponse(ByteBuffer bb) throws IOException {
        if (!this.headerread) {
            bb.flip();
            byte[] headerData = new byte[this.headerLength];
            bb.get(headerData);
            BufferedReader br = new BufferedReader(new StringReader(new String(headerData)));
            String line = br.readLine();
            String[] tokens = line.split(" ");
            String version = tokens[0];
            String responsecode = tokens[1];
            String responsestatusmsg = tokens[2];
            this.response.setResponseCode(responsecode);
            this.response.setResponseMessage(responsestatusmsg);
            String rawUrl = tokens[1];
            while ((line = br.readLine()) != null && !line.equals("")) {
                tokens = line.split(": ", 2);
                if (tokens.length == 2) {
                    this.response.addHeader(tokens[0].toLowerCase(), tokens[1]);
                    continue;
                }
                logger.info("MALFORMWRONGHEADER " + line);
            }
            headerData = null;
            if (this.response.getResponseHeader("upgrade") != null && this.response.getResponseHeader("upgrade").toLowerCase().equals("websocket") && this.response.getResponseHeader("connection") != null && this.response.getResponseHeader("connection").toLowerCase().equals("upgrade")) {
                this.handshakedone = true;
                this.response.prepareWSResponseQueue();
                this.pingExpireTime = System.currentTimeMillis() + (long)this.ping_interval;
                PingTimeOutListener.TRACKER.touch(this.pingExpireTime, this);
                ReadTimeOutListener.TRACKER.remove(this.readexpiretime, this);
                this.onHandshake();
            } else {
                EventDispatcher.process(this, -1);
                this.close();
            }
        }
        this.headerread = true;
    }

    public void write(String msg) throws IOException {
        if (this.closed) {
            throw new IOException("Connection isn't alive");
        }
        try {
            this.writeQueue.add(new WriteFrame(1, msg));
        }
        catch (WMSCommunicationException wcex) {
            throw new IOException("Write Failure");
        }
        if (this.handshakedone) {
            try {
                this.onHandshake();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void write(byte[] msg) throws IOException {
        if (this.closed) {
            throw new IOException("Connection isn't alive");
        }
        try {
            this.writeQueue.add(new WriteFrame(2, msg));
        }
        catch (WMSCommunicationException wcex) {
            throw new IOException("Write Failure");
        }
        if (this.handshakedone) {
            try {
                this.onHandshake();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void onHandshake() {
        WriteFrame frame = null;
        while ((frame = (WriteFrame)this.writeQueue.poll()) != null) {
            try {
                this.writeWSData(frame);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void close() {
        try {
            this.writeWSData(new WriteFrame(8, ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
        PingTimeOutListener.TRACKER.remove(this.pingExpireTime, this);
        try {
            ReadTimeOutListener.TRACKER.remove(this.readexpiretime, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.isSSL) {
                this.ssl.close();
            } else {
                this.sc.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.key.channel().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.key.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closed = true;
    }

    @Override
    public void doPing() {
        try {
            WriteFrame frame = (WriteFrame)this.writeQueue.poll();
            if (frame == null) {
                this.writeWSData(new WriteFrame(1, "-"));
            } else {
                this.writeWSData(frame);
            }
            this.lastpingtime = System.currentTimeMillis();
            long oldTime = this.pingExpireTime;
            this.pingExpireTime = System.currentTimeMillis() + (long)this.ping_interval;
            PingTimeOutListener.TRACKER.update(oldTime, this.pingExpireTime, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeWSData(WriteFrame frame) throws Exception {
        if (frame == null) {
            return;
        }
        ByteBuffer writeBB = ByteBuffer.wrap(frame.getBytes());
        if (this.isSSL) {
            this.ssl.write(writeBB);
        } else {
            while (writeBB.hasRemaining()) {
                int written = this.sc.write(writeBB);
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {}
            }
        }
    }

    public long getLastPingTime() {
        return this.lastpingtime;
    }

    public long getLastRespTime() {
        return this.lastresptime;
    }

    public boolean isInactive() {
        return this.lastresptime < this.lastpingtime && System.currentTimeMillis() - this.lastresptime > (long)(this.ping_interval * 5);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private byte[] getRandomBytes(int len) {
        byte[] rb = new byte[len];
        this.random.nextBytes(rb);
        return rb;
    }

    class WriteFrame {
        private byte opcode;
        private byte[] data;

        public WriteFrame(int opcode, String strData) throws WMSCommunicationException {
            this(opcode, strData, true);
        }

        public WriteFrame(int opcode, byte[] byteData) throws WMSCommunicationException {
            this(opcode, byteData, true);
        }

        public WriteFrame(int opcode, String strData, boolean mask) throws WMSCommunicationException {
            try {
                this.opcode = (byte)opcode;
                this.data = this.prepareFrame(strData.getBytes("UTF-8"), mask);
            }
            catch (WMSCommunicationException wce) {
                throw wce;
            }
            catch (Exception e) {
                throw new WMSCommunicationException("Unable to prepare write frame [TEXT] : " + e.getMessage());
            }
        }

        public WriteFrame(int opcode, byte[] byteData, boolean mask) throws WMSCommunicationException {
            try {
                this.opcode = (byte)opcode;
                this.data = this.prepareFrame(byteData, mask);
            }
            catch (WMSCommunicationException wce) {
                throw wce;
            }
            catch (Exception e) {
                throw new WMSCommunicationException("Unable to prepare write frame [BINARY] : " + e.getMessage());
            }
        }

        public byte[] getBytes() {
            return this.data;
        }

        private byte[] prepareFrame(byte[] rawData, boolean mask) throws WMSCommunicationException {
            try {
                byte[] b;
                ByteArrayOutputStream wf = new ByteArrayOutputStream(rawData.length + 10);
                wf.write((byte)(0x80 | this.opcode));
                int length = rawData.length;
                int lf = 0;
                if (length < 126) {
                    lf = length;
                    lf = mask ? 0x80 | lf : lf;
                    wf.write((byte)lf);
                } else if (length <= 65535) {
                    lf = 126;
                    lf = mask ? 0x80 | lf : lf;
                    wf.write((byte)lf);
                    b = new byte[]{(byte)(length >>> 8), (byte)(length & 0xFF)};
                    wf.write(b);
                } else if (length > 65535) {
                    lf = 127;
                    lf = mask ? 0x80 | lf : lf;
                    wf.write((byte)lf);
                    b = new byte[]{(byte)(length >>> 56), (byte)(length >>> 48), (byte)(length >>> 40), (byte)(length >>> 32), (byte)(length >>> 24), (byte)(length >>> 16), (byte)(length >>> 8), (byte)(length & 0xFF)};
                    wf.write(b);
                }
                if (mask) {
                    byte[] maskValue = WebSocketRequest.this.getRandomBytes(4);
                    wf.write(maskValue);
                    for (int i = 0; i < rawData.length; ++i) {
                        int n = i;
                        rawData[n] = (byte)(rawData[n] ^ maskValue[i % 4]);
                    }
                }
                wf.write(rawData);
                return wf.toByteArray();
            }
            catch (Exception e) {
                throw new WMSCommunicationException("Unable to prepare write frame : " + e.getMessage());
            }
        }

        public boolean isCloseFrame() {
            return this.opcode == 8;
        }
    }

    class ReadFrame {
        private int payloadSize = -1;
        private int opcode = 0;
        private boolean finSet = true;

        public ReadFrame(int opcode) {
            this.opcode = opcode;
        }

        public ReadFrame(int opcode, int payloadSize, boolean finSet) {
            this.payloadSize = payloadSize;
            this.opcode = opcode;
            this.finSet = finSet;
        }

        public int getPayloadSize() {
            return this.payloadSize;
        }

        public boolean isValidFrame() {
            return this.opcode == 1 || this.opcode == 2;
        }

        public boolean isCloseFrame() {
            return this.opcode == 8;
        }
    }
}

