/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.nio;

import com.adventnet.wms.common.nio.EventDispatcher;
import com.adventnet.wms.common.nio.HttpRequest;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class NetworkEventProcessor {
    private static LinkedBlockingQueue queue = new LinkedBlockingQueue();
    private static ThreadPoolExecutor executor;
    private static boolean initialized;

    public static synchronized void initialize(int threadCount) {
        if (initialized) {
            return;
        }
        executor = new ThreadPoolExecutor(threadCount, threadCount, 100L, TimeUnit.MILLISECONDS, queue);
        initialized = true;
    }

    public static void process(HttpRequest request, int eventcode) {
        if (!initialized) {
            NetworkEventProcessor.initialize(2);
        }
        executor.execute(new RequestNetworkEventProcessor(request, eventcode));
    }

    static {
        initialized = false;
    }

    static class RequestNetworkEventProcessor
    implements Runnable {
        private HttpRequest request;
        private int eventcode;

        public RequestNetworkEventProcessor(HttpRequest request, int eventcode) {
            this.request = request;
            this.eventcode = eventcode;
        }

        @Override
        public void run() {
            try {
                switch (this.eventcode) {
                    case 1: {
                        try {
                            this.request.writeData();
                            EventDispatcher.process(this.request, 2);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            if (this.request.isClosed()) break;
                            try {
                                this.request.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            EventDispatcher.process(this.request, -3);
                        }
                        break;
                    }
                    case -5: {
                        if (this.request.isClosed()) break;
                        try {
                            this.request.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        EventDispatcher.process(this.request, -5);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

