/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.nio;

import com.adventnet.wms.common.nio.EventDispatcher;
import com.adventnet.wms.common.nio.HttpRequest;
import com.adventnet.wms.common.nio.NetworkEventProcessor;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class NIONetDataProcessor {
    private static Logger logger = Logger.getLogger(NIONetDataProcessor.class.getName());
    private static LinkedBlockingQueue queue = new LinkedBlockingQueue();
    private static ThreadPoolExecutor executor = null;
    private static LinkedBlockingQueue highpriorityqueue = new LinkedBlockingQueue();
    private static ThreadPoolExecutor highpriorityexecutor = null;
    private static boolean initialized = false;

    public static void initialize(int threadCount, int maxThreadCount) {
        NIONetDataProcessor.initialize(threadCount, maxThreadCount, -1, -1);
    }

    public static void initialize(int threadCount, int maxThreadCount, int highprioritythreadcount, int maxhighprioritythreadcount) {
        if (!initialized) {
            executor = new ThreadPoolExecutor(threadCount, maxThreadCount, 100L, TimeUnit.MILLISECONDS, queue);
            if (highprioritythreadcount != -1) {
                highpriorityexecutor = new ThreadPoolExecutor(highprioritythreadcount, maxhighprioritythreadcount, 100L, TimeUnit.MILLISECONDS, highpriorityqueue);
            }
            initialized = true;
        }
    }

    public static void process(SelectionKey key, int readyops) {
        HttpRequest requestObj = (HttpRequest)key.attachment();
        if (requestObj == null) {
            try {
                key.channel().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                key.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (!key.isValid() || !((SocketChannel)key.channel()).isOpen()) {
            key.cancel();
            readyops = -1;
        }
        if (requestObj.isHighPriority()) {
            highpriorityexecutor.execute(new Processor(key, readyops));
        } else {
            executor.execute(new Processor(key, readyops));
        }
    }

    static class Processor
    implements Runnable {
        private SelectionKey key = null;
        private int readyops;

        public Processor(SelectionKey key, int readyops) {
            this.key = key;
            this.readyops = readyops;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block27: {
                HttpRequest request = null;
                try {
                    request = (HttpRequest)this.key.attachment();
                    Object object = request.getLockObject();
                    synchronized (object) {
                        if (this.readyops == -1 || !this.key.isValid() || !((SocketChannel)this.key.channel()).isOpen()) {
                            logger.warning("Key not valid for request " + request);
                            NetworkEventProcessor.process(request, -5);
                            return;
                        }
                        if ((this.readyops & 1) == 1 || (this.readyops & 4) == 4) {
                            if (request.isSSL()) {
                                if (!request.isHSDone()) {
                                    try {
                                        boolean status = request.doHandshake(this.key);
                                        if (status) {
                                            request.setHSDone();
                                            NetworkEventProcessor.process(request, 1);
                                        }
                                        this.key.interestOps(5);
                                    }
                                    catch (IOException ioex) {
                                        EventDispatcher.process(request, -1);
                                        throw ioex;
                                    }
                                } else {
                                    request.readData(this.key);
                                    this.key.interestOps(1);
                                }
                            } else {
                                request.readData(this.key);
                                this.key.interestOps(1);
                            }
                        }
                    }
                }
                catch (CancelledKeyException cke) {
                    NetworkEventProcessor.process(request, -5);
                    try {
                        request.close();
                    }
                    catch (Exception ioex) {
                        // empty catch block
                    }
                    try {
                        this.key.channel().close();
                    }
                    catch (Exception ex) {
                        logger.severe("Exception during channel close " + ex.getMessage());
                    }
                    this.key.cancel();
                }
                catch (IOException excep) {
                    NetworkEventProcessor.process(request, -5);
                    logger.info("SEVERE : NIONetDataProcessor : IOException  [ATTACHMENT] " + this.key.attachment() + " [MESSAGE] " + excep.getMessage());
                    try {
                        request.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    try {
                        this.key.channel().close();
                    }
                    catch (Exception ex) {
                        logger.severe("Exception during channel close " + ex.getMessage());
                    }
                    this.key.cancel();
                }
                catch (Exception e) {
                    NetworkEventProcessor.process(request, -5);
                    if (this.key == null) break block27;
                    this.key.cancel();
                    this.key.attach(null);
                    return;
                }
            }
            if (this.key != null && this.key.isValid() && this.key.interestOps() == 0) {
                try {
                    this.key.interestOps(1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

