/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.nio;

import com.adventnet.wms.common.nio.HttpResponse;
import java.util.HashMap;

public class HttpRequestWrapper {
    private boolean https;
    private String url;
    private HashMap<String, String> headerMap;
    private HashMap paramMap;
    private HttpResponse response;
    private String host;
    private int port;
    private String uri;
    private String reqType;

    public HttpRequestWrapper(String host, int port, String rMethod, boolean https, String url, HashMap headerMap, HashMap paramMap) {
        this.host = host;
        this.port = port;
        this.https = https;
        this.url = url;
        this.headerMap = headerMap;
        this.paramMap = paramMap;
        this.reqType = rMethod;
    }

    public String getHost() {
        return this.host;
    }

    public String getCompleteHost() {
        if (this.port == 80) {
            return "http://" + this.host;
        }
        if (this.port == 443) {
            return "https://" + this.host;
        }
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isHttps() {
        return this.https;
    }

    public String getURL() {
        return this.url;
    }

    public HashMap getHeaderMap() {
        return this.headerMap;
    }

    public HashMap getParamMap() {
        return this.paramMap;
    }

    public String getRequestMethod() {
        return this.reqType;
    }

    public void setResponse(HttpResponse resp) {
        this.response = resp;
    }

    public void setURI(String requri) {
        this.uri = requri;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public String getRequestURI() {
        return this.uri;
    }

    public String toString() {
        return "[HOST]:" + this.host + ",[PORT]:" + this.port + ",[ISHTTPS]:" + this.https + ",[URL]:" + this.url + ",[HEADERS]:" + this.headerMap + ",[PARAMS]:" + this.paramMap;
    }
}

