/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.nio;

import com.adventnet.wms.common.nio.EventDispatcher;
import com.adventnet.wms.common.nio.HttpRequestEventListener;
import com.adventnet.wms.common.nio.HttpRequestWrapper;
import com.adventnet.wms.common.nio.HttpResponse;
import com.adventnet.wms.common.nio.KeyValueProp;
import com.adventnet.wms.common.nio.ReadTimeOutListener;
import com.adventnet.wms.common.nio.SSLManager;
import com.adventnet.wms.common.nio.SSLWrapper;
import com.adventnet.wms.common.nio.SelectorPoolFactory;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import sun.misc.BASE64Encoder;

public class HttpRequest {
    private static Logger logger = Logger.getLogger(HttpRequest.class.getName());
    private boolean hsdone = false;
    protected boolean isSSL = false;
    protected ByteBuffer byteBuffer = null;
    protected ByteBuffer writeBB = null;
    protected String url = null;
    protected String host = null;
    protected String connecthost = null;
    protected String proxyUsername = "proxy";
    protected String proxyPassword = "proxy";
    protected int port = -1;
    protected int connectport = -1;
    private String uri = null;
    private String reqType = null;
    protected int zeroReadCount = 0;
    protected int maxZeroReadCount = 25;
    protected static final int MAX_SIZE = 3072;
    protected int inputdatasize = 3072;
    private static String NEWLINE = "\r\n";
    protected HttpResponse response = null;
    protected boolean headerread = false;
    protected boolean isProxyConnectRequest = false;
    protected int headerLength = 0;
    private ByteBuffer bodyBuffer = null;
    private ByteBuffer chunkBuffer = null;
    protected SSLWrapper ssl = null;
    protected SocketChannel sc = null;
    private ByteArrayOutputStream headerbaos = new ByteArrayOutputStream();
    private ByteArrayOutputStream bodybaos = null;
    protected HttpRequestWrapper requestWrapper = null;
    protected boolean https = false;
    private boolean requestComplete = false;
    private boolean headerComplete = false;
    private StringBuffer paramBuffer = new StringBuffer();
    private HashMap headerMap = new HashMap();
    private HashMap paramMap = new HashMap();
    protected HttpRequestEventListener listener = null;
    private HttpRequestEventListener requestListener = null;
    protected int readtimeout = 30000;
    protected long readexpiretime = -1L;
    protected long pingExpireTime = -1L;
    protected boolean closed = false;
    protected boolean timeoutstate = true;
    protected SelectionKey key = null;
    private boolean bufferingConnection = true;
    private ByteArrayOutputStream streamBuffer = null;
    private boolean closeConnection = false;
    private int pendingnlcut = 0;
    private int MAX_RESP_CHUNK_QUEUE_LIMIT = 25;
    protected int pendingcount = 0;
    private boolean delimited = false;
    private boolean highpriority = false;
    private ByteBuffer delimitedBuffer = null;
    private ByteArrayOutputStream delimbaos = new ByteArrayOutputStream();
    protected boolean tmentryadded = false;
    private boolean requestSubmitted = false;
    protected Object lock = new Object();
    private boolean writeCompleted = false;
    private boolean http2 = false;

    public HttpRequest(String url, int port, String reqType, HttpRequestEventListener listener) throws Exception {
        this(url, port, reqType, listener, false);
    }

    public HttpRequest(String url, int port, String reqType, HttpRequestEventListener listener, boolean http2) throws Exception {
        this.url = url;
        this.connecthost = this.host = this.getHost();
        this.port = port;
        if (this.port == -1) {
            this.port = this.getPort();
        }
        this.connectport = port;
        this.uri = this.getURI();
        this.reqType = reqType;
        this.listener = listener;
        this.requestListener = listener;
        this.http2 = http2;
        if (!(http2 || reqType != null && (reqType.equals("GET") || reqType.equals("POST") || reqType.equals("PUT") || reqType.equals("DELETE")))) {
            throw new Exception("Request type invalid");
        }
        if (this.isHttps()) {
            this.isSSL = true;
        }
        this.intializeDefaultParams();
        this.byteBuffer = ByteBuffer.allocate(3072);
    }

    public void setReadBufferSize(int size) {
        this.byteBuffer = ByteBuffer.allocate(size);
    }

    public void setProxy(String host, int port) throws IOException {
        this.setProxy(host, port, null, null);
    }

    public void setProxy(String host, int port, String username, String password) throws IOException {
        this.connecthost = host;
        this.connectport = port;
        this.proxyUsername = username;
        this.proxyPassword = password;
        if (username != null && password != null) {
            this.addHeader("Proxy-Authorization", "Basic " + new BASE64Encoder().encode((username + ":" + password).getBytes("UTF-8")), false);
        }
        if (this.isSSL) {
            this.isProxyConnectRequest = true;
            this.isSSL = false;
            ProxyImpl impl = new ProxyImpl();
            impl.setRequest(this);
            this.listener = impl;
        }
    }

    public void setAsyncMode(boolean isAsync) {
        boolean bl = this.bufferingConnection = !isAsync;
        if (!this.bufferingConnection) {
            this.clearEOFBuffer();
        }
    }

    public void setDelimited() {
        this.delimited = true;
    }

    public void setHighPriority() {
        this.highpriority = true;
    }

    public boolean isHighPriority() {
        return this.highpriority;
    }

    public void setResponseChunkQueueLimit(int limit) {
        this.MAX_RESP_CHUNK_QUEUE_LIMIT = limit;
    }

    public void resetDefaults() {
        this.headerComplete = false;
        this.headerread = false;
        this.requestComplete = false;
    }

    private void intializeDefaultParams() {
        try {
            this.addHeader("Host", this.host + ":" + this.port, false);
            this.addHeader("User-agent", "Java", false);
            this.addHeader("connection", "keep-alive", false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setRequestListener() {
        this.listener = this.requestListener;
    }

    public void setRequestURI(String reqUri) {
        this.uri = reqUri;
    }

    public void setReadTimeout(int timeout) {
        this.readtimeout = timeout;
    }

    public int getReadTimeout() {
        return this.readtimeout;
    }

    public void setTimeOutState(boolean state) {
        this.timeoutstate = state;
    }

    public String getHost() {
        return this.url.replaceAll("http://|https://|ws://|wss://", "").replaceAll(":.*", "").replaceAll("/.*", "");
    }

    private int getPort() {
        try {
            String port = this.url.replaceAll("http://|https://|www.|ws://|wss://", "").replaceAll("/.*", "").split(":")[1];
            return Integer.parseInt(port);
        }
        catch (Exception ex) {
            if (this.isHttps()) {
                return 443;
            }
            return 80;
        }
    }

    private String getURI() {
        try {
            String tmp = this.host.replaceAll("http://|https://|www.|ws://|wss://", "");
            tmp = tmp.substring(tmp.indexOf("/"));
            return tmp;
        }
        catch (Exception ex) {
            return "/";
        }
    }

    public void setSocketChannel(SocketChannel sc) {
        try {
            this.sc = sc;
            if (this.isSSL) {
                this.ssl = new SSLWrapper(sc, SSLManager.getSSLClientContext(this.getHost()), this.getHost());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setHSDone() {
        this.hsdone = true;
    }

    public boolean isHSDone() {
        return this.hsdone;
    }

    public boolean isSSL() {
        return this.isSSL;
    }

    public void addHeader(ArrayList headerList) {
        for (int i = 0; i < headerList.size(); ++i) {
            try {
                KeyValueProp param = (KeyValueProp)headerList.get(i);
                this.addHeader(param.getName(), param.getValue(), false);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addHeader(String header, String value) throws IOException {
        this.addHeader(header, value, true);
    }

    public void addHeader(String header, String value, boolean encode) throws IOException {
        if (encode) {
            value = URLEncoder.encode(value, "UTF-8");
        }
        this.headerMap.put(header, value);
        this.headerbaos.write((header + ": " + value + NEWLINE).getBytes("UTF-8"));
    }

    public void addParam(String param, String value) throws IOException {
        this.addParam(param, value, true);
    }

    public void addParam(String param, String value, boolean encode) throws IOException {
        if (encode) {
            value = URLEncoder.encode(value, "UTF-8");
        }
        if (this.paramMap.size() > 0 && this.paramBuffer.length() > 0) {
            this.paramBuffer.append("&");
        }
        this.paramMap.put(param, value);
        this.paramBuffer.append(param + "=" + value);
    }

    public void setBody(String data) throws IOException {
        if (this.bodybaos == null) {
            this.bodybaos = new ByteArrayOutputStream();
        }
        if (data != null && !data.equals("")) {
            this.bodybaos.write(data.getBytes("UTF-8"));
            this.inputdatasize += this.bodybaos.toByteArray().length;
        }
    }

    public void setBody(byte[] data) throws IOException {
        if (this.bodybaos == null) {
            this.bodybaos = new ByteArrayOutputStream();
        }
        if (data != null && data.length > 0) {
            this.bodybaos.write(data);
            this.inputdatasize += this.bodybaos.toByteArray().length;
        }
    }

    public void connect() throws IOException {
        this.createRequestWrapper();
        if (this.highpriority) {
            SelectorPoolFactory.getHighPriorityInstance(this.port).connect(this.connecthost, this.connectport, this);
        } else {
            SelectorPoolFactory.getInstance(this.port).connect(this.connecthost, this.connectport, this);
        }
    }

    public void registerReadWrite() throws IOException {
        if (this.highpriority) {
            SelectorPoolFactory.getHighPriorityInstance(this.port).registerReadWrite(this.sc, this);
        } else {
            SelectorPoolFactory.getInstance(this.port).registerReadWrite(this.sc, this);
        }
    }

    public void createRequestWrapper() {
        this.requestWrapper = new HttpRequestWrapper(this.host, this.port, this.reqType, this.https, this.url, (HashMap)this.headerMap.clone(), (HashMap)this.paramMap.clone());
        if (!this.isProxyConnectRequest) {
            this.headerMap = null;
            this.paramMap = null;
        }
        this.requestWrapper.setURI(this.uri);
    }

    private boolean isHttps() {
        if (this.url.startsWith("https://") || this.url.startsWith("wss://")) {
            this.https = true;
            return this.https;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String fline;
            this.writeBB = ByteBuffer.allocate(this.inputdatasize);
            if (this.isProxyConnectRequest) {
                fline = "CONNECT " + this.host + ":" + this.port + " " + "HTTP/1.1" + NEWLINE + "Host" + ": " + this.host + ":" + this.port + NEWLINE + "Proxy-Authorization: Basic " + new BASE64Encoder().encode((this.proxyUsername + ":" + this.proxyPassword).getBytes("UTF-8")) + NEWLINE;
                this.writeBB.put(fline.getBytes("UTF-8"));
                this.writeBB.put(NEWLINE.getBytes());
            } else if (this.reqType.equals("GET") || this.reqType.equals("DELETE")) {
                if (this.paramBuffer.length() > 0) {
                    this.uri = this.uri + "?" + this.paramBuffer.toString();
                }
                fline = null;
                fline = !this.connecthost.equals(this.host) ? this.reqType + " " + this.url + "/" + this.uri + " " + "HTTP/1.1" + NEWLINE : this.reqType + " " + this.uri + " " + "HTTP/1.1" + NEWLINE;
                this.writeBB.put(fline.getBytes("UTF-8"));
                this.writeBB.put(this.headerbaos.toByteArray());
                this.writeBB.put(NEWLINE.getBytes());
                this.writeCompleted = true;
            } else if (this.reqType.equals("POST") || this.reqType.equals("PUT")) {
                if (this.paramBuffer.length() > 0) {
                    this.uri = this.uri + "?" + this.paramBuffer.toString();
                }
                fline = null;
                fline = !this.connecthost.equals(this.host) ? this.reqType + " " + this.url + "/" + this.uri + " " + "HTTP/1.1" + NEWLINE : this.reqType + " " + this.uri + " " + "HTTP/1.1" + NEWLINE;
                this.writeBB.put(fline.getBytes("UTF-8"));
                this.writeBB.put(this.headerbaos.toByteArray());
                this.writeBB.put(NEWLINE.getBytes("UTF-8"));
                if (this.bodybaos != null) {
                    this.writeBB.put(this.bodybaos.toByteArray());
                }
                this.writeBB.put(NEWLINE.getBytes("UTF-8"));
                this.writeCompleted = true;
            }
            if (this.isSSL) {
                this.writeBB.flip();
                while (this.writeBB.hasRemaining()) {
                    this.ssl.write(this.writeBB);
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception fline2) {}
                }
            } else {
                this.writeBB.flip();
                while (this.writeBB.hasRemaining()) {
                    int written = this.sc.write(this.writeBB);
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception exception) {}
                }
            }
            this.requestSubmitted = true;
            if (this.timeoutstate && !this.tmentryadded) {
                this.readexpiretime = System.currentTimeMillis() + (long)this.readtimeout;
                ReadTimeOutListener.TRACKER.touch(this.readexpiretime, this);
                this.tmentryadded = true;
            }
            if (!this.isProxyConnectRequest) {
                this.headerbaos = null;
                this.bodybaos = null;
            }
            this.writeBB = null;
        }
    }

    public long getReadExpireTime() {
        return this.readexpiretime;
    }

    public long getPingExpireTime() {
        return this.pingExpireTime;
    }

    public boolean isInvalidReadTimeoutEntry(long time) {
        return false;
    }

    public boolean isInvalidPingTimeoutEntry(long time) {
        return false;
    }

    public boolean isConnectionOpen() {
        try {
            return this.sc.isOpen();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void doPing() {
    }

    public boolean doHandshake(SelectionKey key) throws IOException {
        if (this.key == null) {
            this.key = key;
        }
        return this.ssl.doHandshake(key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readData(SelectionKey key) throws IOException, CancelledKeyException {
        if (this.key == null) {
            this.key = key;
        }
        int count = -1;
        if (this.isSSL) {
            if (!this.ssl.doHandshake(key) || !this.requestSubmitted) return;
            count = this.ssl.read();
            this.byteBuffer = this.ssl.getDataBuffer();
        } else {
            count = ((SocketChannel)key.channel()).read(this.byteBuffer);
        }
        if (count > 0) {
            this.zeroReadCount = 0;
            this.pendingcount = count;
            if (this.isHeaderComplete(this.byteBuffer)) {
                if (this.timeoutstate) {
                    long oldTime = this.readexpiretime;
                    this.readexpiretime = System.currentTimeMillis() + (long)this.readtimeout;
                    ReadTimeOutListener.TRACKER.update(oldTime, this.readexpiretime, this);
                }
                if (this.requestComplete) {
                    key.interestOps(1);
                    this.clearBuffer(this.byteBuffer);
                    return;
                }
                if (this.response.isChunked()) {
                    while (true) {
                        if (this.chunkBuffer == null) {
                            int chunklength;
                            if (this.byteBuffer.remaining() >= 2 && this.pendingnlcut == 2) {
                                this.byteBuffer.position(this.byteBuffer.position() + 2);
                                this.pendingnlcut = 0;
                            }
                            if ((chunklength = this.getChunkLength(this.byteBuffer)) == -1) {
                                key.interestOps(1);
                                this.copyPending(this.byteBuffer);
                                return;
                            }
                            if (chunklength == 0) {
                                if (this.bufferingConnection && this.streamBuffer != null && this.streamBuffer.size() > 0) {
                                    this.response.addChunk(this.streamBuffer.toByteArray());
                                    EventDispatcher.process(this, 3);
                                    this.clearEOFBuffer();
                                }
                                this.clearBuffer(this.byteBuffer);
                                if (this.response.isChunked()) {
                                    EventDispatcher.process(this, -5);
                                }
                                this.close();
                                return;
                            }
                            this.chunkBuffer = ByteBuffer.allocate(chunklength);
                            int clen = chunklength;
                            if (this.byteBuffer.remaining() < chunklength) {
                                clen = this.byteBuffer.remaining();
                            }
                            if (clen > 0) {
                                byte[] chunk = new byte[clen];
                                this.byteBuffer.get(chunk);
                                this.chunkBuffer.put(chunk);
                                if (clen == chunklength) {
                                    if (this.bufferingConnection) {
                                        try {
                                            this.streamBuffer.write(chunk);
                                            this.chunkBuffer = null;
                                        }
                                        catch (Exception ee) {
                                            ee.printStackTrace();
                                        }
                                    } else {
                                        if (!this.delimited) {
                                            this.response.addChunk(chunk);
                                            EventDispatcher.process(this, 3);
                                        } else {
                                            this.doDelimitedCheck(chunk);
                                        }
                                        this.chunkBuffer = null;
                                    }
                                    key.interestOps(1);
                                    if (this.byteBuffer.remaining() >= 2) {
                                        this.byteBuffer.position(this.byteBuffer.position() + 2);
                                    } else {
                                        this.pendingnlcut = 2;
                                    }
                                    int chunkDatalen = chunk.length;
                                    this.pendingcount -= chunkDatalen;
                                    chunk = null;
                                    if (this.byteBuffer.hasRemaining()) {
                                        continue;
                                    }
                                } else {
                                    key.interestOps(1);
                                }
                            } else {
                                key.interestOps(1);
                            }
                        }
                        if (!this.byteBuffer.hasRemaining()) {
                            key.interestOps(1);
                            this.clearBuffer(this.byteBuffer);
                            return;
                        }
                        if (this.chunkBuffer.limit() - this.chunkBuffer.position() > this.pendingcount) break;
                        byte[] data = new byte[this.chunkBuffer.limit() - this.chunkBuffer.position()];
                        this.byteBuffer.get(data);
                        this.chunkBuffer.put(data);
                        int dataLen = data.length;
                        byte[] chunkData = new byte[this.chunkBuffer.limit()];
                        this.chunkBuffer.flip();
                        this.chunkBuffer.get(chunkData);
                        if (this.bufferingConnection) {
                            try {
                                this.streamBuffer.write(chunkData);
                                this.chunkBuffer = null;
                                chunkData = null;
                            }
                            catch (Exception eee) {
                                eee.printStackTrace();
                            }
                        } else {
                            if (!this.delimited) {
                                this.response.addChunk(chunkData);
                                EventDispatcher.process(this, 3);
                            } else {
                                this.doDelimitedCheck(chunkData);
                            }
                            chunkData = null;
                            this.chunkBuffer = null;
                        }
                        key.interestOps(1);
                        if (this.byteBuffer.remaining() >= 2) {
                            this.byteBuffer.position(this.byteBuffer.position() + 2);
                        } else {
                            this.pendingnlcut = 2;
                        }
                        this.pendingcount -= dataLen;
                        data = null;
                    }
                    byte[] data = new byte[this.pendingcount];
                    this.byteBuffer.get(data);
                    this.chunkBuffer.put(data);
                    data = null;
                    this.clearBuffer(this.byteBuffer);
                    key.interestOps(1);
                    return;
                }
                if (!this.byteBuffer.hasRemaining()) {
                    key.interestOps(1);
                    this.clearBuffer(this.byteBuffer);
                    return;
                }
                if (this.bodyBuffer != null) {
                    if (this.bodyBuffer.limit() - this.bodyBuffer.position() <= this.byteBuffer.remaining()) {
                        byte[] data = new byte[this.bodyBuffer.limit() - this.bodyBuffer.position()];
                        this.byteBuffer.get(data);
                        this.bodyBuffer.put(data);
                        data = null;
                        byte[] responseData = new byte[this.bodyBuffer.limit()];
                        this.bodyBuffer.flip();
                        this.bodyBuffer.get(responseData);
                        this.response.setBody(responseData);
                        responseData = null;
                        EventDispatcher.process(this, 3);
                        this.close();
                        this.requestComplete = true;
                        this.bodyBuffer = null;
                    } else {
                        byte[] data = new byte[this.pendingcount];
                        this.byteBuffer.get(data);
                        this.bodyBuffer.put(data);
                        data = null;
                        key.interestOps(1);
                    }
                } else if (this.streamBuffer != null) {
                    byte[] data = new byte[this.pendingcount];
                    this.byteBuffer.get(data);
                    this.streamBuffer.write(data);
                    data = null;
                    key.interestOps(1);
                }
                this.clearBuffer(this.byteBuffer);
                return;
            } else if (this.closeConnection) {
                this.clearBuffer(this.byteBuffer);
                EventDispatcher.process(this, 3);
                this.close();
                return;
            } else {
                key.interestOps(1);
            }
            return;
        } else {
            if (count < 0) {
                throw new IOException("Read -1");
            }
            if (count != 0) return;
            ++this.zeroReadCount;
            key.interestOps(1);
            if (this.zeroReadCount <= this.maxZeroReadCount) return;
            throw new IOException("Key Read Count = 0 : Max Crossed");
        }
    }

    private void doDelimitedCheck(byte[] data) throws IOException {
        this.delimbaos.write(data);
        this.doDelimitedCheck();
    }

    private void doDelimitedCheck() throws IOException {
        byte[] chunk = this.delimbaos.toByteArray();
        if (this.delimitedBuffer == null) {
            boolean chunkpresent = false;
            for (int i = 0; i < chunk.length - 1 && !chunkpresent; ++i) {
                if (chunk[i] != 13 || chunk[i + 1] != 10) continue;
                try {
                    int delimlength = Integer.parseInt(new String(chunk, 0, i));
                    this.delimitedBuffer = ByteBuffer.allocate(delimlength);
                    this.delimbaos = new ByteArrayOutputStream();
                    if (chunk.length >= i + 2) {
                        this.delimbaos.write(chunk, i + 2, chunk.length - (i + 2));
                        this.doDelimitedCheck();
                    }
                    chunkpresent = true;
                    continue;
                }
                catch (NumberFormatException ex) {
                    this.delimbaos = new ByteArrayOutputStream();
                    if (chunk.length < i + 2) continue;
                    this.delimbaos.write(chunk, i + 2, chunk.length - (i + 2));
                    this.doDelimitedCheck();
                }
            }
        } else {
            int remdatalength = this.delimitedBuffer.limit() - this.delimitedBuffer.position();
            if (chunk.length < remdatalength) {
                this.delimitedBuffer.put(chunk);
                this.delimbaos = new ByteArrayOutputStream();
            } else if (chunk.length == remdatalength) {
                this.delimitedBuffer.put(chunk, 0, remdatalength);
                byte[] result = new byte[this.delimitedBuffer.limit()];
                this.delimitedBuffer.flip();
                this.delimitedBuffer.get(result, 0, result.length);
                this.delimitedBuffer = null;
                this.response.addChunk(result);
                EventDispatcher.process(this, 3);
                this.delimbaos = new ByteArrayOutputStream();
            } else {
                this.delimitedBuffer.put(chunk, 0, remdatalength);
                byte[] result = new byte[this.delimitedBuffer.limit()];
                this.delimitedBuffer.flip();
                this.delimitedBuffer.get(result, 0, result.length);
                this.delimitedBuffer = null;
                this.response.addChunk(result);
                EventDispatcher.process(this, 3);
                this.delimbaos = new ByteArrayOutputStream();
                this.delimbaos.write(chunk, remdatalength, chunk.length - remdatalength);
                this.doDelimitedCheck();
            }
        }
    }

    private void copyPending(ByteBuffer bb) {
        int rem = bb.remaining();
        if (rem == 0) {
            bb.clear();
            return;
        }
        byte[] remdata = new byte[rem];
        bb.get(remdata);
        bb.clear();
        bb.put(remdata);
        remdata = null;
    }

    protected void clearBuffer(ByteBuffer bb) {
        if (this.isSSL) {
            this.ssl.clearDataBuffer();
        }
        bb.clear();
    }

    private void clearEOFBuffer() {
        try {
            if (this.streamBuffer != null) {
                this.streamBuffer.reset();
                this.streamBuffer.close();
                this.streamBuffer = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean isHeaderComplete(ByteBuffer bb) throws IOException {
        if (this.headerComplete && this.headerread) {
            bb.flip();
            return true;
        }
        if (!this.headerComplete && !this.isProperHttpResponse(bb)) {
            this.closeConnection = true;
            this.response = new HttpResponse();
            this.response.setResponseCode("403");
            this.requestWrapper.setResponse(this.response);
            return this.headerComplete;
        }
        for (int i = 0; i <= bb.position() - 4 && !this.headerComplete; ++i) {
            if (bb.get(i) != 13 || bb.get(i + 1) != 10 || bb.get(i + 2) != 13 || bb.get(i + 3) != 10) continue;
            this.headerComplete = true;
            this.headerLength = i + 4;
        }
        if (this.headerComplete) {
            this.response = new HttpResponse();
            this.response.setResponseChunkQueueLimit(this.MAX_RESP_CHUNK_QUEUE_LIMIT);
            this.requestWrapper.setResponse(this.response);
            this.parseResponse(bb);
        }
        return this.headerComplete;
    }

    protected boolean isProperHttpResponse(ByteBuffer tempbb) {
        boolean validResponse = false;
        try {
            if (tempbb.get(0) == 72 && tempbb.get(1) == 84 && tempbb.get(2) == 84 && tempbb.get(3) == 80) {
                validResponse = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return validResponse;
    }

    protected int getChunkLength(ByteBuffer bb) throws IOException {
        int chunkcharcount = -1;
        boolean chunklengthpresent = false;
        int cntcharcount = 0;
        int remaining = bb.remaining();
        int i = bb.position();
        int counter = 2;
        while (counter < remaining && !chunklengthpresent) {
            if (bb.get(i) == 13 && bb.get(i + 1) == 10) {
                chunklengthpresent = true;
                chunkcharcount = cntcharcount;
            }
            counter += 2;
            ++i;
            ++cntcharcount;
        }
        if (chunklengthpresent) {
            byte[] lendata = new byte[chunkcharcount];
            bb.get(lendata);
            bb.get(new byte[2]);
            String chunklen = new String(lendata);
            int chunklength = Integer.parseInt(chunklen.trim(), 16);
            return chunklength;
        }
        return -1;
    }

    public void parseResponse(ByteBuffer bb) throws IOException {
        if (!this.headerread) {
            bb.flip();
            byte[] headerData = new byte[this.headerLength];
            bb.get(headerData);
            this.pendingcount -= headerData.length;
            BufferedReader br = new BufferedReader(new StringReader(new String(headerData)));
            String line = br.readLine();
            String[] tokens = line.split(" ");
            String version = tokens[0];
            String responsecode = tokens[1];
            String responsestatusmsg = tokens[2];
            this.response.setResponseCode(responsecode);
            this.response.setResponseMessage(responsestatusmsg);
            String rawUrl = tokens[1];
            while ((line = br.readLine()) != null && !line.equals("")) {
                tokens = line.split(": ", 2);
                if (tokens.length == 2) {
                    this.response.addHeader(tokens[0].toLowerCase(), tokens[1]);
                    continue;
                }
                logger.info("MALFORMWRONGHEADER " + line);
            }
            headerData = null;
        }
        this.headerread = true;
        if (this.response.isChunked() && this.bufferingConnection && this.streamBuffer == null) {
            this.streamBuffer = new ByteArrayOutputStream();
        }
        if (this.isProxyConnectRequest) {
            this.requestComplete = true;
            EventDispatcher.process(this, 3);
            if (this.isHttps()) {
                this.isSSL = true;
                this.ssl = new SSLWrapper(this.sc, SSLManager.getSSLClientContext(this.getHost()), this.getHost());
            }
            this.isProxyConnectRequest = false;
        } else if (this.response.getResponseHeader("content-length") != null) {
            byte[] data;
            String respLength = this.response.getResponseHeader("content-length");
            int length = Integer.parseInt(respLength.trim());
            if (length == 0) {
                this.requestComplete = true;
                EventDispatcher.process(this, 3);
                this.close();
                return;
            }
            if (bb.remaining() == 0) {
                this.bodyBuffer = ByteBuffer.allocate(length);
                return;
            }
            if (length > 0 && bb.remaining() >= length) {
                data = new byte[length];
                bb.get(data);
                this.pendingcount -= data.length;
                this.response.setBody(data);
                data = null;
                this.requestComplete = true;
                EventDispatcher.process(this, 3);
                this.close();
            } else if (bb.remaining() > 0 && bb.remaining() < length) {
                data = new byte[bb.remaining()];
                bb.get(data);
                this.pendingcount -= data.length;
                this.bodyBuffer = ByteBuffer.allocate(length);
                this.bodyBuffer.put(data);
                data = null;
            }
        } else {
            if (this.response.isChunked()) {
                return;
            }
            this.streamBuffer = new ByteArrayOutputStream();
            byte[] data = new byte[bb.remaining()];
            bb.get(data);
            this.pendingcount -= data.length;
            this.streamBuffer.write(data);
            Object var2_2 = null;
        }
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public HttpResponse getProxyErrorResponse(String message) {
        HttpResponse response = new HttpResponse();
        response.setResponseCode("502");
        response.setResponseMessage("Bad Gateway");
        try {
            response.setBody(message.getBytes("UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return response;
    }

    public void close() {
        try {
            if (this.streamBuffer != null) {
                this.response.setBody(this.streamBuffer.toByteArray());
                EventDispatcher.process(this, 3);
                this.clearEOFBuffer();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ReadTimeOutListener.TRACKER.remove(this.readexpiretime, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.isSSL) {
                this.ssl.close();
            } else {
                this.sc.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.key.channel().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.key.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Object getLockObject() {
        return this.lock;
    }

    public void notifyListener(int event) throws Exception {
        this.notifyListener(event, this.requestWrapper);
    }

    public void notifyListener(int event, HttpRequestWrapper requestWrapper) throws Exception {
        switch (event) {
            case -1: {
                this.listener.onConnectError(requestWrapper);
                return;
            }
            case -2: {
                this.listener.onReadTimeout(requestWrapper);
                return;
            }
            case 1: {
                this.listener.onConnect(requestWrapper);
                return;
            }
            case 2: {
                this.listener.onSubmit(requestWrapper);
                return;
            }
            case -3: {
                this.listener.onSubmitError(requestWrapper);
                return;
            }
            case 3: {
                int code = this.response.getResponseCode();
                if (code >= 400) {
                    this.listener.onResponseError(requestWrapper);
                    return;
                }
                if (code == 301 || code == 302) {
                    String location = this.response.getResponseHeader("Location");
                    String orgHost = requestWrapper.getCompleteHost();
                    if (location != null && location.equals(orgHost)) {
                        throw new Exception("Circular Redirection");
                    }
                }
                this.listener.onResponse(requestWrapper);
                return;
            }
            case -4: {
                try {
                    this.listener.onResponseError(requestWrapper);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            case -5: {
                this.listener.onDisconnect(requestWrapper);
                return;
            }
        }
    }

    class ProxyImpl
    implements HttpRequestEventListener {
        private HttpRequest request;

        ProxyImpl() {
        }

        public void setRequest(HttpRequest request) {
            this.request = request;
        }

        @Override
        public void onConnectError(HttpRequestWrapper req) {
            logger.info("PROXY LISTENER :: ON CONNECT ERROR " + req);
            this.request.setRequestListener();
            req.setResponse(this.request.getProxyErrorResponse("Proxy connect failure"));
            try {
                this.request.notifyListener(-1);
            }
            catch (Exception ex) {
                logger.info("FAILURE TO NOTIFY REQUEST LISTENER ON CONNECT ERROR :: " + req + " Exception " + ex.getMessage());
            }
        }

        @Override
        public void onReadTimeout(HttpRequestWrapper req) {
            logger.info("PROXY LISTENER :: ON READ TIMEOUT " + req);
            this.request.setRequestListener();
            req.setResponse(this.request.getProxyErrorResponse("Proxy read timeout"));
            try {
                this.request.notifyListener(-2);
            }
            catch (Exception ex) {
                logger.info("FAILURE TO NOTIFY REQUEST LISTENER ON READ TIMEOUT ERROR :: " + req + " Exception " + ex.getMessage());
            }
        }

        @Override
        public void onConnect(HttpRequestWrapper req) {
            logger.info("PROXY LISTENER :: ON CONNECT" + req);
        }

        @Override
        public void onSubmit(HttpRequestWrapper req) {
            logger.info("PROXY LISTENER :: ON SUBMIT " + req);
        }

        @Override
        public void onSubmitError(HttpRequestWrapper req) {
            logger.info("PROXY LISTENER :: ON SUBMIT ERROR " + req);
            this.request.setRequestListener();
            req.setResponse(this.request.getProxyErrorResponse("Proxy request submit failure"));
            try {
                this.request.notifyListener(-3);
            }
            catch (Exception ex) {
                logger.info("FAILURE TO NOTIFY REQUEST LISTENER ON SUBMIT ERROR :: " + req + " Exception " + ex.getMessage());
            }
        }

        @Override
        public void onResponse(HttpRequestWrapper req) {
            logger.info("PROXY LISTENER :: ON RESPONSE " + req + " , " + req.getResponse().getResponseCode());
            if (req.getResponse().getResponseCode() >= 200 && req.getResponse().getResponseCode() <= 208) {
                try {
                    this.request.setRequestListener();
                    this.request.resetDefaults();
                    this.request.registerReadWrite();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                this.request.setRequestListener();
                try {
                    this.request.notifyListener(3);
                }
                catch (Exception ex) {
                    logger.info("FAILURE TO NOTIFY REQUEST LISTENER ON RESPONSE :: " + req + " Exception " + ex.getMessage());
                }
            }
        }

        @Override
        public void onResponseError(HttpRequestWrapper req) {
            logger.info("PROXY LISTENER :: ON RESPONSE ERROR " + req + " , " + req.getResponse().getResponseCode());
            this.request.setRequestListener();
            try {
                this.request.notifyListener(-4);
            }
            catch (Exception ex) {
                logger.info("FAILURE TO NOTIFY REQUEST LISTENER ON RESPONSE ERROR :: " + req + " Exception " + ex.getMessage());
            }
        }

        @Override
        public void onDisconnect(HttpRequestWrapper req) {
            logger.info("PROXY LISTENER :: ON DISCONNECT " + req);
            this.request.setRequestListener();
            try {
                this.request.notifyListener(-5);
            }
            catch (Exception ex) {
                logger.info("FAILURE TO NOTIFY REQUEST LISTENER ON RESPONSE ERROR :: " + req + " Exception " + ex.getMessage());
            }
        }
    }
}

