/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.components.net.callback;

import com.adventnet.wms.common.components.net.WCPClientConnPool;
import com.adventnet.wms.common.components.net.WCPSessionManager;
import com.adventnet.wms.common.components.net.callback.WCPCBEvent;
import com.adventnet.wms.common.components.net.stats.WCPStats;
import com.adventnet.wms.common.components.net.util.WCPPacket;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPCBNotifyHandler {
    private Logger logger = Logger.getLogger(WCPCBNotifyHandler.class.getName());
    private ArrayBlockingQueue<Runnable> bq = null;
    private boolean closed = false;
    private WCPClientConnPool connPool = null;
    private ThreadPoolExecutor tpe = null;

    public WCPCBNotifyHandler(WCPClientConnPool connPool, int queueSize) {
        this.connPool = connPool;
        this.bq = new ArrayBlockingQueue(queueSize);
        this.tpe = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, this.bq);
    }

    public void putData(String poolName, String ip, WCPPacket packet) {
        try {
            if (!this.closed) {
                this.tpe.execute(new WCPCallBackNotifier(new WCPCBEvent(poolName, ip, packet)));
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, "putData", ex);
        }
    }

    public void closeCBNotifyHandler() {
        this.closed = true;
    }

    public void setPoolSize(int corePoolSize, int maxPoolSize) {
        this.tpe.setCorePoolSize(corePoolSize);
        this.tpe.setMaximumPoolSize(maxPoolSize);
    }

    public int getCorePoolSize() {
        return this.tpe.getCorePoolSize();
    }

    public int getMaxPoolSize() {
        return this.tpe.getMaximumPoolSize();
    }

    class WCPCallBackNotifier
    implements Runnable {
        private Logger logger = Logger.getLogger(WCPCallBackNotifier.class.getName());
        WCPCBEvent cbe = null;

        public WCPCallBackNotifier(WCPCBEvent cbe) {
            this.cbe = cbe;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long execTime = System.currentTimeMillis();
            try {
                if (this.cbe.getWCPPacket().getPacketType() == 4) {
                    WCPSessionManager.processNotifyPackets(WCPCBNotifyHandler.this.connPool.getContext(), this.cbe.getSource(), this.cbe.getIP(), new String(this.cbe.getWCPPacket().getPayLoadData(), "UTF-8"));
                } else {
                    this.logger.warning("Invalid packet inside CallBack Handler; packetType=" + this.cbe.getWCPPacket().getPacketType() + " ConnPool=" + WCPCBNotifyHandler.this.connPool.getPoolName());
                }
            }
            catch (Exception ex) {
                WCPStats.addWCPErrorStats("WCPCallBackNotifier-run", WCPCBNotifyHandler.this.connPool.getApiName(), WCPCBNotifyHandler.this.connPool.getPrd(), WCPCBNotifyHandler.this.connPool.getPoolName(), ex.getMessage());
                this.logger.log(Level.WARNING, "While execute Notify", ex);
            }
            finally {
                WCPStats.addExecutionTime("WCPCallBackNotifier", WCPCBNotifyHandler.this.connPool.getApiName(), WCPCBNotifyHandler.this.connPool.getPrd(), WCPCBNotifyHandler.this.connPool.getPoolName(), System.currentTimeMillis() - execTime);
            }
        }
    }
}

