/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.components.net.callback;

import com.adventnet.wms.common.components.net.WCPClientConnPool;
import com.adventnet.wms.common.components.net.WCPSessionManager;
import com.adventnet.wms.common.components.net.callback.WCPCBEvent;
import com.adventnet.wms.common.components.net.stats.WCPStats;
import com.adventnet.wms.common.components.net.util.WCPPacket;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPCBMetaHandler
extends Thread {
    private static Logger logger = Logger.getLogger(WCPCBMetaHandler.class.getName());
    private LinkedBlockingQueue<WCPCBEvent> callbackQueue = new LinkedBlockingQueue();
    private boolean closed = false;
    private WCPClientConnPool connPool = null;
    private long lastStatusUpdateTime = 0L;

    public WCPCBMetaHandler(WCPClientConnPool connPool) {
        this.connPool = connPool;
    }

    public void putData(String cluster, String ip, WCPPacket packet) {
        try {
            this.callbackQueue.put(new WCPCBEvent(cluster, ip, packet));
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "putData", ex);
            logger.info("[WCP][Exception - WCPCBMetaHandler][" + this.connPool.getContext() + "][" + cluster + "][Meta CallBack Queue Error][" + ex.getMessage() + "]");
        }
    }

    @Override
    public void run() {
        while (!this.closed) {
            try {
                this.updateLiveStats();
                WCPCBEvent cbe = this.callbackQueue.poll(60000L, TimeUnit.MILLISECONDS);
                if (cbe == null) continue;
                this.execute(cbe);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "While execute Meta", ex);
            }
        }
    }

    private void updateLiveStats() {
        try {
            if (System.currentTimeMillis() - this.lastStatusUpdateTime >= 60000L) {
                List<String> seedsList = this.connPool.getSeedList();
                int aliveConnections = this.connPool.getAliveConnCount();
                for (int i = 0; i < seedsList.size(); ++i) {
                    long optimalLimit;
                    String ip = seedsList.get(i);
                    if (!this.connPool.isAlive(ip)) continue;
                    long liveConnCount = this.connPool.getLiveConnCount();
                    long bqRatePerMin = this.connPool.getBqRatePerMin();
                    long currRatePerConn = bqRatePerMin / (liveConnCount > 0L ? liveConnCount : 1L);
                    this.connPool.setMaxRatePerConn(currRatePerConn);
                    long maxRatePerConn = this.connPool.getMaxRatePerConn();
                    long optimalConnCount = 0L;
                    if (maxRatePerConn > 0L) {
                        optimalConnCount = (long)Math.floor(bqRatePerMin / maxRatePerConn);
                    }
                    if (maxRatePerConn > currRatePerConn) {
                        optimalLimit = liveConnCount - 1L;
                        if (optimalConnCount > 0L && optimalLimit > optimalConnCount) {
                            optimalConnCount = optimalLimit;
                            logger.info("HB--> closing unnecessary connection. liveConnCount=" + liveConnCount + " optimalConnCount=" + optimalConnCount);
                        }
                    } else if (maxRatePerConn <= currRatePerConn) {
                        optimalLimit = liveConnCount + 1L;
                        if (optimalLimit < optimalConnCount) {
                            optimalConnCount = optimalLimit;
                        }
                    } else {
                        optimalConnCount = liveConnCount;
                    }
                    if (liveConnCount <= 0L) continue;
                    WCPStats.updateLiveStats(this.connPool.getPrd(), this.connPool.getApiName(), ip, this.connPool.getPoolName(), liveConnCount, optimalConnCount, bqRatePerMin, this.connPool.getLiveBQSize(), this.connPool.getResponseHandlerQueueSize(), this.callbackQueue.size());
                }
                this.lastStatusUpdateTime = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            logger.info("[Exception][WCPCBMetaHandler - updateLiveConnections][" + e.getMessage() + "]");
            logger.log(Level.WARNING, "While Update Live Connection", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(WCPCBEvent cbe) {
        long execTime = System.currentTimeMillis();
        if (cbe.getWCPPacket().getPacketType() == 3) {
            try {
                WCPSessionManager.processMetaPackets(this.connPool.getApiName(), this.connPool.getContext(), cbe.getSource(), new Integer(cbe.getWCPPacket().getPayLoadType()), new String(cbe.getWCPPacket().getPayLoadData(), "UTF-8"));
            }
            catch (Exception e) {
                logger.info("[Exception][WCPCBMetaHandler - execute][" + e.getMessage() + "]");
                WCPStats.addWCPErrorStats("WCPCBMetaHandler-execute", this.connPool.getApiName(), this.connPool.getPrd(), this.connPool.getPoolName(), e.getMessage());
            }
            finally {
                WCPStats.addExecutionTime("WCPCBMetaHandler", this.connPool.getApiName(), this.connPool.getPrd(), this.connPool.getPoolName(), System.currentTimeMillis() - execTime);
            }
        }
    }

    public void closeCBNotifyHandler() {
        this.closed = false;
        this.callbackQueue = null;
    }
}

