/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.components.net;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.WmsUIDGenerator;
import com.adventnet.wms.common.components.net.SessionMonitor;
import com.adventnet.wms.common.components.net.WCPClientConnPool;
import com.adventnet.wms.common.components.net.WCPClientConnPoolConfig;
import com.adventnet.wms.common.components.net.WCPConfManager;
import com.adventnet.wms.common.components.net.WCPSessionManager;
import com.adventnet.wms.common.components.net.callback.WCPCBListener;
import com.adventnet.wms.common.components.net.callback.WCPMetaListener;
import com.adventnet.wms.common.components.net.callback.WCPResponseCBListener;
import com.adventnet.wms.common.components.net.servlet.WCPFuture;
import com.adventnet.wms.common.components.net.servlet.WCPRequest;
import com.adventnet.wms.common.components.net.servlet.WCPServletMapper;
import com.adventnet.wms.common.components.net.stats.WCPStats;
import com.adventnet.wms.common.components.net.timeoutlistener.WCPReqTimeOutListener;
import com.adventnet.wms.common.components.net.util.WCPAdminUtil;
import com.adventnet.wms.common.components.net.util.WCPPacket;
import com.adventnet.wms.common.components.net.util.WCPPacketizer;
import com.adventnet.wms.common.components.net.util.WCPUtil;
import com.adventnet.wms.common.stats.influx.StatsDB;
import com.adventnet.wms.common.stats.influx.conf.StatsConf;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPAPIDispatcher {
    private static final Logger LOGGER = Logger.getLogger(WCPAPIDispatcher.class.getName());
    private static boolean initialized = false;
    private static Hashtable<String, WCPClientConnPool> connPoolMap;
    private static Hashtable<String, String> servingModeMap;
    private static ReentrantLock connPoolLock;

    public static boolean initialize() {
        if (initialized) {
            LOGGER.warning("[WCP] WCPApiDispatcher already initialised prd");
            return true;
        }
        try {
            WmsUIDGenerator.initialize(100L, 2L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        WCPAPIDispatcher.initInfluxStatsConf();
        if (!WCPSessionManager.initialize()) {
            return false;
        }
        new SessionMonitor().start();
        connPoolMap = new Hashtable();
        servingModeMap = new Hashtable();
        initialized = true;
        LOGGER.info("[WCPAPIDispatcher - Initialized!!]");
        return initialized;
    }

    public static boolean setServingMode(String apiName, String servingMode) {
        if (!WCPUtil.isValidServingMode(servingMode) || apiName == null) {
            LOGGER.severe("Invalid apiName or servingMode. apiName=" + apiName + " servingMode=" + servingMode);
            return false;
        }
        servingModeMap.put(apiName, servingMode);
        return true;
    }

    public static boolean loadServlets(Properties servletProps) {
        return WCPServletMapper.loadServlets(servletProps);
    }

    private static void initInfluxStatsConf() {
        Hashtable<String, String> statsDefs = new Hashtable<String, String>();
        statsDefs.put("wcp_clientconn", "[[\"qos\",\"qos_wcp_api\",\"\",\"wcp_clientconn\",false],[\"prd\",\"apiname\",\"poolname\",\"remoteip\",\"connstatus\",\"reason\"],[\"ip\"],[\"connecttime\",\"onconnect\",\"onclose\",\"connlife\"]]");
        statsDefs.put("wcp_clientlivestats", "[[\"qos\",\"qos_wcp_api\",\"\",\"wcp_clientlivestats\",false],[\"prd\",\"apiname\",\"poolname\",\"remoteip\"],[\"ip\"],[\"connections\",\"optimalconn\",\"bqrate\",\"bqsize\",\"response_handler_qsize\",\"meta_queue_size\"]]");
        statsDefs.put("wcp_clientdata", "[[\"qos\",\"qos_wcp_api\",\"\",\"wcp_clientdata\",false],[\"prd\",\"apiname\",\"poolname\",\"remoteip\",\"packet_type\",\"communication\"],[\"ip\"],[\"count\"]]");
        statsDefs.put("wcp_listnr_time", "[[\"qos\",\"qos_wcp_api\",\"\",\"wcp_listnr_time\",false,true,,,,true],[\"listener_action\",\"source\"],[],[\"time\"]]");
        statsDefs.put("wcp_reconnect", "[[\"qos\",\"qos_wcp_api\",\"\",\"wcp_reconnect\",false],[\"prd\",\"apiname\",\"poolname\",\"remoteip\"],[\"sid\",\"ip\"],[\"reconnect_count\"]]");
        statsDefs.put("wcp_clientdatasize", "[[\"qos\",\"qos_wcp_api\",\"\",\"wcp_clientdatasize\",false],[\"prd\",\"apiname\",\"poolname\",\"remoteip\",\"status\"],[\"ip\"],[\"data_size\",\"count\"]]");
        statsDefs.put("wcp_srv_hits", "[[\"qos\",\"qos_wcp_api\",\"\",\"wcp_srv_hits\",false],[\"apiname\",\"prd\",\"remote_servertype\",\"remoteip\",\"servlet\",\"status\"],[\"ip\"],[\"count\",\"processtime\"]]");
        statsDefs.put("wcp_servlet_notfound", "[[\"qos\",\"qos_wcp_api\",\"\",\"wcp_servlet_notfound\",false],[\"apiname\",\"prd\",\"remote_servertype\",\"servlet\",\"remoteip\"],[\"ip\"],[\"count\"]]");
        statsDefs.put("wcp_thread_close", "[[\"qos\",\"qos_wcp_api\",\"\",\"wcp_thread_close\",false],[\"thread_name\",\"apiname\",\"prd\",\"poolname\",\"remoteip\",\"err_msg\"],[\"ip\",\"thread_info\"],[\"thread_life\",\"count\"]]");
        statsDefs.put("wcp_error", "[[\"qos\",\"qos_wcp_api\",\"\",\"wcp_error\",false],[\"error_type\",\"apiname\",\"prd\",\"poolname\",\"reason\"],[\"ip\"],[\"count\"]]");
        statsDefs.put("wcp_req_timeout", "[[\"qos\",\"qos_wcp_api\",\"\",\"wcp_req_timeout\",false],[\"poolname\",\"prd\",\"apiname\",\"remoteip\",\"servlet\"],[\"ip\"],[\"count\"]]");
        statsDefs.put("wcp_request_time", "[[\"qos\",\"qos_wcp_api\",\"\",\"wcp_request_time\",false],[\"apiname\",\"prd\",\"poolname\",\"servlet\",\"response_code\"],[\"ip\"],[\"totaltime\",\"count\"]]");
        statsDefs.put("wcp_clientrtt", "[[\"qos\",\"qos_wcp_api\",\"\",\"wcp_clientrtt\",false],[\"apiname\",\"prd\",\"poolname\",\"remoteip\",\"packet_type\"],[\"ip\"],[\"rtt\",\"count\"]]");
        statsDefs.put("wcp_execution_time", "[[\"qos\",\"qos_wcp_api\",\"\",\"wcp_execution_time\",false],[\"handler\",\"apiname\",\"prd\",\"poolname\"],[\"ip\"],[\"execution_time\",\"count\"]]");
        if (StatsConf.loadStatsKeyDef(statsDefs)) {
            StatsDB.initialize();
            LOGGER.info("[WCPAPIDispatcher - Influx Stats Initialized!!]");
        }
    }

    public static boolean registerCBListener(String context, WCPCBListener listnr) {
        return WCPSessionManager.registerCBListener(context, listnr);
    }

    public static boolean registerMetaListener(String apiName, WCPMetaListener listnr) {
        return WCPSessionManager.registerMetaListener(apiName, listnr);
    }

    public static void createWCPConnPool(String poolName, String context, String prd, String apiName) throws Exception {
        WCPAPIDispatcher.createWCPConnPool(poolName, context, prd, apiName, null, "Unknown");
    }

    public static void createWCPConnPool(String poolName, String context, String prd, String apiName, String adminURL, String buildLog) throws Exception {
        WCPAPIDispatcher.createWCPConnPool(poolName, context, prd, apiName, adminURL, buildLog, WCPConfManager.getWCPIPQueueSize(), WCPConfManager.getNewConnectionThreshold());
    }

    public static void createWCPConnPool(String poolName, String context, String prd, String apiName, int queueSize, int newConnThreshold) throws Exception {
        WCPAPIDispatcher.createWCPConnPool(poolName, context, prd, apiName, null, "Unknown", WCPConfManager.getWCPIPQueueSize(), WCPConfManager.getNewConnectionThreshold());
    }

    public static void createWCPConnPool(String poolName, String context, String prd, String apiName, String adminURL, String buildLog, int queueSize, int newConnThreshold) throws Exception {
        WCPAPIDispatcher.createWCPConnPool(poolName, context, prd, apiName, adminURL, buildLog, queueSize, newConnThreshold, WCPConfManager.getWCPURI(), WCPConfManager.getWCPPort(), WCPConfManager.getWCPMaxDataPerConn(), WCPConfManager.getWCPMaxDataAddRetryCount());
    }

    public static void createWCPConnPool(String poolName, String context, String prd, String apiName, int queueSize, int newConnThreshold, String uri, int port, int maxDataPerConn, int maxDataAddRetryCount) throws Exception {
        WCPAPIDispatcher.createWCPConnPool(poolName, context, prd, apiName, null, "Unknown", queueSize, newConnThreshold, WCPConfManager.getWCPURI(), WCPConfManager.getWCPPort(), WCPConfManager.getWCPMaxDataPerConn(), WCPConfManager.getWCPMaxDataAddRetryCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createWCPConnPool(String poolName, String context, String prd, String apiName, String adminURL, String buildLog, int ipQueueSize, int newConnThreshold, String uri, int port, int maxDataPerConn, int maxDataAddRetryCount) throws Exception {
        connPoolLock.lock();
        try {
            if (connPoolMap.get(poolName) == null) {
                WCPClientConnPool connPool = new WCPClientConnPool(poolName, new ArrayList<String>(), context, prd, apiName, ipQueueSize, newConnThreshold, uri, port, maxDataPerConn, maxDataAddRetryCount);
                connPoolMap.put(poolName, connPool);
                WCPAdminUtil.setPrd(prd);
                WCPAdminUtil.registerSecurity(apiName, adminURL, buildLog);
                WCPAdminUtil.refreshWCPDispatcherSeedsList(poolName, apiName, context);
                LOGGER.info("[WCP][New ConnectionPool Created] poolName=" + poolName + " context=" + context + " prd=" + prd + " apiName=" + apiName + " queueSize=" + ipQueueSize);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while creating connection poolName=" + poolName + "context=" + context + " prd=" + prd + " apiName=" + apiName + " queueSize=" + ipQueueSize, e);
        }
        finally {
            connPoolLock.unlock();
        }
    }

    protected static void createWCPConnPool(WCPClientConnPoolConfig conf) throws Exception {
        connPoolLock.lock();
        try {
            if (connPoolMap.get(conf.getPoolName()) == null) {
                WCPClientConnPool connPool = new WCPClientConnPool(conf);
                connPoolMap.put(conf.getPoolName(), connPool);
                WCPAdminUtil.setPrd(conf.getPrd());
                if (!conf.isDomainBased()) {
                    WCPAdminUtil.registerSecurity(conf.getApiName(), conf.getAdminURL(), conf.getBuildLog());
                    WCPAdminUtil.refreshWCPDispatcherSeedsList(conf.getPoolName(), conf.getApiName(), conf.getContext());
                }
                LOGGER.info("[WCP][New ConnectionPool Created] poolName=" + conf.getPoolName() + " context=" + conf.getContext() + " prd=" + conf.getPrd() + " apiName=" + conf.getApiName() + " queueSize=" + conf.getIpQueueSize());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while creating connection poolName=" + conf.getPoolName() + "context=" + conf.getContext() + " prd=" + conf.getPrd() + " apiName=" + conf.getApiName() + " queueSize=" + conf.getIpQueueSize(), e);
        }
        finally {
            connPoolLock.unlock();
        }
    }

    public static void setSeedList(String poolName, List<String> seeds) throws Exception {
        if (!initialized || connPoolMap.get(poolName) == null) {
            throw new Exception("WCPConnPool Not Initialized!! poolname=" + poolName + " seeds=" + seeds);
        }
        if (CommonUtil.isEmpty(seeds)) {
            throw new Exception("empty seeds" + poolName + " seeds=" + seeds);
        }
        connPoolMap.get(poolName).manageConnections(seeds);
    }

    @Deprecated
    public static void setNotifyHandlerPoolSize(String poolName, int corePoolSize, int maximumPoolSize) {
        connPoolMap.get(poolName).setNotifyHandlerPoolSize(corePoolSize, maximumPoolSize);
    }

    @Deprecated
    public static void setResponseHandlerPoolSize(String poolName, int corePoolSize, int maximumPoolSize) {
        connPoolMap.get(poolName).setResponseHandlerPoolSize(corePoolSize, maximumPoolSize);
    }

    public static void sendData(String poolName, String data) throws Exception {
        WCPAPIDispatcher.sendData(poolName, 0, data);
    }

    public static void sendData(String poolName, int dataType, String data) throws Exception {
        WCPAPIDispatcher.sendData(poolName, dataType, data.getBytes("UTF-8"), null, null, null);
    }

    public static void sendData(String poolName, int dataType, String data, String rkey) throws Exception {
        WCPAPIDispatcher.sendData(poolName, dataType, data.getBytes("UTF-8"), null, rkey, null);
    }

    public static void sendData(String poolName, int dataType, String data, ArrayList<String> rkeys) throws Exception {
        WCPAPIDispatcher.sendData(poolName, dataType, data.getBytes("UTF-8"), null, null, rkeys);
    }

    public static void sendData(String poolName, int dataType, String data, Hashtable<String, String> header) throws Exception {
        WCPAPIDispatcher.sendData(poolName, dataType, data.getBytes("UTF-8"), header, null, null);
    }

    private static void sendData(String poolName, int dataType, byte[] data, Hashtable<String, String> header, String rkey, ArrayList<String> rkeys) throws Exception {
        block14: {
            if (!initialized) {
                throw new Exception("WCP not Initialized");
            }
            if (data == null) {
                throw new Exception("Data is null");
            }
            if ((long)data.length > WCPConfManager.getWcpMaxAcceptableDataSize()) {
                throw new Exception("Data Size Exceeds");
            }
            if (header == null) {
                header = new Hashtable();
            }
            if (!CommonUtil.isEmpty(rkeys)) {
                header.put("rkeys", HttpDataWraper.getString(rkeys));
            } else if (!CommonUtil.isEmpty(rkey)) {
                header.put("rkey", rkey);
            }
            boolean sendPacketStatus = false;
            WCPPacket packet = null;
            WCPClientConnPool connPool = connPoolMap.get(poolName);
            try {
                if (connPool != null) {
                    packet = WCPPacketizer.getPacketFromData(-1L, 1, 0L, header, dataType, data);
                    sendPacketStatus = connPool.sendPacket(packet);
                    break block14;
                }
                throw new Exception("WCPConnPool Not Initialized");
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "WCPERR--> poolName=" + poolName, ex);
                WCPStats.addWCPErrorStats("SendData-Failed", WCPAPIDispatcher.getApiName(poolName), WCPAPIDispatcher.getPrd(poolName), poolName, ex.getMessage());
                WCPSessionManager.returnErrorMsg(connPool.getApiName(), connPool.getContext(), poolName, packet.getPacketType(), new String(packet.getPayLoadData(), "UTF-8"), ex.getMessage());
                throw ex;
            }
            finally {
                if (!sendPacketStatus) {
                    throw new Exception("SendData failed due to empty seeds. poolName=" + poolName);
                }
            }
        }
    }

    public static WCPFuture sendRequest(String poolName, WCPRequest req, WCPResponseCBListener listener) throws Exception {
        return WCPAPIDispatcher.sendRequest(poolName, null, req, listener);
    }

    private static WCPFuture sendRequest(String poolName, String ip, WCPRequest req, WCPResponseCBListener listener) throws Exception {
        if (!initialized) {
            throw new Exception("WCP not Initialized");
        }
        if (req == null) {
            throw new Exception("Invalid WCPRequest");
        }
        WCPFuture future = null;
        try {
            WCPClientConnPool connPool = connPoolMap.get(poolName);
            if (connPool == null) {
                throw new Exception("WCPConnPool Not Initialized");
            }
            future = connPool.sendRequest(req, listener);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "WCPERR--> poolname=" + poolName + " ip=" + ip + " reqUri=" + req.getURI(), ex);
            WCPStats.addWCPErrorStats("SendRequest-Failed", WCPAPIDispatcher.getApiName(poolName), WCPAPIDispatcher.getPrd(poolName), poolName, ex.getMessage());
            throw ex;
        }
        return future;
    }

    public static boolean sendPacket(String poolName, String remoteIp, WCPPacket packet) throws Exception {
        if (connPoolMap.containsKey(poolName)) {
            return connPoolMap.get(poolName).sendPacket(packet, remoteIp);
        }
        return false;
    }

    @Deprecated
    public static boolean setMaxDataPerConn(String poolName, int maxDataPerConn) {
        if (connPoolMap.get(poolName) != null) {
            connPoolMap.get(poolName).setMaxDataPerConn(maxDataPerConn);
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean setMaxDataAddRetryCount(String poolName, int maxDataAddRetryCount) {
        if (connPoolMap.get(poolName) != null) {
            connPoolMap.get(poolName).setMaxDataAddRetryCount(maxDataAddRetryCount);
            return true;
        }
        return false;
    }

    public static boolean isWCPReqExpired(String reqId) {
        try {
            String[] splt = reqId.split("@");
            long expTime = Long.parseLong(splt[2]);
            if (System.currentTimeMillis() <= expTime) {
                return false;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "[WCP] Error inside isWCPReqExpired reqid=" + reqId, ex);
        }
        return true;
    }

    public static boolean invalidateWCPRequest(ArrayList<String> list) {
        try {
            for (String id : list) {
                String[] splt = id.split("@");
                long expTime = Long.parseLong(splt[2]);
                if (System.currentTimeMillis() <= expTime) continue;
                if (connPoolMap.get(splt[0]) != null) {
                    connPoolMap.get(splt[0]).invalidateWCPRequest(splt[1]);
                    WCPReqTimeOutListener.TRACKER.remove(expTime, id);
                    continue;
                }
                WCPReqTimeOutListener.TRACKER.touch(expTime, id);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "[WCP] Error while invalidating WCPRequest", ex);
        }
        return true;
    }

    public static boolean isValidRequest(String reqId) {
        try {
            String[] splt = reqId.split("@");
            long expTime = Long.parseLong(splt[2]);
            if (System.currentTimeMillis() <= expTime && connPoolMap.get(splt[0]) != null) {
                return connPoolMap.get(splt[0]).isValidRequest(splt[1]);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "[WCP] Error inside isValidRequest reqId=" + reqId, ex);
        }
        return false;
    }

    public static List<String> getSeedsList(String poolName) {
        if (connPoolMap.containsKey(poolName)) {
            return connPoolMap.get(poolName).getSeedList();
        }
        return null;
    }

    public static String getServingMode(String apiName) {
        if (servingModeMap.containsKey(apiName)) {
            return servingModeMap.get(apiName);
        }
        return "rw";
    }

    public static String getApiName(String poolName) {
        if (connPoolMap.containsKey(poolName)) {
            return connPoolMap.get(poolName).getApiName();
        }
        return null;
    }

    public static String getPrd(String poolName) {
        if (connPoolMap.containsKey(poolName)) {
            return connPoolMap.get(poolName).getPrd();
        }
        return null;
    }

    public static long getWCPQStats(String poolName) {
        if (connPoolMap.containsKey(poolName)) {
            return connPoolMap.get(poolName).getLiveBQSize();
        }
        return -1L;
    }

    public static Hashtable<String, Integer> getWCPResponseQueueSize(String poolName) {
        if (connPoolMap.containsKey(poolName)) {
            return connPoolMap.get(poolName).getResponseQueueSize();
        }
        return null;
    }

    protected static Hashtable<String, WCPClientConnPool> getConnPoolMap() {
        return connPoolMap;
    }

    public static WCPClientConnPoolConfig getConnPoolConfig(String poolName) {
        if (!connPoolMap.containsKey(poolName)) {
            LOGGER.warning("WCPWARN--> Connection pool not created; PoolName=" + poolName);
            return null;
        }
        return connPoolMap.get(poolName).getConnPoolConfig();
    }

    static {
        connPoolLock = new ReentrantLock();
    }
}

