/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common;

import com.adventnet.wms.common.exception.WMSException;
import java.net.InetAddress;
import java.util.logging.Logger;

public class WmsUIDGenerator {
    private static Logger logger = Logger.getLogger(WmsUIDGenerator.class.getName());
    private static boolean initialized = false;
    private static long ipframe = -1L;
    private static long timeseed = -1L;
    private static long gridUID = -1L;
    private static long seqCounter = 0L;
    private static long timeslice = 1000L;
    private static long timefactor = 1L;

    public static synchronized boolean initialize() throws WMSException {
        try {
            String ip = InetAddress.getLocalHost().getHostAddress();
            String[] sub = ip.split("\\.");
            ipframe = (Long.parseLong(sub[2]) << 8 | Long.parseLong(sub[3])) << 44;
            WmsUIDGenerator.setupSeed();
            initialized = true;
            return true;
        }
        catch (Exception exp) {
            throw new WMSException("Unable to initialize WmsUIDGenerator " + exp.getMessage());
        }
    }

    public static synchronized boolean initialize(long ts, long tf) throws WMSException {
        timeslice = ts;
        timefactor = tf;
        return WmsUIDGenerator.initialize();
    }

    private static synchronized void setupSeed() throws WMSException {
        long ti = System.currentTimeMillis();
        if (timeseed == (ti /= timeslice)) {
            try {
                Thread.sleep(timefactor * timeslice);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ti = System.currentTimeMillis();
            if (timeseed == (ti /= timeslice)) {
                logger.severe("timeseed is same");
                throw new WMSException("Unable to generate unique id");
            }
        }
        timeseed = ti;
        gridUID = ipframe | (timeseed & 0xFFFFFFFFL) << 12;
        seqCounter = 0L;
        logger.fine("New gridUID " + gridUID + " " + Long.toHexString(gridUID));
    }

    protected static synchronized Long getUniqueId() throws WMSException {
        if (!initialized) {
            throw new WMSException("Generator Not Initialized");
        }
        if (seqCounter > 3000L) {
            WmsUIDGenerator.setupSeed();
        } else {
            ++seqCounter;
        }
        return new Long(gridUID + seqCounter);
    }
}

