/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;

public abstract class TimeOutListener
extends Thread {
    private static Logger logger = Logger.getLogger(TimeOutListener.class.getName());
    private final Integer PUT = new Integer(1);
    private final Integer REMOVE = new Integer(2);
    private LinkedBlockingQueue<HashMap> queue = new LinkedBlockingQueue();
    private LinkedHashMap lru = new LinkedHashMap(100, 0.75f, true);
    private Tracker tracker;

    protected TimeOutListener(String thdName, long interval, long startdelay) {
        super(thdName + "-queue");
        this.start();
        this.tracker = new Tracker(thdName + "-tracker", interval, startdelay);
        this.tracker.start();
    }

    protected TimeOutListener(String thdName, long interval) {
        this(thdName, interval, interval);
    }

    public abstract boolean isExpired(Object var1);

    public abstract void handleExpired(ArrayList var1);

    public void touch(Object obj) {
        try {
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("obj", obj);
            entry.put("opr", this.PUT);
            this.queue.put(entry);
        }
        catch (Exception e) {
            logger.warning("Error queueing in TimeOutListener - touch");
        }
    }

    public void remove(Object obj) {
        try {
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("obj", obj);
            entry.put("opr", this.REMOVE);
            this.queue.put(entry);
        }
        catch (Exception e) {
            logger.warning("Error queueing in TimeOutListener - remove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    HashMap entry = this.queue.take();
                    LinkedHashMap linkedHashMap = this.lru;
                    synchronized (linkedHashMap) {
                        if ((Integer)entry.get("opr") == this.PUT) {
                            this.lru.put(entry.get("obj"), entry.get("obj"));
                        } else {
                            this.lru.remove(entry.get("obj"));
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    class Tracker
    extends Thread {
        private long interval;
        private long startdelay;

        public Tracker(String thdName, long interval, long startdelay) {
            super(thdName);
            this.interval = 0L;
            this.startdelay = 0L;
            this.interval = interval;
            this.startdelay = startdelay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Tracker.sleep(this.startdelay);
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (true) {
                try {
                    while (true) {
                        ArrayList expList = new ArrayList();
                        LinkedHashMap linkedHashMap = TimeOutListener.this.lru;
                        synchronized (linkedHashMap) {
                            Iterator it = TimeOutListener.this.lru.values().iterator();
                            while (it.hasNext()) {
                                Object obj = it.next();
                                try {
                                    if (!TimeOutListener.this.isExpired(obj)) break;
                                    expList.add(obj);
                                    it.remove();
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                        if (expList.size() > 0) {
                            TimeOutListener.this.handleExpired(expList);
                        }
                        Tracker.sleep(this.interval);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

