/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.config;

import org.asteriskjava.config.ConfigElement;

public class ConfigVariable
extends ConfigElement {
    private String name;
    private String value;

    public ConfigVariable(String name, String value) {
        this.setName(name);
        this.setValue(value);
    }

    public ConfigVariable(String filename, int lineno, String name, String value) {
        super(filename, lineno);
        this.setName(name);
        this.setValue(value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Variable name must not be null");
        }
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    protected StringBuilder rawFormat(StringBuilder sb) {
        sb.append(this.name).append(" = ");
        if (this.value != null) {
            sb.append(this.value);
        }
        return sb;
    }

    public String toString() {
        return this.name + "=" + this.value;
    }
}

