/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.websocket;

import com.adventnet.wms.nioclient.VariableTimeOutListener;
import com.adventnet.wms.nioclient.http.HttpRequest;
import java.util.ArrayList;
import java.util.logging.Logger;

public class PingTimeOutListener
extends VariableTimeOutListener {
    private static final Logger logger = Logger.getLogger(PingTimeOutListener.class.getName());
    private static final Logger mtlogger = Logger.getLogger("messagetracker");
    public static final PingTimeOutListener TRACKER = new PingTimeOutListener();

    private PingTimeOutListener() {
        super("PingTimeOutListener", 10000L);
    }

    @Override
    public boolean isExpired(Object obj) {
        return System.currentTimeMillis() >= ((HttpRequest)obj).getPingExpireTime();
    }

    @Override
    public boolean isInvalidEntry(Object obj, long time) {
        return ((HttpRequest)obj).isInvalidPingTimeoutEntry(time);
    }

    @Override
    public void handleExpired(ArrayList list) {
        logger.info("Expired Request List " + list.size());
        long readexpired = 0L;
        for (HttpRequest client : list) {
            client.doPing();
        }
    }
}

