/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.util;

import java.io.File;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Logger;

public class NIOCommonUtil {
    private static Logger logger = Logger.getLogger(NIOCommonUtil.class.getName());

    public static String addList(String str, String delimStr) {
        if (NIOCommonUtil.isEmpty(delimStr)) {
            return str;
        }
        if (NIOCommonUtil.isEmpty(str)) {
            return delimStr;
        }
        Hashtable ht = NIOCommonUtil.getHash(delimStr);
        ht.put("" + str, "");
        return NIOCommonUtil.getString(ht);
    }

    public static String removeList(String str, String delimStr) {
        if (str == null) {
            return str;
        }
        Hashtable ht = NIOCommonUtil.getHash(str);
        ht.remove("" + delimStr);
        return NIOCommonUtil.getString(ht);
    }

    public static Enumeration enumerate(String delimStr) {
        if (delimStr == null) {
            return null;
        }
        return NIOCommonUtil.getHash(delimStr).keys();
    }

    public static Hashtable getHash(String delimStr) {
        if (delimStr == null) {
            return null;
        }
        Hashtable<String, String> ht = new Hashtable<String, String>();
        StringTokenizer st = new StringTokenizer(delimStr, ",");
        while (st.hasMoreTokens()) {
            ht.put("" + st.nextToken(), "");
        }
        return ht;
    }

    public static ArrayList getList(String list) {
        return NIOCommonUtil.getList(list, ",");
    }

    public static ArrayList getList(String list, String separator) {
        ArrayList<String> sList = new ArrayList<String>();
        if (list == null) {
            return sList;
        }
        list = list.replace('\r', ' ');
        list = list.replace('\n', ' ');
        StringTokenizer st = new StringTokenizer(list, separator);
        while (st.hasMoreTokens()) {
            sList.add(st.nextToken().trim());
        }
        return sList;
    }

    public static String getString(Hashtable ht) {
        if (ht.size() == 0) {
            return "";
        }
        StringBuffer st = new StringBuffer();
        Enumeration e = ht.keys();
        if (e.hasMoreElements()) {
            st.append((String)e.nextElement());
        }
        while (e.hasMoreElements()) {
            st.append(",");
            st.append((String)e.nextElement());
        }
        return st.toString();
    }

    public static String getString(HashMap hm) {
        if (hm.size() == 0) {
            return "";
        }
        StringBuffer st = new StringBuffer();
        Iterator it = hm.keySet().iterator();
        if (it.hasNext()) {
            st.append((String)it.next());
        }
        while (it.hasNext()) {
            st.append(",");
            st.append((String)it.next());
        }
        return st.toString();
    }

    public static String getString(ArrayList list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = list.iterator();
        if (it.hasNext()) {
            sb.append("" + it.next());
        }
        while (it.hasNext()) {
            sb.append(",");
            sb.append("" + it.next());
        }
        return sb.toString();
    }

    public static String getString(Set set) {
        if (set.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = set.iterator();
        if (it.hasNext()) {
            sb.append("" + it.next());
        }
        while (it.hasNext()) {
            sb.append(",");
            sb.append("" + it.next());
        }
        return sb.toString();
    }

    public static Date convertTimeZone(long dateLng, String toTimezone) {
        return NIOCommonUtil.convertTimeZone(dateLng, null, toTimezone);
    }

    public static Date convertTimeZone(long dateLng, String fromTimezone, String toTimezone) {
        Calendar cal = Calendar.getInstance(Locale.getDefault());
        cal.setTimeInMillis(dateLng);
        TimeZone fromTZObj = null;
        fromTZObj = fromTimezone == null ? TimeZone.getDefault() : TimeZone.getTimeZone(fromTimezone);
        GregorianCalendar fromCal = new GregorianCalendar(fromTZObj, Locale.getDefault());
        fromCal.set(cal.get(1), cal.get(2), cal.get(5), cal.get(11), cal.get(12), cal.get(13));
        TimeZone toTZObj = null;
        toTZObj = toTimezone == null ? TimeZone.getDefault() : TimeZone.getTimeZone(toTimezone);
        GregorianCalendar toCal = new GregorianCalendar(toTZObj, Locale.getDefault());
        toCal.setTimeInMillis(fromCal.getTimeInMillis());
        return toCal.getTime();
    }

    public static long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static long getTimeZoneMillis(long dateLng, String timezone) {
        Calendar cal = Calendar.getInstance(Locale.getDefault());
        cal.setTimeInMillis(dateLng);
        TimeZone fromTZObj = null;
        fromTZObj = timezone == null ? TimeZone.getDefault() : TimeZone.getTimeZone(timezone);
        GregorianCalendar fromCal = new GregorianCalendar(fromTZObj, Locale.getDefault());
        fromCal.set(cal.get(1), cal.get(2), cal.get(5), cal.get(11), cal.get(12), cal.get(13));
        return fromCal.getTimeInMillis();
    }

    public static boolean isEmpty(String value) {
        try {
            return value.trim().length() == 0;
        }
        catch (NullPointerException npe) {
            return true;
        }
    }

    public static String trim(String delimStr) {
        return NIOCommonUtil.getString(NIOCommonUtil.getHash(delimStr));
    }

    public static String join(String token, ArrayList strarr) {
        StringBuffer sb = new StringBuffer();
        if (strarr.isEmpty()) {
            return sb.toString();
        }
        for (int x = 0; x < strarr.size() - 1; ++x) {
            sb.append("" + strarr.get(x));
            sb.append(token);
        }
        sb.append(strarr.get(strarr.size() - 1));
        return sb.toString();
    }

    public static ArrayList split(String list) {
        return NIOCommonUtil.split(list, ",");
    }

    public static ArrayList split(String list, String separator) {
        ArrayList<String> sList = new ArrayList<String>();
        if (list == null) {
            return sList;
        }
        list = list.replace('\r', ' ');
        list = list.replace('\n', ' ');
        StringTokenizer st = new StringTokenizer(list, separator);
        while (st.hasMoreTokens()) {
            sList.add(st.nextToken().trim());
        }
        return sList;
    }

    public static String getMemSize(long sizeInBytes) {
        String size = null;
        size = sizeInBytes > 0x10000000000L ? (float)(sizeInBytes * 100L / 0x10000000000L) / 100.0f + " TB" : (sizeInBytes > 0x40000000L ? (float)(sizeInBytes * 100L / 0x40000000L) / 100.0f + " GB" : (sizeInBytes > 0x100000L ? (float)(sizeInBytes * 100L / 0x100000L) / 100.0f + " MB" : (sizeInBytes > 1024L ? (float)(sizeInBytes * 100L / 1024L) / 100.0f + " KB" : sizeInBytes + " Bytes")));
        return size;
    }

    public static boolean isFileExist(String path) {
        try {
            return new File(path).isFile();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String escapeHTML(String msg) {
        if (msg == null || msg.trim().equals("")) {
            return msg;
        }
        StringBuilder html = new StringBuilder(msg.length() + 50);
        block7: for (char c : msg.toCharArray()) {
            switch (c) {
                case '<': {
                    html.append("&lt;");
                    continue block7;
                }
                case '>': {
                    html.append("&gt;");
                    continue block7;
                }
                case '&': {
                    html.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    html.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    html.append("&#39;");
                    continue block7;
                }
                default: {
                    html.append(c);
                }
            }
        }
        return html.toString();
    }

    public static String escape(String str) {
        StringBuffer result = new StringBuffer();
        StringCharacterIterator iterator = new StringCharacterIterator(str);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '\n') {
                result.append("\\n");
            } else if (character == '\r') {
                result.append("\\r");
            } else if (character == '\\') {
                result.append("\\\\");
            } else if (character == '\"') {
                result.append("\\\"");
            } else if (character == '\'') {
                result.append("\\'");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static void stringBufferReplaceAll(StringBuffer builder, String from, String to) {
        int index = builder.indexOf(from);
        while (index != -1) {
            builder.replace(index, index + from.length(), to);
            index += to.length();
            index = builder.indexOf(from, index);
        }
    }
}

