/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.tcp;

import com.adventnet.wms.nioclient.VariableTimeOutListener;
import com.adventnet.wms.nioclient.tcp.PacketAssembler;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCPConnectionHeartBeatMonitor
extends VariableTimeOutListener {
    private static final Logger LOGGER = Logger.getLogger(TCPConnectionHeartBeatMonitor.class.getName());
    private static final Logger MTLOGGER = Logger.getLogger("messagetracker");
    public static final TCPConnectionHeartBeatMonitor TRACKER = new TCPConnectionHeartBeatMonitor();
    private static long connectiontrackerinterval = 0L;

    private TCPConnectionHeartBeatMonitor() {
        super("ConnectionHeartBeatMonitor", connectiontrackerinterval);
    }

    @Override
    public boolean isExpired(Object obj) {
        return System.currentTimeMillis() >= ((PacketAssembler)obj).getMaxAllowedHeartBeatTime();
    }

    @Override
    public boolean isInvalidEntry(Object obj, long time) {
        return ((PacketAssembler)obj).isInvalidHeartBeatTimeoutEntry(time);
    }

    public void setConnectionTrackerInterval(long time) {
        connectiontrackerinterval = time;
    }

    @Override
    public void handleExpired(ArrayList list) {
        LOGGER.log(Level.INFO, "Expired request list : " + list.size());
        long readexpired = 0L;
        for (PacketAssembler assembler : list) {
            try {
                assembler.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception during close " + e.getMessage());
            }
            ++readexpired;
        }
        if (readexpired > 0L) {
            MTLOGGER.log(Level.INFO, "Failed Heart Beat " + readexpired);
        }
    }
}

