/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.http;

import com.adventnet.wms.nioclient.http.ConnectTimeOutListener;
import com.adventnet.wms.nioclient.http.EventDispatcher;
import com.adventnet.wms.nioclient.http.HttpRequest;
import com.adventnet.wms.nioclient.http.NIONetDataProcessor;
import com.adventnet.wms.nioclient.http.NetworkEventProcessor;
import com.adventnet.wms.nioclient.http.SelectorPool;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SelectorPoolImpl
extends SelectorPool {
    private int scnt = 0;
    private int selectorcount;
    public SelectorProcessor[] selectorarr;
    private int selectorindex;
    private int activeselectiontimeout = 100;
    int printlog = 0;
    private static Logger logger = Logger.getLogger(SelectorPoolImpl.class.getName());

    public SelectorPoolImpl(int count) {
        this.selectorcount = count;
    }

    public SelectorPoolImpl(int count, int timeout) {
        this.selectorcount = count;
        this.activeselectiontimeout = timeout;
    }

    @Override
    public void init() throws IOException {
        this.selectorarr = new SelectorProcessor[this.selectorcount];
        for (int i = 0; i < this.selectorcount; ++i) {
            this.selectorarr[i] = new SelectorProcessor(Selector.open(), i, this.activeselectiontimeout);
            this.selectorarr[i].start();
            System.out.println("Read SelectorProcessor " + i + " Initialized And Started");
        }
        System.out.println("SelectorProcessorPool :: Read SelectorProcessors :: " + this.scnt + " Initialized");
    }

    @Override
    public void connect(String host, int port, HttpRequest request, long connecttimeout) throws IOException {
        this.connect(host, port, request, connecttimeout, -1);
    }

    @Override
    public void connect(String host, int port, HttpRequest request, long connecttimeout, int sendbuffersize) throws IOException {
        SocketChannel sc = SocketChannel.open();
        sc.configureBlocking(false);
        InetAddress iadd = InetAddress.getByName(host);
        sc.connect(new InetSocketAddress(iadd, port));
        if (sendbuffersize != -1) {
            sc.socket().setSendBufferSize(sendbuffersize);
        }
        request.setSocketChannel(sc);
        request.setConnectExpireTime(System.currentTimeMillis() + connecttimeout);
        try {
            this.selectorarr[this.scnt].register(sc, request, false);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.selectorarr[0].register(sc, request, false);
        }
        ++this.scnt;
        this.scnt %= this.selectorcount;
    }

    @Override
    public String getDebugInfo(boolean details) {
        StringBuilder sbuilder = new StringBuilder();
        for (int i = 0; i < this.selectorcount; ++i) {
            sbuilder.append(this.selectorarr[i].getName() + "\r\n");
            if (details) {
                sbuilder.append(this.selectorarr[i].getKeys() + "\r\n");
            }
            sbuilder.append(this.selectorarr[i].getKeySize() + "\r\n");
            Thread.State state = this.selectorarr[i].getThreadState();
            sbuilder.append("State - " + state.name() + "\r\n");
            sbuilder.append("\r\n");
        }
        return sbuilder.toString();
    }

    class SelectorProcessor
    extends Thread {
        private boolean started;
        private Selector selector;
        private int index;
        private int timeout;
        private Vector channelRegVector;

        public SelectorProcessor(Selector selector, int index, int timeout) {
            super("SelectorProcessor-" + index);
            this.started = false;
            this.timeout = 100;
            this.channelRegVector = new Vector();
            this.selector = selector;
            this.index = index;
            this.timeout = timeout;
        }

        public void register(SocketChannel sc, HttpRequest request, boolean tunnel) {
            Object[] channelDetArr = new Object[]{sc, request, tunnel};
            this.channelRegVector.add(channelDetArr);
        }

        private void registerSocketChannels() {
            if (this.channelRegVector == null) {
                return;
            }
            while (this.channelRegVector.size() > 0) {
                try {
                    SelectionKey key;
                    Object[] channelDetArr = new Object[3];
                    channelDetArr = (Object[])this.channelRegVector.firstElement();
                    this.channelRegVector.removeElement(channelDetArr);
                    SocketChannel channel = (SocketChannel)channelDetArr[0];
                    HttpRequest request = (HttpRequest)channelDetArr[1];
                    boolean tunnel = (Boolean)channelDetArr[2];
                    if (!tunnel) {
                        key = channel.register(this.selector, 8);
                        request.setSelectionKey(key);
                        ConnectTimeOutListener.TRACKER.touch(request.getConnectExpireTime(), key);
                    } else {
                        key = channel.register(this.selector, 5);
                        request.setSelectionKey(key);
                    }
                    key.attach(request);
                }
                catch (Exception exp) {
                    logger.log(Level.INFO, "Exception ", exp);
                }
            }
        }

        public String getKeys() {
            return this.selector.keys().toString();
        }

        public String getKeySize() {
            return "" + this.selector.keys().size();
        }

        public Thread.State getThreadState() {
            return this.getState();
        }

        public int getTimeout() {
            return this.timeout;
        }

        @Override
        public void run() {
            this.started = true;
            int i = 0;
            while (true) {
                try {
                    while (true) {
                        this.registerSocketChannels();
                        this.selector.select(this.timeout);
                        if (i == 0) {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                        while (it.hasNext()) {
                            SelectionKey key = it.next();
                            it.remove();
                            try {
                                this.handleKey(key);
                            }
                            catch (IOException e) {
                                try {
                                    HttpRequest obj = (HttpRequest)key.attachment();
                                    obj.close();
                                }
                                catch (Exception obj) {
                                    // empty catch block
                                }
                                SocketChannel ch = null;
                                try {
                                    ch = (SocketChannel)key.channel();
                                }
                                catch (Exception ex) {
                                    logger.log(Level.INFO, "Channel type cast exp", ex);
                                }
                                try {
                                    key.cancel();
                                }
                                catch (Exception ex) {
                                    logger.log(Level.INFO, "Exception in key cancel ", ex);
                                }
                                try {
                                    if (!ch.isOpen()) continue;
                                    ch.close();
                                }
                                catch (Exception ex) {
                                    logger.log(Level.INFO, "Exception in key channel close for client ", ex);
                                }
                            }
                            catch (NullPointerException e) {
                            }
                            catch (RuntimeException rex) {
                                System.out.println("Runtime Exception ");
                            }
                            catch (Exception exception) {}
                        }
                        ++i;
                        i %= 25;
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }

        private void handleKey(SelectionKey key) throws IOException {
            HttpRequest obj = (HttpRequest)key.attachment();
            try {
                if (key.isConnectable()) {
                    try {
                        SocketChannel sc = (SocketChannel)key.channel();
                        if (sc.finishConnect()) {
                            if (obj.isSSL()) {
                                if (!obj.isHSDone()) {
                                    key = sc.register(this.selector, 5);
                                    key.attach(obj);
                                    boolean status = obj.doHandshake(key);
                                    if (status) {
                                        obj.setHSDone();
                                        NetworkEventProcessor.process(obj, 1);
                                    }
                                }
                            } else {
                                NetworkEventProcessor.process(obj, 1);
                                key = sc.register(this.selector, 1);
                                key.attach(obj);
                            }
                        } else {
                            key.interestOps(8);
                        }
                    }
                    catch (Exception ex) {
                        ConnectTimeOutListener.TRACKER.remove(obj.getConnectExpireTime(), key);
                        EventDispatcher.process(obj, -1);
                        if (key != null) {
                            SocketChannel ch = null;
                            try {
                                ch = (SocketChannel)key.channel();
                            }
                            catch (Exception exp) {
                                logger.log(Level.INFO, "Channel type cast exp", ex);
                            }
                            try {
                                key.cancel();
                            }
                            catch (Exception exp) {
                                logger.log(Level.INFO, "Exception in key cancel ", ex);
                            }
                            try {
                                if (ch.isOpen()) {
                                    ch.close();
                                }
                            }
                            catch (Exception exp) {
                                logger.log(Level.INFO, "Exception in key channel close for client", ex);
                            }
                            key.attach(null);
                        }
                        return;
                    }
                }
                if (key.isReadable() || key.isWritable()) {
                    int readyOps = key.readyOps();
                    if (readyOps == 0) {
                        return;
                    }
                    key.interestOps(0);
                    NIONetDataProcessor.process(key, readyOps);
                }
            }
            catch (CancelledKeyException cke) {
                NetworkEventProcessor.process(obj, -5);
                SocketChannel ch = null;
                try {
                    ch = (SocketChannel)key.channel();
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Channel type cast exp", ex);
                }
                try {
                    key.cancel();
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Exception in key cancel", ex);
                }
                try {
                    if (ch.isOpen()) {
                        ch.close();
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Exception in key channel close for client  ", ex);
                }
            }
            catch (Exception ies) {
                NetworkEventProcessor.process(obj, -5);
                SocketChannel ch = null;
                try {
                    ch = (SocketChannel)key.channel();
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Channel type cast exp", ex);
                }
                try {
                    key.cancel();
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Exception in key cancel  ", ex);
                }
                try {
                    if (ch.isOpen()) {
                        ch.close();
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Exception in key channel close for client ", ex);
                }
                String exceptionMsg = ies.getMessage();
                if (exceptionMsg.contains("Inbound closed")) {
                    System.out.println("IOException Inbound closed " + exceptionMsg);
                }
                throw ies;
            }
        }
    }
}

