/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.http;

import java.util.Hashtable;

public class HttpStatus {
    private static Hashtable statusReasons = new Hashtable();
    public static final int OK = 200;
    public static final int MOVED_PERMANENTLY = 301;
    public static final int MOVED_TEMPORARILY = 302;
    public static final int BAD_REQUEST = 400;
    public static final int UNAUTHORIZED = 401;
    public static final int PAYMENT_REQUIRED = 402;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int INTERNAL_SERVER_ERROR = 500;
    public static final int SERVICE_UNAVAILABLE = 503;

    private static void addToStatusReasonMap(int code, String reason) {
        if (code != -1 && reason != null && !reason.equals("")) {
            statusReasons.put(code, reason);
        }
    }

    public static String getReasonForHttpStatus(int code) {
        if (code != -1) {
            return (String)statusReasons.get(code);
        }
        return null;
    }

    static {
        HttpStatus.addToStatusReasonMap(200, "OK");
        HttpStatus.addToStatusReasonMap(301, "Moved Permanently");
        HttpStatus.addToStatusReasonMap(302, "Moved Temporarily");
        HttpStatus.addToStatusReasonMap(400, "Bad Request");
        HttpStatus.addToStatusReasonMap(401, "Unauthorized");
        HttpStatus.addToStatusReasonMap(402, "Payment Required");
        HttpStatus.addToStatusReasonMap(404, "Not Found");
        HttpStatus.addToStatusReasonMap(500, "Internal Server Error");
        HttpStatus.addToStatusReasonMap(503, "Service Unavailable");
    }
}

