/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.http;

import com.adventnet.wms.nioclient.http.HttpRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventDispatcher {
    private static Logger logger = Logger.getLogger(EventDispatcher.class.getName());
    private static LinkedBlockingQueue queue = new LinkedBlockingQueue();
    private static ThreadPoolExecutor executor;
    private static boolean initialized;

    public static synchronized void initialize(int threadCount) {
        if (initialized) {
            return;
        }
        executor = new ThreadPoolExecutor(threadCount, threadCount, 100L, TimeUnit.MILLISECONDS, queue);
        initialized = true;
    }

    public static void process(HttpRequest request, int eventcode) {
        if (!initialized) {
            EventDispatcher.initialize(2);
        }
        executor.execute(new RequestEventDispatcher(request, eventcode));
    }

    public static void process(HttpRequest request, int eventcode, byte[] data) {
        if (!initialized) {
            EventDispatcher.initialize(2);
        }
        executor.execute(new RequestEventDispatcher(request, eventcode, data));
    }

    public static List<Runnable> shutdown() {
        List<Runnable> list = new ArrayList<Runnable>();
        try {
            if (executor == null) {
                initialized = false;
                return list;
            }
            list = executor.shutdownNow();
            if (list.isEmpty()) {
                executor = null;
                initialized = false;
            }
            return list;
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in eventdispatcher shutdown ", e);
            return null;
        }
    }

    static {
        initialized = false;
    }

    static class RequestEventDispatcher
    implements Runnable {
        private HttpRequest request;
        private int eventcode;
        private byte[] data = null;

        public RequestEventDispatcher(HttpRequest request, int eventcode) {
            this.request = request;
            this.eventcode = eventcode;
        }

        public RequestEventDispatcher(HttpRequest request, int eventcode, byte[] data) {
            this.request = request;
            this.eventcode = eventcode;
            this.data = data;
        }

        @Override
        public void run() {
            try {
                this.request.notifyListener(this.eventcode, this.data);
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception in EventDispatcher : ", ex);
            }
        }
    }
}

