/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.http;

import com.adventnet.wms.nioclient.VariableTimeOutListener;
import com.adventnet.wms.nioclient.http.HttpRequest;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectTimeOutListener
extends VariableTimeOutListener {
    private static Logger logger = Logger.getLogger(ConnectTimeOutListener.class.getName());
    private static long timerinterval = 10000L;
    public static final ConnectTimeOutListener TRACKER = new ConnectTimeOutListener(timerinterval);

    private ConnectTimeOutListener(long timerinterval) {
        super("ConnectTimeOutListener ", timerinterval);
    }

    @Override
    public boolean isExpired(Object obj) {
        try {
            HttpRequest req = (HttpRequest)((SelectionKey)obj).attachment();
            return req.isConnectExpired();
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Override
    public boolean isInvalidEntry(Object obj, long time) {
        try {
            HttpRequest req = (HttpRequest)((SelectionKey)obj).attachment();
            return req.isInvalidConnectExpireTime(time);
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Override
    public void handleExpired(ArrayList list) {
        logger.log(Level.INFO, "Expired Connect list : {0}", new Object[]{list.size()});
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            try {
                SelectionKey key = (SelectionKey)itr.next();
                HttpRequest req = (HttpRequest)key.attachment();
                req.notifyListener(-1);
                if (key == null) continue;
                SocketChannel ch = null;
                try {
                    ch = (SocketChannel)key.channel();
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Channel type cast exp", ex);
                }
                try {
                    key.cancel();
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Exception in key cancel ", ex);
                }
                try {
                    if (ch.isOpen()) {
                        ch.close();
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Exception in key channel close for client ", ex);
                }
                key.attach(null);
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "CONNECT TIMEOUT LISTENER ERROR : ", ex);
            }
        }
    }

    public static void setTimerInterval(long interval) {
        timerinterval = interval;
    }
}

