/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.apns;

import com.adventnet.wms.nioclient.apns.APNSEventDispatcher;
import com.adventnet.wms.nioclient.apns.APNSNetworkEventProcessor;
import com.adventnet.wms.nioclient.apns.APNSRequest;
import com.adventnet.wms.nioclient.apns.APNSSelectorPool;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Vector;

public class APNSSelectorPoolImpl
extends APNSSelectorPool {
    private int scnt = 0;
    private int selectorcount;
    public SelectorProcessor[] selectorarr;
    private int selectorindex;
    private int activeselectiontimeout = 1;
    int printlog = 0;

    public APNSSelectorPoolImpl(int count) {
        this.selectorcount = count;
    }

    @Override
    public void init() throws IOException {
        this.selectorarr = new SelectorProcessor[this.selectorcount];
        for (int i = 0; i < this.selectorcount; ++i) {
            this.selectorarr[i] = new SelectorProcessor(Selector.open(), i);
            this.selectorarr[i].start();
            System.out.println("Read SelectorProcessor " + i + " Initialized And Started");
        }
        System.out.println("SelectorProcessorPool :: Read SelectorProcessors :: " + this.scnt + " Initialized");
    }

    @Override
    public void connect(String host, int port, APNSRequest request) throws IOException {
        SocketChannel sc = SocketChannel.open();
        sc.configureBlocking(false);
        InetAddress iadd = InetAddress.getByName(host);
        sc.connect(new InetSocketAddress(iadd, port));
        request.setSocketChannel(sc);
        this.selectorarr[this.scnt].register(sc, request);
        ++this.scnt;
        this.scnt %= this.selectorcount;
    }

    @Override
    public String getDebugInfo(boolean details) {
        StringBuilder sbuilder = new StringBuilder();
        for (int i = 0; i < this.selectorcount; ++i) {
            sbuilder.append(this.selectorarr[i].getName() + "\r\n");
            if (details) {
                sbuilder.append(this.selectorarr[i].getKeys() + "\r\n");
            }
            sbuilder.append(this.selectorarr[i].getKeySize() + "\r\n");
            Thread.State state = this.selectorarr[i].getThreadState();
            sbuilder.append("State - " + state.name() + "\r\n");
            sbuilder.append("\r\n");
        }
        return sbuilder.toString();
    }

    class SelectorProcessor
    extends Thread {
        private boolean started;
        private Selector selector;
        private int index;
        private int timeout;
        private Vector channelRegVector;

        public SelectorProcessor(Selector selector, int index) {
            super("SelectorProcessor-" + index);
            this.started = false;
            this.timeout = 100;
            this.channelRegVector = new Vector();
            this.selector = selector;
            this.index = index;
        }

        public void register(SocketChannel sc, APNSRequest request) {
            Object[] channelDetArr = new Object[]{sc, request};
            this.channelRegVector.add(channelDetArr);
        }

        private void registerSocketChannels() {
            if (this.channelRegVector == null) {
                return;
            }
            while (this.channelRegVector.size() > 0) {
                try {
                    Object[] channelDetArr = new Object[3];
                    channelDetArr = (Object[])this.channelRegVector.firstElement();
                    this.channelRegVector.removeElement(channelDetArr);
                    SocketChannel channel = (SocketChannel)channelDetArr[0];
                    APNSRequest request = (APNSRequest)channelDetArr[1];
                    SelectionKey key = channel.register(this.selector, 8);
                    key.attach(request);
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
        }

        public String getKeys() {
            return this.selector.keys().toString();
        }

        public String getKeySize() {
            return "" + this.selector.keys().size();
        }

        public Thread.State getThreadState() {
            return this.getState();
        }

        public int getTimeout() {
            return this.timeout;
        }

        @Override
        public void run() {
            this.started = true;
            int i = 0;
            while (true) {
                try {
                    while (true) {
                        this.registerSocketChannels();
                        this.selector.select(this.timeout);
                        if (i == 0) {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                        while (it.hasNext()) {
                            SelectionKey key = it.next();
                            it.remove();
                            try {
                                this.handleKey(key);
                            }
                            catch (IOException e) {
                                try {
                                    APNSRequest obj = (APNSRequest)key.attachment();
                                    obj.close();
                                }
                                catch (Exception obj) {
                                    // empty catch block
                                }
                                try {
                                    key.channel().close();
                                }
                                catch (Exception ex) {
                                    System.out.println("Exception while closing socket channel " + e.getMessage());
                                }
                                key.cancel();
                            }
                            catch (NullPointerException e) {
                                e.printStackTrace();
                            }
                            catch (RuntimeException rex) {
                                System.out.println("Runtime Exception ");
                                rex.printStackTrace();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        ++i;
                        i %= 25;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        private void handleKey(SelectionKey key) throws IOException {
            block27: {
                APNSRequest obj = (APNSRequest)key.attachment();
                try {
                    if (key.isConnectable()) {
                        try {
                            SocketChannel sc = (SocketChannel)key.channel();
                            if (sc.finishConnect()) {
                                if (obj.isSSL()) {
                                    if (!obj.isHSDone()) {
                                        key = sc.register(this.selector, 5);
                                        key.attach(obj);
                                        boolean status = obj.doHandshake(key);
                                        if (status) {
                                            obj.setHSDone();
                                            APNSNetworkEventProcessor.process(obj, 1);
                                        }
                                    }
                                } else {
                                    APNSNetworkEventProcessor.process(obj, 1);
                                    key = sc.register(this.selector, 1);
                                    key.attach(obj);
                                }
                            } else {
                                key.interestOps(8);
                            }
                        }
                        catch (IOException ex) {
                            APNSEventDispatcher.process(obj, -1);
                            throw ex;
                        }
                    }
                    if (!key.isReadable() && !key.isWritable()) break block27;
                    if (obj.isSSL()) {
                        if (!obj.isHSDone()) {
                            try {
                                boolean status = obj.doHandshake(key);
                                if (status) {
                                    obj.setHSDone();
                                    APNSNetworkEventProcessor.process(obj, 1);
                                }
                                break block27;
                            }
                            catch (IOException ex) {
                                APNSEventDispatcher.process(obj, -1);
                                throw ex;
                            }
                        }
                        obj.readData(key);
                        break block27;
                    }
                    obj.readData(key);
                    key.interestOps(1);
                }
                catch (CancelledKeyException cke) {
                    try {
                        obj.close();
                    }
                    catch (Exception status) {
                        // empty catch block
                    }
                    try {
                        key.channel().close();
                    }
                    catch (Exception ex) {
                        System.out.println("Exception during channel close " + ex.getMessage());
                    }
                    key.cancel();
                }
                catch (IOException ies) {
                    APNSNetworkEventProcessor.process(obj, -5);
                    try {
                        Thread.sleep(1L);
                        obj.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    try {
                        key.channel().close();
                    }
                    catch (Exception ex) {
                        System.out.println("Exception during channel close " + ex.getMessage());
                    }
                    key.cancel();
                    String exceptionMsg = ies.getMessage();
                    if (exceptionMsg.contains("Inbound closed")) {
                        System.out.println("IOException Inbound closed " + exceptionMsg);
                    } else {
                        ies.printStackTrace();
                    }
                    throw ies;
                }
            }
        }
    }
}

