/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.apns;

import com.adventnet.wms.nioclient.SSLWrapper;
import com.adventnet.wms.nioclient.apns.APNSEventDispatcher;
import com.adventnet.wms.nioclient.apns.APNSListener;
import com.adventnet.wms.nioclient.apns.APNSPayload;
import com.adventnet.wms.nioclient.apns.APNSResponse;
import com.adventnet.wms.nioclient.apns.APNSSelectorPoolFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class APNSRequest {
    protected boolean hsdone = false;
    protected boolean isSSL = false;
    protected ByteBuffer byteBuffer = null;
    protected String host = null;
    protected int port = -1;
    protected String provider = null;
    protected String setup = null;
    protected int zeroReadCount = 0;
    protected int maxZeroReadCount = 25;
    protected APNSResponse response = null;
    protected APNSListener listener = null;
    protected SSLWrapper ssl = null;
    protected SocketChannel sc = null;
    protected final int MAX_SIZE = 3072;
    protected final int MAX_WRITE_SIZE = 0x100000;
    protected final int max_payload_size_default = 256;
    protected final int max_payload_size_default_v_8 = 2048;
    protected int pendingcount = -1;
    private int identifier = -1;
    private int status = -1;
    private int command = -1;
    protected SelectionKey key = null;
    protected boolean closed = false;
    private ArrayList failedNotifications = new ArrayList();

    public APNSRequest(String host, int port, String provider, String setup) {
        this.host = host;
        this.port = port;
        this.provider = provider;
        this.setup = setup;
        this.isSSL = true;
    }

    public void setListener(APNSListener listener) {
        this.listener = listener;
    }

    public void connect() throws IOException {
        APNSSelectorPoolFactory.getInstance(this.port).connect(this.host, this.port, this);
        this.byteBuffer = ByteBuffer.allocate(3072);
    }

    public void setSocketChannel(SocketChannel sc) {
        try {
            this.sc = sc;
            if (this.isSSL) {
                String contxtkey = this.host + "_" + this.provider + "_" + this.setup;
                this.ssl = new SSLWrapper(sc, this.host);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setHSDone() {
        this.hsdone = true;
        this.pushFailedNotifications();
    }

    public boolean isHSDone() {
        return this.hsdone;
    }

    public boolean isSSL() {
        return this.isSSL;
    }

    public boolean doHandshake(SelectionKey key) throws IOException {
        if (this.key == null) {
            this.key = key;
        }
        return this.ssl.doHandshake(key);
    }

    public void readData(SelectionKey key) throws IOException, CancelledKeyException {
        try {
            if (this.key == null) {
                this.key = key;
            }
            int count = -1;
            if (this.isSSL) {
                if (this.ssl.doHandshake(key)) {
                    count = this.ssl.read();
                    this.byteBuffer = this.ssl.getDataBuffer();
                }
            } else {
                count = ((SocketChannel)key.channel()).read(this.byteBuffer);
            }
            if (count > 0) {
                if (count >= 6) {
                    this.byteBuffer.flip();
                    this.command = this.byteBuffer.get();
                    this.status = this.byteBuffer.get();
                    this.identifier = this.byteBuffer.getInt();
                    this.response = new APNSResponse(this.command, this.status, this.identifier);
                    APNSEventDispatcher.process(this, -6);
                    this.close();
                } else {
                    this.key.interestOps(1);
                }
            } else {
                if (count < 0) {
                    throw new IOException("Read -1");
                }
                if (count == 0) {
                    key.interestOps(1);
                }
            }
        }
        catch (IOException ex) {
            APNSEventDispatcher.process(this, -5);
            throw ex;
        }
        catch (Exception exp) {
            APNSEventDispatcher.process(this, -5);
            throw new IOException(exp.getMessage());
        }
    }

    public void sendNotification(String devicetoken, int identifier, APNSPayload payload) throws Exception {
        byte[] formatteddata = this.getFormattedData(devicetoken, identifier, payload);
        int max_payload_size = 256;
        if (payload.getOSVersion() >= 8) {
            max_payload_size = 2048;
        }
        if (formatteddata.length > max_payload_size) {
            throw new IOException("Payload size exceeded the limit");
        }
        ByteBuffer writeBB = ByteBuffer.allocate(formatteddata.length);
        writeBB.put(formatteddata);
        try {
            this.doWrite(writeBB);
        }
        catch (IllegalStateException ex) {
            Hashtable<String, Object> ht = new Hashtable<String, Object>();
            ht.put("token", devicetoken);
            ht.put("identifier", "" + identifier);
            ht.put("payload", payload);
            this.failedNotifications.add(ht);
        }
    }

    public ArrayList sendNotification(ArrayList payloadlist) throws Exception {
        ArrayList failedlist = new ArrayList();
        ArrayList<Hashtable> templist = new ArrayList<Hashtable>();
        ByteBuffer writeBB = ByteBuffer.allocate(0x100000);
        Iterator itr = payloadlist.iterator();
        while (itr.hasNext()) {
            Hashtable payloadht = (Hashtable)itr.next();
            String devicetoken = (String)payloadht.get("token");
            int identifier = Integer.parseInt((String)payloadht.get("identifier"));
            APNSPayload payload = (APNSPayload)payloadht.get("payload");
            byte[] formatteddata = this.getFormattedData(devicetoken, identifier, payload);
            int max_payload_size = 256;
            if (payload.getOSVersion() >= 8) {
                max_payload_size = 2048;
            }
            if (formatteddata.length > max_payload_size) {
                failedlist.add(payloadht);
                continue;
            }
            if (writeBB.limit() - writeBB.position() >= formatteddata.length) {
                templist.add(payloadht);
                writeBB.put(formatteddata);
                continue;
            }
            try {
                this.doWrite(writeBB);
            }
            catch (IOException ex) {
                failedlist.addAll(templist);
                templist = new ArrayList();
            }
            catch (IllegalStateException ex) {
                this.failedNotifications.addAll(templist);
                templist = new ArrayList();
            }
            if (itr.hasNext()) {
                writeBB = ByteBuffer.allocate(0x100000);
                writeBB.put(formatteddata);
                continue;
            }
            writeBB = ByteBuffer.allocate(formatteddata.length);
            writeBB.put(formatteddata);
        }
        if (writeBB.position() > 0) {
            try {
                this.doWrite(writeBB);
            }
            catch (IllegalStateException ex) {
                this.failedNotifications.addAll(templist);
            }
            catch (IOException ex) {
                failedlist.addAll(templist);
            }
        }
        return failedlist;
    }

    public ArrayList sendNotification(ArrayList deviceTokenList, ArrayList identifierList, APNSPayload payload) throws Exception {
        ArrayList<String> failedlist = new ArrayList<String>();
        ArrayList templist = new ArrayList();
        ByteBuffer writeBB = ByteBuffer.allocate(0x100000);
        for (int i = 0; i < deviceTokenList.size(); ++i) {
            String devicetoken = (String)deviceTokenList.get(i);
            int identifier = Integer.parseInt((String)identifierList.get(i));
            byte[] formatteddata = this.getFormattedData(devicetoken, identifier, payload);
            int max_payload_size = 256;
            if (payload.getOSVersion() >= 8) {
                max_payload_size = 2048;
            }
            if (formatteddata.length > max_payload_size) {
                failedlist.add(devicetoken);
                continue;
            }
            if (writeBB.limit() - writeBB.position() >= formatteddata.length) {
                Hashtable<String, Object> ht = new Hashtable<String, Object>();
                ht.put("token", devicetoken);
                ht.put("identifier", "" + identifier);
                ht.put("payload", payload);
                templist.add(ht);
                writeBB.put(formatteddata);
                continue;
            }
            try {
                this.doWrite(writeBB);
            }
            catch (IOException ex) {
                failedlist.addAll(templist);
                templist = new ArrayList();
            }
            catch (IllegalStateException ex) {
                this.failedNotifications.addAll(templist);
                templist = new ArrayList();
            }
            if (i + 1 < deviceTokenList.size()) {
                writeBB = ByteBuffer.allocate(0x100000);
                writeBB.put(formatteddata);
                continue;
            }
            if (i + 1 != deviceTokenList.size()) continue;
            writeBB = ByteBuffer.allocate(formatteddata.length);
            writeBB.put(formatteddata);
        }
        if (writeBB.position() > 0) {
            try {
                this.doWrite(writeBB);
            }
            catch (IllegalStateException ex) {
                this.failedNotifications.addAll(templist);
            }
            catch (IOException ex) {
                failedlist.addAll(templist);
            }
        }
        return failedlist;
    }

    private void doWrite(ByteBuffer writeBB) throws IOException {
        writeBB.flip();
        if (this.isSSL) {
            this.ssl.write(writeBB);
        } else {
            this.sc.write(writeBB);
        }
    }

    private void pushFailedNotifications() {
        Iterator itr = this.failedNotifications.iterator();
        while (itr.hasNext()) {
            Hashtable ht = (Hashtable)itr.next();
            String devicetoken = (String)ht.get("token");
            int identifier = Integer.parseInt((String)ht.get("identifier"));
            APNSPayload payload = (APNSPayload)ht.get("payload");
            try {
                this.sendNotification(devicetoken, identifier, payload);
                itr.remove();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private byte[] getFormattedData(String devicetoken, int identifier, APNSPayload payload) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(2);
        ByteArrayOutputStream framebaos = new ByteArrayOutputStream();
        framebaos.write(1);
        devicetoken = devicetoken.toUpperCase();
        int tokenlength = devicetoken.length();
        byte[] tokenbytes = new byte[tokenlength / 2];
        int j = 0;
        for (int i = 0; i < tokenlength; i += 2) {
            tokenbytes[j++] = (byte)Integer.parseInt(devicetoken.substring(i, i + 2), 16);
        }
        int tokenbyteslength = tokenbytes.length;
        byte[] tokenlengtharr = new byte[]{(byte)(tokenbyteslength >> 8 & 0xFF), (byte)(tokenbyteslength & 0xFF)};
        framebaos.write(tokenlengtharr);
        framebaos.write(tokenbytes);
        framebaos.write(2);
        byte[] payloadbytes = payload.getBytes();
        int pllength = payloadbytes.length;
        byte[] pllengtharr = new byte[]{(byte)(pllength >> 8 & 0xFF), (byte)(pllength & 0xFF)};
        framebaos.write(pllengtharr);
        framebaos.write(payloadbytes);
        framebaos.write(3);
        byte[] identifierarr = new byte[]{(byte)(identifier >> 24 & 0xFF), (byte)(identifier >> 16 & 0xFF), (byte)(identifier >> 8 & 0xFF), (byte)(identifier & 0xFF)};
        int idlen = identifierarr.length;
        byte[] identifierarrlength = new byte[]{(byte)(idlen >> 8 & 0xFF), (byte)(idlen & 0xFF)};
        framebaos.write(identifierarrlength);
        framebaos.write(identifierarr);
        framebaos.write(4);
        int expiry = payload.getExpiry();
        expiry = expiry < 0 ? 0 : expiry;
        long time = System.currentTimeMillis();
        long expiretime = (time + (long)(expiry * 1000)) / 1000L;
        byte[] expiretimearr = new byte[]{(byte)(expiretime >> 24 & 0xFFL), (byte)(expiretime >> 16 & 0xFFL), (byte)(expiretime >> 8 & 0xFFL), (byte)(expiretime & 0xFFL)};
        int expiretimelen = expiretimearr.length;
        byte[] expiretimearrlength = new byte[]{(byte)(expiretimelen >> 8 & 0xFF), (byte)(expiretimelen & 0xFF)};
        framebaos.write(expiretimearrlength);
        framebaos.write(expiretimearr);
        int prioritylength = 1;
        byte[] priorityarrlen = new byte[]{(byte)(prioritylength >> 8 & 0xFF), (byte)(prioritylength & 0xFF)};
        framebaos.write(5);
        framebaos.write(priorityarrlen);
        framebaos.write(10);
        byte[] framearray = framebaos.toByteArray();
        int framelength = framearray.length;
        byte[] framearrlength = new byte[]{(byte)(framelength >> 24 & 0xFF), (byte)(framelength >> 16 & 0xFF), (byte)(framelength >> 8 & 0xFF), (byte)(framelength & 0xFF)};
        baos.write(framearrlength);
        baos.write(framearray);
        byte[] data = baos.toByteArray();
        return data;
    }

    public void close() {
        try {
            if (this.isSSL) {
                this.ssl.close();
            } else {
                this.sc.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.key.channel().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.key.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void notifyListener(int event) throws Exception {
        switch (event) {
            case -1: {
                this.listener.onConnectError();
                return;
            }
            case -6: {
                this.listener.onNotificationFailure(this.command, this.status, this.identifier);
                return;
            }
            case -5: {
                this.listener.onDisconnect();
                return;
            }
        }
    }
}

