/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient;

import com.adventnet.wms.nioclient.SSLManager;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;

public class SSLWrapper {
    private SocketChannel sc;
    private SelectionKey key;
    private ByteBuffer dataBuffer;
    private static int dataBBSize = 4096;
    protected SSLEngine sslEngine = null;
    private int appSize;
    private int netSize;
    private ByteBuffer inBB;
    private ByteBuffer outBB;
    private int max_size = 0x100000;
    private static ByteBuffer handShakeBB = ByteBuffer.allocate(0);
    private SSLEngineResult.HandshakeStatus sslHSStatus;
    private boolean sslHSComplete;
    private boolean close = false;
    private int sizecheckcounter = 0;
    private Map handshakeReports = new LinkedHashMap();
    private boolean closehsinitiated = false;
    private static Logger logger = Logger.getLogger(SSLWrapper.class.getName());

    public SSLWrapper(SocketChannel sc, String host) throws IOException {
        this(sc, host, null);
    }

    public SSLWrapper(SocketChannel sc, String host, String sniServerName) throws IOException {
        this(sc, SSLManager.getSSLEngine(host), host, sniServerName, false);
    }

    public SSLWrapper(SocketChannel sc, SSLEngine sslEng, String host, String sniServerName, boolean connectionReuse) throws IOException {
        this.sc = sc;
        sc.configureBlocking(false);
        this.sslEngine = sslEng;
        try {
            String[] s = this.sslEngine.getEnabledProtocols();
            ArrayList<String> protocolSupportedList = new ArrayList<String>(Arrays.asList(s));
            if (host != null && SSLManager.ignoreSSLVersion(host)) {
                protocolSupportedList.removeAll(SSLManager.getSSLVersionIgnoreList());
                this.sslEngine.setEnabledProtocols(protocolSupportedList.toArray(new String[0]));
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception in SSLWrapper ", ex);
        }
        if (!connectionReuse) {
            this.sslEngine.setUseClientMode(true);
        }
        if (sniServerName != null) {
            this.setSni(this.sslEngine, sniServerName);
        } else {
            this.setSni(this.sslEngine, host);
        }
        this.sslHSStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        this.sslHSComplete = false;
        this.netSize = this.sslEngine.getSession().getPacketBufferSize();
        this.inBB = ByteBuffer.allocate(this.netSize);
        this.outBB = ByteBuffer.allocate(this.netSize);
        this.outBB.position(0);
        this.outBB.limit(0);
        this.appSize = this.sslEngine.getSession().getApplicationBufferSize();
        this.dataBuffer = ByteBuffer.allocate(this.appSize);
    }

    private void setSni(SSLEngine sslEngine, String sniServerName) {
        try {
            if (sniServerName != null && !sniServerName.isEmpty()) {
                String regex = "^((?!-)[A-Za-z0-9-]{1,63}(?<!-)\\.)+[A-Za-z]{2,6}$";
                if (!sniServerName.matches(regex)) {
                    logger.log(Level.SEVERE, "Invalid DomainName : {0}. Proceeding without setting sni name.", new Object[]{sniServerName});
                    return;
                }
                SSLParameters params = sslEngine.getSSLParameters();
                ArrayList<SNIServerName> list = new ArrayList<SNIServerName>();
                SNIHostName serverName = new SNIHostName(sniServerName);
                list.add(serverName);
                params.setServerNames(list);
                sslEngine.setSSLParameters(params);
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception in setServerName : ", ex);
        }
    }

    public void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    public SSLEngine getSSLEngine() {
        return this.sslEngine;
    }

    private void resizeDataBB() {
        if (this.dataBuffer.remaining() < this.appSize && this.dataBuffer.capacity() > 0 && this.dataBuffer.capacity() < this.max_size) {
            ByteBuffer bb = ByteBuffer.allocate(this.dataBuffer.capacity() * 2);
            this.dataBuffer.flip();
            bb.put(this.dataBuffer);
            this.dataBuffer = bb;
        }
    }

    public void clearDataBuffer() {
        this.dataBuffer.clear();
    }

    public void resizeDataBuffer() {
        byte[] b = new byte[this.dataBuffer.remaining()];
        this.dataBuffer.get(b);
        this.dataBuffer.clear();
        this.dataBuffer.put(b);
    }

    private boolean flush(ByteBuffer bb) throws IOException {
        this.sc.write(bb);
        return !bb.hasRemaining();
    }

    public Map handshakeReports() {
        return this.handshakeReports;
    }

    public void setSSLHSComplete(boolean status) {
        this.sslHSComplete = status;
    }

    public boolean doHandshake(SelectionKey sk) throws IOException {
        if (this.key == null) {
            this.key = sk;
        }
        if (!this.handshakeReports.containsKey("handshakeinittime")) {
            this.handshakeReports.put("handshakeinittime", System.currentTimeMillis());
        }
        if (this.sslHSComplete) {
            return this.sslHSComplete;
        }
        if (this.outBB.hasRemaining()) {
            if (!this.flush(this.outBB)) {
                return false;
            }
            switch (this.sslHSStatus) {
                case FINISHED: {
                    this.sslHSComplete = true;
                }
                case NEED_UNWRAP: {
                    if (sk == null) break;
                    sk.interestOps(1);
                }
            }
            return this.sslHSComplete;
        }
        block4 : switch (this.sslHSStatus) {
            case NEED_UNWRAP: {
                SSLEngineResult result;
                if (this.sc.read(this.inBB) == -1) {
                    this.inBB.flip();
                    SSLEngineResult result2 = this.sslEngine.unwrap(this.inBB, this.dataBuffer);
                    this.sslEngine.closeInbound();
                    throw new IOException("SSL Handshake : Read -1");
                }
                block22: while (this.sslHSStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    this.inBB.flip();
                    result = this.sslEngine.unwrap(this.inBB, this.dataBuffer);
                    this.inBB.compact();
                    this.sslHSStatus = result.getHandshakeStatus();
                    switch (result.getStatus()) {
                        case OK: {
                            switch (this.sslHSStatus) {
                                case NOT_HANDSHAKING: {
                                    throw new IOException("SSL - Invalid handshake");
                                }
                                case NEED_TASK: {
                                    this.sslHSStatus = this.doTasks();
                                    break;
                                }
                                case FINISHED: {
                                    this.sslHSComplete = true;
                                    break block22;
                                }
                            }
                            continue block22;
                        }
                        case BUFFER_UNDERFLOW: {
                            if (sk == null) break block22;
                            sk.interestOps(1);
                            break block22;
                        }
                        case CLOSED: {
                            this.sslEngine.closeInbound();
                        }
                        default: {
                            throw new IOException("SSL - Invalid handshake " + (Object)((Object)result.getStatus()));
                        }
                    }
                }
                if (this.sslHSStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP) break;
            }
            case NEED_WRAP: {
                this.outBB.clear();
                SSLEngineResult result = this.sslEngine.wrap(handShakeBB, this.outBB);
                this.outBB.flip();
                this.sslHSStatus = result.getHandshakeStatus();
                switch (result.getStatus()) {
                    case OK: {
                        if (this.sslHSStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                            this.sslHSStatus = this.doTasks();
                        }
                        if (sk == null) break block4;
                        sk.interestOps(4);
                        break block4;
                    }
                    default: {
                        throw new IOException("SSL Invalid handshake " + (Object)((Object)result.getStatus()));
                    }
                }
            }
            case FINISHED: {
                this.sslHSComplete = true;
                break;
            }
            default: {
                throw new RuntimeException("SSL Invlaid hand shake state" + (Object)((Object)this.sslHSStatus));
            }
        }
        if (this.sslHSComplete) {
            this.handshakeReports.put("handshakeend", System.currentTimeMillis());
            this.handshakeReports.put("handshaketime", Long.parseLong(this.handshakeReports.get("handshakeend").toString()) - Long.parseLong(this.handshakeReports.get("handshakeinittime").toString()));
        }
        return this.sslHSComplete;
    }

    private SSLEngineResult.HandshakeStatus doTasks() {
        Runnable runnable;
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    public int read() throws IOException {
        SSLEngineResult result;
        if (!this.sslHSComplete) {
            throw new IllegalStateException();
        }
        int pos = this.dataBuffer.position();
        if (pos > 25600) {
            ++this.sizecheckcounter;
            if (this.sizecheckcounter > 25) {
                throw new IOException("Looping");
            }
            return pos;
        }
        this.sizecheckcounter = 0;
        if (this.sc.read(this.inBB) == -1) {
            this.sslEngine.closeInbound();
            return -1;
        }
        int currentpos = this.dataBuffer.position();
        block4: do {
            this.resizeDataBB();
            this.inBB.flip();
            result = this.sslEngine.unwrap(this.inBB, this.dataBuffer);
            this.inBB.compact();
            currentpos = this.dataBuffer.position();
            switch (result.getStatus()) {
                case OK: 
                case BUFFER_UNDERFLOW: {
                    if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue block4;
                    this.doTasks();
                    break;
                }
                case CLOSED: {
                    this.sslEngine.closeInbound();
                }
                default: {
                    if (this.dataBuffer.position() - pos > 0) continue block4;
                    throw new IOException("SSL sslEngine error read " + (Object)((Object)result.getStatus()));
                }
            }
        } while (result.bytesProduced() != 0 && currentpos < this.max_size && this.inBB.position() != 0 && result.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW);
        return this.dataBuffer.position() - pos;
    }

    public ByteBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public int write(ByteBuffer src) throws IOException {
        if (!this.sslHSComplete) {
            throw new IllegalStateException("SSL Invalid Handshake state Write");
        }
        return this.completeWrite(src);
    }

    private int completeWrite(ByteBuffer src) throws IOException {
        int retValue = 0;
        if (this.outBB.hasRemaining() && !this.flush(this.outBB)) {
            return retValue;
        }
        this.outBB.clear();
        SSLEngineResult result = this.sslEngine.wrap(src, this.outBB);
        retValue = result.bytesConsumed();
        this.outBB.flip();
        switch (result.getStatus()) {
            case OK: {
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) break;
                this.doTasks();
                break;
            }
            default: {
                throw new IOException("SSL slEngine error write " + (Object)((Object)result.getStatus()));
            }
        }
        if (this.outBB.hasRemaining()) {
            this.flush(this.outBB);
        }
        return retValue;
    }

    public boolean close() throws IOException {
        if (!this.closehsinitiated) {
            SSLEngineResult result = null;
            if (this.sslEngine.isInboundDone()) {
                this.sslEngine.closeInbound();
            }
            this.sslEngine.closeOutbound();
            this.outBB.clear();
            result = this.sslEngine.wrap(handShakeBB, this.outBB);
            if (result.getStatus() != SSLEngineResult.Status.CLOSED) {
                throw new SSLException("SSL Invalid close state");
            }
            this.outBB.flip();
            this.closehsinitiated = true;
            this.flush(this.outBB);
        } else if (this.outBB.hasRemaining()) {
            this.flush(this.outBB);
        }
        if (this.outBB.hasRemaining()) {
            this.key.interestOps(5);
            return false;
        }
        return this.sslEngine.isOutboundDone() && !this.outBB.hasRemaining();
    }
}

