/*
 * Decompiled with CFR 0.152.
 */
package elastix16.com.zohocorp.zoho.ztiimpl;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class ConfManager {
    private static String serverConfFile = "";
    private static String servername = null;
    private static String username = null;
    private static String passwd = null;
    private static String outgoingcallcontext = null;
    private static String outboundcallchannel = "SIP";
    private static boolean isCallRecording = Boolean.FALSE;
    private static String callRecordingDomain = "";
    private static String callRecordingFolderStructure = "";
    private static String callRecordingFileStruture = "";
    private static String callRecordingFormat = "wav";
    private static boolean developement = Boolean.FALSE;
    private static boolean randomDuration = Boolean.FALSE;

    public static boolean initialize(String confpath) {
        serverConfFile = confpath + File.separator + "conf" + File.separator + "elastix.properties";
        try {
            Properties serverConf = ConfManager.getProperties(serverConfFile);
            servername = serverConf.getProperty("asterisk.server");
            username = serverConf.getProperty("asterisk.manager.username");
            passwd = serverConf.getProperty("asterisk.manager.password");
            outgoingcallcontext = serverConf.getProperty("outgoingcallcontext");
            outboundcallchannel = serverConf.getProperty("outboundcallchannel");
            isCallRecording = Boolean.valueOf(serverConf.getProperty("callrecording"));
            callRecordingDomain = serverConf.getProperty("callrecording.domainname");
            callRecordingFolderStructure = serverConf.getProperty("callrecording.folderstructure");
            callRecordingFileStruture = serverConf.getProperty("callrecording.filenameformat");
            callRecordingFormat = serverConf.getProperty("callrecording.fileformat");
            developement = Boolean.valueOf(serverConf.getProperty("developement"));
            randomDuration = Boolean.valueOf(serverConf.getProperty("randomDuration"));
            return true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return false;
        }
    }

    public static Properties getProperties(String propsFile) {
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(propsFile));
            return props;
        }
        catch (Exception exp) {
            System.out.println("Unable to load conf file " + propsFile);
            exp.printStackTrace();
            return null;
        }
    }

    public static String getServerName() {
        return servername;
    }

    public static String getManagerUserName() {
        return username;
    }

    public static String getManagerPasswd() {
        return passwd;
    }

    public static String getOutGoingCallContext() {
        return outgoingcallcontext;
    }

    public static boolean isCallRecordingEnabled() {
        return isCallRecording;
    }

    public static String getCallRecordingDomain() {
        return callRecordingDomain;
    }

    public static String getCallRecordingFolderStructure() {
        return callRecordingFolderStructure;
    }

    public static String getCallRecordingFileStruture() {
        return callRecordingFileStruture;
    }

    public static String getCallRecordingFormat() {
        return callRecordingFormat;
    }

    public static boolean isDevelopement() {
        return developement;
    }

    public static boolean isRandomDuration() {
        return randomDuration;
    }

    public static String getOutboundcallchannel() {
        return outboundcallchannel;
    }

    public static void setOutboundcallchannel(String outboundcallchannel) {
        ConfManager.outboundcallchannel = outboundcallchannel;
    }
}

