/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.wfs.stats;

import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import java.util.logging.Logger;

public class WFSStats {
    private static Logger logger = Logger.getLogger(WFSStats.class.getName());
    private static boolean wfsStats = false;

    public static boolean disableStats() {
        if (wfsStats) {
            wfsStats = false;
            return true;
        }
        return false;
    }

    public static boolean enableStats() {
        if (!wfsStats) {
            wfsStats = true;
            return true;
        }
        return false;
    }

    public static void addErrorStats(String errorType) {
        StatsDB.addData("wfs_monitoring_error", errorType, DC.getServertype(), DC.getCluster(), 1);
    }

    public static void addWFSOverallStat(String serverType, String storage, String folderName, String type, String opr, long timetaken) {
        if (wfsStats) {
            try {
                StatsDB.addData("wfs_overall_data", serverType, storage, folderName, opr, type, 1, timetaken);
            }
            catch (Exception e) {
                logger.info("[Exception][WFSStats - addWFSStat][wfs][" + e.getMessage() + "]");
            }
        }
    }

    public static void addWFSFileSizeStat(String storage, String folderName, String type, String opr, long fileSize) {
        if (wfsStats) {
            try {
                StatsDB.addData("wfsfilesize", storage, folderName, type, opr, fileSize);
            }
            catch (Exception e) {
                logger.info("[Exception][WFSStats - addWFSStat][wfs][" + e.getMessage() + "]");
            }
        }
    }
}

