/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.wfs.cassandra;

import com.adventnet.wms.servercommon.cassandra.datastax.QueryExecutor;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.wfs.WFD;
import com.adventnet.wms.servercommon.wfs.WFS;
import com.adventnet.wms.servercommon.wfs.cassandra.WFSCassandraManager;
import com.adventnet.wms.servercommon.wfs.stats.WFSStats;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.utils.UUIDs;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WFSAtticCF {
    private static Logger logger = Logger.getLogger(WFSAtticCF.class.getName());
    private static String keyspacename = "WFS";
    private static String cfIndex = "wfsatticindex";
    private static String cfname = "wfsatticmapping";

    public static boolean delete(String storage, String folderName, String date, UUID dtime, String entityID, String filePath) {
        try {
            Statement deleteStatement = WFSAtticCF.getDeleteStatement(storage, folderName, date, dtime, entityID, filePath);
            ResultSet deleteResult = QueryExecutor.execute(WFSCassandraManager.getSession(), deleteStatement);
            return true;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "WFS-->[WFSEXCEPTION] Error at deletion of cassandra wfsattic ,storage:" + storage + "::entityID:" + entityID + "::filePath:" + filePath, ex);
            StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_CASSANDRA_ATTIC_DELETE_FAILED.getErrorCode(), 1L);
            WFSStats.addErrorStats("WFS_CASSANDRA_ATTIC_DELETE_FAILED");
            return false;
        }
    }

    public static ArrayList getData(String storage, String folderName, UUID start, UUID end, String entityID, String filePath, int limit) {
        ArrayList returnList = new ArrayList();
        if (limit <= 0) {
            logger.info("WFS--> Count less than zero in attic,  storage=" + storage + ",entityID=" + entityID);
            return returnList;
        }
        try {
            long startTime = System.currentTimeMillis();
            String lastDate = null;
            block2: while (returnList.size() < limit) {
                LinkedHashMap<String, String> indexData = new LinkedHashMap<String, String>();
                Statement getIndexStatement = WFSAtticCF.getIndexSelectStatement(storage + "_" + folderName, lastDate, 2);
                ResultSet getIndexResult = QueryExecutor.execute(WFSCassandraManager.getSession(), getIndexStatement);
                List getIndexResultList = getIndexResult.all();
                if (getIndexResultList.size() == 0) break;
                for (Row row : getIndexResultList) {
                    lastDate = "" + row.getString("date");
                    if (row.getString("value") != null && !row.getString("date").equals("INPROGRESS_" + row.getString("value"))) {
                        Statement deleteIndexStatement = WFSAtticCF.getIndexDeleteStatement(storage + "_" + folderName, lastDate);
                        ResultSet deleteResult = QueryExecutor.execute(WFSCassandraManager.getSession(), deleteIndexStatement);
                        Statement getIndexInsertStatement = WFSAtticCF.getIndexInsertStatement(storage + "_" + folderName, "INPROGRESS_" + lastDate, lastDate, startTime);
                        ResultSet getIndexInsertResult = QueryExecutor.execute(WFSCassandraManager.getSession(), getIndexInsertStatement);
                        indexData.put(lastDate, "INPROGRESS_" + lastDate);
                        continue;
                    }
                    indexData.put(row.getString("value"), lastDate);
                }
                for (String date : indexData.keySet()) {
                    int limitCount = limit - returnList.size();
                    if (limitCount <= 0) continue block2;
                    Statement getStatement = WFSAtticCF.getSelectStatement(storage, folderName, date, start, end, entityID, filePath, limitCount);
                    ResultSet getResult = QueryExecutor.execute(WFSCassandraManager.getSession(), getStatement);
                    List getResultList = getResult.all();
                    if (getResultList.size() == 0 && indexData.get(date) != null && ((String)indexData.get(date)).equals("INPROGRESS_" + date)) {
                        Statement getIndexCheckStatement = WFSAtticCF.getSelectStatement(storage, folderName, date, null, null, null, null, 5);
                        ResultSet getIndexCheckResult = QueryExecutor.execute(WFSCassandraManager.getSession(), getIndexCheckStatement);
                        List indexCheckList = getIndexCheckResult.all();
                        if (indexCheckList == null || indexCheckList.size() != 0) continue;
                        Statement deleteIndexStatement = WFSAtticCF.getIndexDeleteStatement(storage + "_" + folderName, (String)indexData.get(date));
                        ResultSet resultSet = QueryExecutor.execute(WFSCassandraManager.getSession(), deleteIndexStatement);
                        continue;
                    }
                    for (Row row : getResultList) {
                        Hashtable<String, String> data = new Hashtable<String, String>();
                        if (row.getString("value") == null) continue;
                        data.put("storage", "" + row.getString("storage"));
                        data.put("foldername", "" + row.getString("foldername"));
                        data.put("date", "" + row.getString("date"));
                        data.put("dtime", "" + row.getUUID("dtime"));
                        data.put("entityid", "" + row.getString("entityid"));
                        data.put("filepath", "" + row.getString("filepath"));
                        data.put("data", row.getString("value"));
                        returnList.add(data);
                    }
                }
            }
            WFSStats.addWFSOverallStat(DC.getServertype(), storage, folderName, "WFS_CASSANDRA_ATTIC", "GET_LIST", System.currentTimeMillis() - startTime);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WFS-->[WFSEXCEPTION] Error at get attic data From cassandra,storage:" + storage + "::entityID:" + entityID + "::filePath:" + filePath, e);
            StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_CASSANDRA_GETATTICLIST_FAILED.getErrorCode(), 1L);
            WFSStats.addErrorStats("WFS_CASSANDRA_GETLIST_FAILED");
        }
        return returnList;
    }

    public static boolean insert(WFD wfd) {
        try {
            long dTimeMS = System.currentTimeMillis();
            String date = WFS.getDateFormat(dTimeMS);
            Statement indexInsertStatement = WFSAtticCF.getIndexInsertStatement(wfd.getStorage() + "_" + wfd.getFolderName(), date, date, dTimeMS);
            ResultSet indexInsertResult = QueryExecutor.execute(WFSCassandraManager.getSession(), indexInsertStatement);
            UUID dTime = UUIDs.endOf((long)dTimeMS);
            Statement insertStatement = WFSAtticCF.getInsertStatement(wfd.getStorage(), wfd.getFolderName(), date, dTime, wfd.getEntityID(), wfd.getSourcePath(), wfd.toString(), dTimeMS);
            ResultSet insertResult = QueryExecutor.execute(WFSCassandraManager.getSession(), insertStatement);
            WFSStats.addWFSOverallStat(DC.getServertype(), wfd.getStorage(), wfd.getFolderName(), "WFS_CASSANDRA_ATTIC", "INSERT", System.currentTimeMillis() - dTimeMS);
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WFS-->[WFSEXCEPTION] Error at insertion of cassandra wfsattic ,storage:" + wfd.getStorage() + "::entityID:" + wfd.getEntityID() + "::filePath:" + wfd.getSourcePath(), e);
            StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_CASSANDRA_ATTIC_INSERT_FAILED.getErrorCode(), 1L);
            WFSStats.addErrorStats("WFS_CASSANDRA_ATTIC_INSERT_FAILED");
            return false;
        }
    }

    public static Statement getIndexInsertStatement(String key, String date, String value, long clock) throws Exception {
        Insert statement = QueryBuilder.insertInto((String)QueryBuilder.quote((String)keyspacename), (String)QueryBuilder.quote((String)cfIndex)).value("key", (Object)key).value("date", (Object)date).value("value", (Object)value);
        return statement;
    }

    private static Statement getIndexSelectStatement(String key, String date, int limit) throws Exception {
        Select.Selection selection = QueryBuilder.select();
        Select.Builder builder = selection.all();
        Select select = builder.from(QueryBuilder.quote((String)keyspacename), QueryBuilder.quote((String)cfIndex));
        Select.Where where = select.where(QueryBuilder.eq((String)"key", (Object)key));
        if (date != null) {
            where = where.and(QueryBuilder.gt((String)"date", (Object)date));
        }
        if (limit > 0) {
            select = where.limit(limit);
            return select;
        }
        return where;
    }

    private static Statement getIndexDeleteStatement(String key, String date) {
        Delete.Selection selection = QueryBuilder.delete();
        Delete.Builder builder = selection.all();
        Delete del = builder.from(QueryBuilder.quote((String)keyspacename), QueryBuilder.quote((String)cfIndex));
        Delete.Where where = del.where(QueryBuilder.eq((String)"key", (Object)key));
        if (date != null) {
            where = where.and(QueryBuilder.eq((String)"date", (Object)date));
        }
        return where;
    }

    public static Statement getInsertStatement(String storage, String folderName, String date, UUID dtime, String entityID, String filePath, String value, long clock) throws Exception {
        Insert statement = QueryBuilder.insertInto((String)QueryBuilder.quote((String)keyspacename), (String)QueryBuilder.quote((String)cfname)).using(QueryBuilder.timestamp((long)clock)).value("storage", (Object)storage).value("foldername", (Object)folderName).value("date", (Object)date).value("dtime", (Object)dtime).value("entityid", (Object)entityID).value("filepath", (Object)filePath).value("value", (Object)value);
        return statement;
    }

    private static Statement getSelectStatement(String storage, String folderName, String date, UUID start, UUID end, String entityID, String filePath, int limit) throws Exception {
        Select.Selection selection = QueryBuilder.select();
        Select.Builder builder = selection.all();
        Select select = builder.from(QueryBuilder.quote((String)keyspacename), QueryBuilder.quote((String)cfname));
        Select.Where where = select.where(QueryBuilder.eq((String)"storage", (Object)storage));
        where = where.and(QueryBuilder.eq((String)"foldername", (Object)folderName));
        where = where.and(QueryBuilder.eq((String)"date", (Object)date));
        if (start != null && limit == 1) {
            where = where.and(QueryBuilder.eq((String)"dtime", (Object)start));
            return select;
        }
        if (start != null) {
            where = where.and(QueryBuilder.gt((String)"dtime", (Object)start));
        }
        if (end != null) {
            where = where.and(QueryBuilder.lte((String)"dtime", (Object)end));
        }
        if (entityID != null) {
            where = where.and(QueryBuilder.eq((String)"entityid", (Object)entityID));
        }
        if (filePath != null) {
            where = where.and(QueryBuilder.eq((String)"filepath", (Object)filePath));
        }
        if (limit > 0) {
            select = where.limit(limit);
            return select;
        }
        return where;
    }

    private static Statement getDeleteStatement(String storage, String folderName, String date, UUID uuid, String entityID, String filePath) {
        Delete.Selection selection = QueryBuilder.delete();
        Delete.Builder builder = selection.all();
        Delete del = builder.from(QueryBuilder.quote((String)keyspacename), QueryBuilder.quote((String)cfname));
        Delete.Where where = del.where(QueryBuilder.eq((String)"storage", (Object)storage));
        where = where.and(QueryBuilder.eq((String)"foldername", (Object)folderName));
        where = where.and(QueryBuilder.eq((String)"date", (Object)date));
        if (uuid != null) {
            where = where.and(QueryBuilder.eq((String)"dtime", (Object)uuid));
            if (entityID != null) {
                where = where.and(QueryBuilder.eq((String)"entityid", (Object)entityID));
                if (filePath != null) {
                    where = where.and(QueryBuilder.eq((String)"filepath", (Object)filePath));
                }
            }
        }
        return where;
    }
}

