/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.wfs;

import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.wfs.WFSCleanupManager;
import com.adventnet.wms.servercommon.wfs.stats.WFSStats;
import com.zoho.ear.fileencryptagent.FileEncryptAgent;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WFSConfManager {
    private static Logger logger = Logger.getLogger(WFSConfManager.class.getName());
    private static String serverHome = null;
    private static String confFile;
    private static String earservices_conf_file;
    private static String atticFile;
    private static Properties wfsProps;
    private static Properties earservices_conf_properties;
    private static Properties atticProps;
    private static String cassandraloc;
    private static String cassandrakeyspace;
    private static String cassandradc;
    private static String cassandraUserName;
    private static String cassandraPassword;
    private static String cassandraProtocolVersion;
    private static int writeBufferSize;
    private static int readBufferSize;
    private static int versionCount;
    private static int scopeIDRange;
    private static int atticCassandraLimit;
    private static int atticThreadCount;
    private static final long DEFAULT_ATTIC_RETENTION_DURATION = 28800000L;
    private static long cleanupInterval;
    private static boolean isCleanup;
    private static boolean isFileEncryptionEnabled;
    private static boolean isInitialized;
    private static Hashtable<String, Long> atticCleanup;

    public static Properties getProperties(String propsFile) {
        try {
            if (Files.exists(Paths.get(propsFile, new String[0]), new LinkOption[0])) {
                logger.info("WFS-->Loading props " + propsFile);
                Properties props = new Properties();
                props.load(new FileInputStream(propsFile));
                return props;
            }
            logger.info("WFS-->File Not found :" + propsFile);
        }
        catch (Exception exp) {
            logger.severe("Unable to load conf file " + propsFile + ":Ex:" + exp);
        }
        return null;
    }

    public static boolean initialize() {
        try {
            if (isInitialized) {
                return true;
            }
            confFile = serverHome + File.separator + "conf" + File.separator + "wfs.properties";
            earservices_conf_file = serverHome + File.separator + "conf" + File.separator + "earservices.properties";
            atticFile = serverHome + File.separator + "conf" + File.separator + "attic.properties";
            wfsProps = WFSConfManager.getProperties(confFile);
            if (wfsProps != null) {
                atticProps = WFSConfManager.getProperties(atticFile);
                if (atticProps != null) {
                    WFSConfManager.loadAtticProperties();
                }
                if (WFSConfManager.initializeWFSConfiguration()) {
                    if (isFileEncryptionEnabled && (earservices_conf_properties = WFSConfManager.getProperties(earservices_conf_file)) != null && !WFSConfManager.initializeWMSEAR()) {
                        return false;
                    }
                    isInitialized = true;
                    logger.log(Level.INFO, "WFS--> WFS confManager initialized");
                    return true;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WFS-->[WFSEXCEPTION] Exception at WFSconf initialization.", e);
            StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_CONF_NOTINITIALIZE.getErrorCode(), 1L);
            WFSStats.addErrorStats("WFS_CONF_NOTINITIALIZE");
        }
        return false;
    }

    public static boolean updateWFSConf(Hashtable<String, String> newConf) {
        if (newConf != null) {
            wfsProps.putAll((Map<?, ?>)newConf);
        }
        return WFSConfManager.initializeWFSConfiguration();
    }

    public static boolean updateAtticProps(Hashtable<String, String> newConf) {
        if (newConf != null) {
            atticProps.putAll((Map<?, ?>)newConf);
            if (WFSConfManager.loadAtticProperties()) {
                WFSCleanupManager.initialize();
                return true;
            }
        }
        return false;
    }

    public static boolean updateEARConfiguration(Hashtable<String, String> newConf) {
        if (newConf != null) {
            earservices_conf_properties.putAll((Map<?, ?>)newConf);
        }
        return isFileEncryptionEnabled && WFSConfManager.initializeWMSEAR();
    }

    private static boolean initializeWFSConfiguration() {
        try {
            cassandraloc = wfsProps.getProperty("cassandraloc", cassandraloc);
            cassandrakeyspace = wfsProps.getProperty("cassandrakeyspace", cassandrakeyspace);
            cassandradc = wfsProps.getProperty("cassandradc", cassandradc);
            cassandraUserName = wfsProps.getProperty("cassandrausername", cassandraUserName);
            cassandraPassword = wfsProps.getProperty("cassandrapassword", cassandraPassword);
            cassandraProtocolVersion = wfsProps.getProperty("cassandraprotocolversion", cassandraProtocolVersion);
            writeBufferSize = Integer.parseInt(wfsProps.getProperty("writebuffersize", "" + writeBufferSize));
            readBufferSize = Integer.parseInt(wfsProps.getProperty("readbuffersize", "" + readBufferSize));
            versionCount = Integer.parseInt(wfsProps.getProperty("versioncount", "" + versionCount));
            atticCassandraLimit = Integer.parseInt(wfsProps.getProperty("atticcassandralimit", "" + atticCassandraLimit));
            atticThreadCount = Integer.parseInt(wfsProps.getProperty("atticthreadcount", "" + atticThreadCount));
            scopeIDRange = Integer.parseInt(wfsProps.getProperty("scopeidrange", "" + scopeIDRange));
            cleanupInterval = Long.parseLong(wfsProps.getProperty("cleanupinterval", "" + cleanupInterval));
            isCleanup = Boolean.parseBoolean(wfsProps.getProperty("iscleanup", "" + isCleanup));
            isFileEncryptionEnabled = Boolean.parseBoolean(wfsProps.getProperty("isfileencryptionenabled", "" + isFileEncryptionEnabled));
            logger.log(Level.INFO, "WFS--> WFSconf initialized");
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WFSERR--> WFSconf not initialized, Exception:", e);
            StatsDB.recordError(ComponentConstants.WFS_ENUM.getModuleCode(), ComponentConstants.WFS_ENUM.WFS_CONF_ERROR.getErrorCode(), 1L);
            WFSStats.addErrorStats("WFS_CONF_ERROR");
            return false;
        }
    }

    public static String getCassandraloc() {
        return cassandraloc;
    }

    public static String getCassandrakeyspace() {
        return cassandrakeyspace;
    }

    public static String getCassandradc() {
        return cassandradc;
    }

    public static String getCassandraUserName() {
        return cassandraUserName;
    }

    public static String getCassandraPassword() {
        return cassandraPassword;
    }

    public static String getCassandraProtocolVersion() {
        return cassandraProtocolVersion;
    }

    public static int getWriteBufferSize() {
        return writeBufferSize;
    }

    public static int getReadBufferSize() {
        return readBufferSize;
    }

    public static int getVersionCount() {
        return versionCount;
    }

    public static int getScopeIDRange() {
        return scopeIDRange;
    }

    public static boolean isCleanupEnabled() {
        return isCleanup;
    }

    public static boolean initializeWMSEAR() {
        String key = WFSConfManager.getWMSEARRefreshToken();
        try {
            if (key != null) {
                FileEncryptAgent.setAuthToken((String)key);
                logger.log(Level.INFO, "WFS--> EAR initialized");
                return true;
            }
            logger.log(Level.SEVERE, "WFS--> EAR not initialized");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WFSERR--> [EXCEPTION WHILE INITIALIZING WMS EARTOKEN]", e);
        }
        return false;
    }

    public static String getWMSEARRefreshToken() {
        String key = "eartoken";
        return earservices_conf_properties.getProperty(key);
    }

    private static boolean loadAtticProperties() {
        for (String key : atticProps.stringPropertyNames()) {
            atticCleanup.put(key, Long.parseLong(atticProps.getProperty(key, "28800000")));
        }
        logger.log(Level.INFO, "WFS--> ATTIC initialized");
        return true;
    }

    public static boolean isFileEncryptionEnabled() {
        return isFileEncryptionEnabled;
    }

    public static int getAtticCassandraLimit() {
        return atticCassandraLimit;
    }

    public static int getAtticThreadCount() {
        return atticThreadCount;
    }

    public static boolean isForceDelete(String storage, String folder) {
        return atticCleanup.get(storage + "_" + folder) != null && atticCleanup.get(storage + "_" + folder) < 0L;
    }

    public static Hashtable<String, Long> getAtticCleanupConf() {
        return atticCleanup;
    }

    static {
        serverHome = System.getProperty("server.home");
        confFile = serverHome + File.separator + "conf" + File.separator + "wfs.properties";
        earservices_conf_file = serverHome + File.separator + "conf" + File.separator + "earservices.properties";
        atticFile = serverHome + File.separator + "conf" + File.separator + "attic.properties";
        wfsProps = new Properties();
        earservices_conf_properties = new Properties();
        atticProps = new Properties();
        cassandrakeyspace = "\"WFS\"";
        cassandradc = "DC1";
        cassandraProtocolVersion = "v4";
        writeBufferSize = 1024;
        readBufferSize = 1024;
        versionCount = 1;
        scopeIDRange = 100;
        atticCassandraLimit = 100;
        atticThreadCount = 5;
        cleanupInterval = -1L;
        isCleanup = true;
        isFileEncryptionEnabled = false;
        isInitialized = false;
        atticCleanup = new Hashtable();
    }
}

