/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.util;

import com.adventnet.wms.common.exception.WMSException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.spec.KeySpec;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class WmsSecurityUtil {
    private static final Logger LOGGER = Logger.getLogger(WmsSecurityUtil.class.getName());
    private static KeySpec desKeySpec = null;
    private static SecretKeyFactory desKeyFactory = null;
    private static boolean initialized = false;
    private static String desKey = "ux45sDcXAzwqUJKlo98vxZwqT8HS7Udqo74Ws6ulpOM9";

    public static String encrypt(String text) throws WMSException {
        if (!initialized) {
            WmsSecurityUtil.init();
        }
        try {
            SecretKey key = desKeyFactory.generateSecret(desKeySpec);
            Cipher desCipher = Cipher.getInstance("DES");
            desCipher.init(1, key);
            byte[] cleartext = text.getBytes("UTF-8");
            byte[] ciphertext = desCipher.doFinal(cleartext);
            BASE64Encoder base64encoder = new BASE64Encoder();
            String cp = base64encoder.encode(ciphertext);
            String value = URLEncoder.encode(cp, "UTF-8").replace("+", "%20");
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WMSException("Unable to decrypt key :" + text);
        }
    }

    public static String decrypt(String text) throws WMSException {
        if (!initialized) {
            WmsSecurityUtil.init();
        }
        try {
            SecretKey key = desKeyFactory.generateSecret(desKeySpec);
            Cipher desCipher = Cipher.getInstance("DES");
            desCipher.init(2, key);
            BASE64Decoder base64decoder = new BASE64Decoder();
            String ciphertext = URLDecoder.decode(text, "UTF-8");
            byte[] cleartext = base64decoder.decodeBuffer(ciphertext);
            byte[] ctext = desCipher.doFinal(cleartext);
            String value = new String(ctext, "UTF-8");
            return value;
        }
        catch (Exception e) {
            throw new WMSException("Unable to decrypt key : " + text + " Exception : " + e);
        }
    }

    public static boolean init() throws WMSException {
        try {
            desKeySpec = new DESKeySpec(desKey.getBytes("UTF-8"));
            desKeyFactory = SecretKeyFactory.getInstance("DES");
            initialized = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WMSException("Unable to init WmsSecurityUtil");
        }
        return initialized;
    }

    public static String encode(String text) {
        try {
            return new String(Base64.getEncoder().encode(text.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while encrypting data. data : " + text, e);
            return text;
        }
    }

    public static String decode(String text) {
        try {
            return new String(Base64.getDecoder().decode(text.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while decrypting data. data : " + text, e);
            return text;
        }
    }
}

