/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.taskengine;

import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.TraceLogConfManager;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;
import com.adventnet.wms.servercommon.taskengine.TaskEngine;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskManager {
    private static Logger logger = Logger.getLogger(TaskManager.class.getName());
    private static Logger msgtracelogger = Logger.getLogger("msgtracelogger");
    private static String taskConfDir = ServerUtil.serverHome + File.separator + "conf" + File.separator + "taskengine" + File.separator;
    private static HashMap<String, TaskEngine> taskEngine = new HashMap();
    private static ConcurrentHashMap<String, AtomicLong> taskcounter = new ConcurrentHashMap(100, 0.75f, 16);
    private static ConcurrentHashMap<String, Hashtable<String, AtomicLong>> prdtaskcounter = null;
    private static long timeout = -1L;
    private static Hashtable ignoretasks = new Hashtable();
    private static boolean prdstatsenabled = false;

    public static boolean initialize() {
        return TaskManager.initialize(-1L);
    }

    public static boolean initialize(long timelimit) {
        Properties tconf = ServerUtil.getProperties(taskConfDir + "taskengine.conf");
        Enumeration<?> e = tconf.propertyNames();
        while (e.hasMoreElements()) {
            String teName = (String)e.nextElement();
            String teParam = (String)tconf.get(teName);
            String[] teParams = teParam.split(",");
            boolean fifo = false;
            int bufSize = new Integer(teParams[0]);
            int mediumprioritythreads = new Integer(teParams[1]);
            int highprioritythreads = 0;
            int lowprioritythreads = 0;
            if (teParams.length > 2) {
                highprioritythreads = new Integer(teParams[2]);
                if (teParams.length > 3) {
                    lowprioritythreads = new Integer(teParams[3]);
                    if (teParams.length > 4) {
                        fifo = Boolean.parseBoolean(teParams[4]);
                    }
                }
            }
            TaskEngine engine = new TaskEngine(teName, bufSize, mediumprioritythreads, highprioritythreads, lowprioritythreads, fifo);
            engine.start();
            taskEngine.put(teName, engine);
        }
        timeout = timelimit;
        logger.info("Task Manager intialized " + taskEngine);
        return true;
    }

    public static void delegate(WmsEvent event) {
        try {
            if (event == null) {
                return;
            }
            if (TaskManager.isDisabledEvent(event)) {
                logger.fine("disabled event=" + event);
                return;
            }
            long starttime = System.currentTimeMillis();
            TaskManager.printTrace(event, "delegate");
            if ("route.sendchatmsg".equals(event.getOpr()) || "chat.sendmessage".equals(event.getOpr())) {
                logger.info("delegate event opr = " + event.getOpr() + "  event = " + event.getData("reqid"));
            } else {
                logger.fine("delegate event opr = " + event.getOpr() + "  event = " + event.getData("reqid"));
            }
            event.putData("inqueuetime", (Object)("" + starttime));
            event = event.duplicate();
            event.trackOpr("d");
            long duplicationtime = System.currentTimeMillis();
            TaskManager.hit(event.getOpr());
            ServerUtil.logExternal(event, "delegate", "event_start");
            taskEngine.get(event.getOpr().split("\\.")[0]).handle(event);
            long totaltime = System.currentTimeMillis();
            if (timeout != -1L && (totaltime - starttime >= timeout || totaltime - duplicationtime >= timeout)) {
                logger.info("Timeout in taskmanager totaltime: " + (totaltime - starttime) + " duplicationtime: " + (duplicationtime - starttime));
            }
            TaskManager.hit(event);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Unable to delegate task event : " + event, e);
        }
    }

    public static boolean chain(WmsEvent event) {
        try {
            if (event == null) {
                return false;
            }
            if (TaskManager.isDisabledEvent(event)) {
                return false;
            }
            TaskManager.printTrace(event, "chain");
            event.trackOpr("c");
            ServerUtil.logExternal(event, "chain", "event_start");
            logger.fine("chain event opr = " + event.getOpr() + "  event = " + event);
            return taskEngine.get(event.getOpr().split("\\.")[0]).chain(event);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("Unable to chain task " + e.getMessage() + " event=" + event);
            return false;
        }
    }

    public static void printTrace(WmsEvent event, String method) {
        if (TraceLogConfManager.isDebugEnabled(event.getOpr(), event.getRKey())) {
            msgtracelogger.info("TaskManager [" + method + "] [" + event.getOpr() + "] [" + event.getRKey() + "] [Event] " + event.toString());
            event.enableTrace();
        }
    }

    public static void shutdown() {
        for (TaskEngine engine : taskEngine.values()) {
            engine.shutdown();
        }
    }

    public static void restart() {
        for (TaskEngine engine : taskEngine.values()) {
            engine.restart();
        }
    }

    public static ConcurrentHashMap getStats() {
        return taskcounter;
    }

    public static void resetStats() {
        taskcounter.clear();
    }

    private static void hit(String taskName) {
        try {
            if (taskName == null) {
                return;
            }
            taskcounter.putIfAbsent(taskName, new AtomicLong());
            taskcounter.get(taskName).incrementAndGet();
        }
        catch (Exception exp) {
            logger.log(Level.INFO, "Error in adding stats. taskName :" + taskName, exp);
        }
    }

    public static void enablePrdStats() {
        prdstatsenabled = true;
        prdtaskcounter = new ConcurrentHashMap();
    }

    public static ConcurrentHashMap<String, Hashtable<String, AtomicLong>> getPrdStats() {
        return prdtaskcounter;
    }

    public static void resetPrdStats() {
        prdtaskcounter = new ConcurrentHashMap();
    }

    private static void hit(WmsEvent event) {
        if (!prdstatsenabled) {
            return;
        }
        String taskname = event.getOpr();
        if (taskname == null) {
            return;
        }
        String prd = event.getDataAsString("prd");
        TaskManager.addPrdTask(prd, taskname);
        TaskManager.addPrdTask("wms", taskname);
    }

    private static void addPrdTask(String prd, String taskname) {
        AtomicLong al;
        if (prd == null) {
            return;
        }
        if (StatsConf.isTaskEngineStatsEnabled()) {
            StatsDB.addData("tasks", "old", prd, taskname, taskname.split("\\.")[0], 1);
            return;
        }
        Hashtable<String, AtomicLong> tcount = prdtaskcounter.get(prd);
        if (tcount == null) {
            tcount = new Hashtable();
            tcount.put(taskname, new AtomicLong());
            prdtaskcounter.put(prd, tcount);
        }
        if ((al = tcount.get(taskname)) == null) {
            al = new AtomicLong();
            tcount.put(taskname, al);
        }
        al.incrementAndGet();
    }

    public static Hashtable getQueStats() {
        Hashtable<String, Hashtable> details = new Hashtable<String, Hashtable>();
        for (TaskEngine engine : taskEngine.values()) {
            details.put(engine.getName(), engine.getStats());
        }
        return details;
    }

    public static Hashtable<String, ArrayList<Hashtable<String, String>>> getWmsQStats() {
        Hashtable<String, ArrayList<Hashtable<String, String>>> details = new Hashtable<String, ArrayList<Hashtable<String, String>>>();
        for (TaskEngine engine : taskEngine.values()) {
            details.put(engine.getName(), engine.getWmsQStats());
        }
        return details;
    }

    public static void clearQueStats() {
        for (TaskEngine engine : taskEngine.values()) {
            engine.clearStats();
        }
    }

    public static boolean isDisabledEvent(WmsEvent event) {
        if (ignoretasks != null && ignoretasks.size() != 0) {
            Hashtable disabledprds = null;
            if (ignoretasks.containsKey(event.getOpr().split("\\.")[0]) ? (disabledprds = (Hashtable)ignoretasks.get(event.getOpr().split("\\.")[0])) == null || disabledprds.size() == 0 : ignoretasks.containsKey(event.getOpr()) && ((disabledprds = (Hashtable)ignoretasks.get(event.getOpr())) == null || disabledprds.size() == 0)) {
                return true;
            }
            if (event.getData("prd") != null && disabledprds != null && disabledprds.containsKey(event.getData("prd"))) {
                return true;
            }
        }
        return false;
    }

    public static void setIgnoreTasks(Hashtable properties) {
        ignoretasks = properties;
    }

    public static void initiateDrain() {
        for (TaskEngine engine : taskEngine.values()) {
            engine.setDrain(true);
            engine.restart();
        }
    }

    public static void stopEngine(String engineName) {
        TaskEngine engine = taskEngine.get(engineName);
        if (engine != null) {
            engine.stop();
        }
    }

    public static void stopAllEngines() {
        for (TaskEngine engine : taskEngine.values()) {
            engine.stop();
        }
    }

    public static void stopDrain() {
        for (TaskEngine engine : taskEngine.values()) {
            engine.setDrain(false);
        }
    }
}

