/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.stats.influx;

import com.adventnet.wms.servercommon.stats.influx.BBQueue;
import com.adventnet.wms.servercommon.stats.influx.StatsDB;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;

class StatsDBQueue {
    private BBQueue bq = null;
    private String database = "";
    private String rp = "";
    private String key = "";
    private long lastPolledTime = System.currentTimeMillis();
    private static long batchTime = -1L;
    private static long batchSize = -1L;

    public StatsDBQueue(String key, String database, String rp) {
        this.key = key;
        this.database = StatsDB.getInfluxPrefix() + database;
        this.rp = rp;
        this.bq = new BBQueue(StatsConf.getDirectory() + "/statsqueue/", key, StatsConf.getDispatchQueueSize());
        batchTime = StatsConf.getBatchTime();
        batchSize = StatsConf.getBatchSize();
    }

    protected synchronized void add(byte[] obj) {
        this.bq.add(obj);
    }

    protected synchronized void addToNewFile(byte[] obj) {
        this.bq.addToNewFile(obj);
    }

    protected synchronized byte[] remove() {
        return this.bq.get();
    }

    protected int size() {
        return this.bq.size();
    }

    protected void close() {
        this.bq.close();
    }

    protected String database() {
        return this.database;
    }

    protected String rp() {
        return this.rp;
    }

    protected String key() {
        return this.key;
    }

    protected boolean isBatchWaiting() {
        long timegap = System.currentTimeMillis() - this.lastPolledTime;
        return batchTime > 0L && timegap <= batchTime || batchSize > 0L && (long)this.size() <= batchSize;
    }

    protected void setLastPolledTime(long lastpolledtime) {
        this.lastPolledTime = lastpolledtime;
    }
}

