/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.stats.influx;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.exception.WMSException;
import com.adventnet.wms.servercommon.components.constants.ComponentConstants;
import com.adventnet.wms.servercommon.dc.DC;
import com.adventnet.wms.servercommon.stats.influx.StatRecord;
import com.adventnet.wms.servercommon.stats.influx.StatementResult;
import com.adventnet.wms.servercommon.stats.influx.StatsByteArrayUploader;
import com.adventnet.wms.servercommon.stats.influx.StatsCollector;
import com.adventnet.wms.servercommon.stats.influx.StatsDispatchManager;
import com.adventnet.wms.servercommon.stats.influx.conf.StatsConf;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StatsDB {
    private static final Logger LOGGER = Logger.getLogger(StatsDB.class.getName());
    public static final String STATTYPE_QOS = "qos";
    public static final String STATTYPE_METRIC = "metric";
    private static boolean initialized = false;
    private static ConcurrentHashMap<String, StatRecord> statMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, ArrayList<Object>> statBlockMap = new ConcurrentHashMap();
    private static int readQueryLogThreshold = 20;
    private static String influxdbPrefix;
    private static ThreadLocal<Long[]> queryInstrumentation;
    private static final ConcurrentHashMap<String, ArrayList<String>> DATABASE_LIST;
    private static boolean drainMode;
    private static Thread statsCollector;
    private static Thread statsByteArrayUploader;
    private static final ReentrantLock MODULE_LOCK;
    private static final Condition MODULE_COMPLETED;
    protected static final String STATS_THREAD_PREFIX = "Stats/";

    public static void initialize() {
        try {
            if (!StatsConf.isStatsEnabled()) {
                return;
            }
            if (CommonUtil.isEmpty((String)influxdbPrefix)) {
                influxdbPrefix = !CommonUtil.isEmpty((String)DC.getDCId()) ? DC.getDCId() + "_" : "";
            }
            ConcurrentHashMap<String, String> statsDefs = StatsConf.getStatDefs();
            Enumeration<String> enuKey = statsDefs.keys();
            while (enuKey.hasMoreElements()) {
                String statKey = enuKey.nextElement();
                try {
                    String statDef = statsDefs.get(statKey);
                    StatRecord stat = new StatRecord(statKey, statDef);
                    statMap.put(statKey, stat);
                }
                catch (Exception e) {
                    StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_MALFORMED.getErrorCode(), 1L);
                    LOGGER.log(Level.WARNING, "PS --> :: STATRECORD_MALFORMED :: Cannot Initialize statRecord for statKey -> " + statKey, e);
                    StatsDB.addData("statsdberror", statKey, "StatsKey_NotInitialized", DC.getCluster(), DC.getServertype(), "stats_error", 1);
                }
            }
            if (initialized) {
                return;
            }
            statsCollector = new Thread(new StatsCollector());
            statsByteArrayUploader = new Thread(new StatsByteArrayUploader());
            statsCollector.start();
            statsByteArrayUploader.start();
            initialized = true;
            LOGGER.info("PS --> StatsDB initialized successfully...");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "PS --> StatsDB CANNOT initialized...", e);
        }
    }

    protected static void loadInStatsDB(String statKey, String statValue, Hashtable<String, String> details) {
        try {
            if (!StatsConf.isStatsEnabled()) {
                LOGGER.log(Level.INFO, "PS --> isStatEnabled key is false in statConf");
                details.put("statDB", "isStatEnabled key is false");
                return;
            }
            StatRecord stat = new StatRecord(statKey, statValue);
            statMap.put(statKey, stat);
            details.put(statKey, "Updated successfully");
        }
        catch (Exception exp) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_MALFORMED.getErrorCode(), 1L);
            LOGGER.log(Level.SEVERE, "PS --> :: STATRECORD_MALFORMED :: Cannot initialised statRecord for statKey -> " + statKey + " statValue -> " + statValue, exp);
            details.put(statKey, "Exception caught. Check in serverLogs for more info. execption message =" + exp.getMessage());
        }
    }

    public static String getInfluxPrefix() {
        return influxdbPrefix;
    }

    public static void setInfluxPrefix(String dcid) {
        influxdbPrefix = !CommonUtil.isEmpty((String)dcid) ? dcid + "_" : "";
    }

    public static String getInfluxVersion(String statType) {
        String version;
        block6: {
            version = "Unknown";
            try {
                String wnet = StatsConf.getWnet(statType);
                if (wnet != null) {
                    try {
                        HttpURLConnection ht = (HttpURLConnection)new URL("http://" + wnet + "/ping").openConnection();
                        ht.setConnectTimeout(StatsConf.getHttpConnectTimeout());
                        ht.setReadTimeout(StatsConf.getHttpReadTimeout());
                        int responseCode = ht.getResponseCode();
                        if (responseCode == 204 || responseCode == 200) {
                            version = "InfluxDB v" + ht.getHeaderField("X-Influxdb-Version");
                            break block6;
                        }
                        version = "Error : HTTP ResponseCode" + responseCode;
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, "PS --> Error while fetching InfluxDB Version... statType = " + statType, e);
                        version = "InfluxDB not reachable.";
                    }
                    break block6;
                }
                version = "No Wnet for " + statType;
                LOGGER.warning("PS --> Wnet not present in conf for stattype = " + statType);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "PS_ERROR --> Error while getting influx version for stattype = " + statType, e);
            }
        }
        return version;
    }

    public static boolean record(String db, String str) {
        return StatsDB.record(db, null, str);
    }

    public static boolean record(String db, String rp, String str) {
        return StatsDB.record(db, rp, STATTYPE_QOS, str);
    }

    public static boolean record(String db, String rp, String statType, String str) {
        str = str + "\n";
        return StatsDB.record(db, rp, statType, str.getBytes(), str.split(",")[0]);
    }

    public static boolean record(String db, String rp, String statType, byte[] str, String msr) {
        if (!StatsConf.isStatsEnabled()) {
            return false;
        }
        return StatsDispatchManager.dispatch(db, rp, statType, str, msr, "recordData");
    }

    public static void addData(Object ... values) {
        if (!StatsConf.isStatsEnabled()) {
            return;
        }
        String statKey = (String)values[0];
        if (!initialized) {
            LOGGER.warning("PS --> StatsDB NOT initialized statkey=" + statKey);
            return;
        }
        if (drainMode) {
            LOGGER.warning("PS --> Drain Mode is Enabled statkey=" + statKey);
            return;
        }
        if (StatsDB.isStatKeyBlocked(statKey)) {
            return;
        }
        StatRecord record = statMap.get(statKey);
        if (record == null) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_NOT_INITIALIZED.getErrorCode(), 1L);
            StatsDB.addData("statsdberror", values[0], "statKey_not_defined", DC.getCluster(), DC.getServertype(), "stats_error", 1);
            return;
        }
        if (record.isRangeData()) {
            record.addRangeData(values);
        } else if (record.isInstantDispatch()) {
            record.dispatchData(System.currentTimeMillis(), values);
        } else if (record.isSampleTimeAvailable()) {
            values = StatsDB.addPos(values, System.currentTimeMillis() / record.getSampleTimeInMills());
            record.addData(values);
        } else {
            record.addData(values);
        }
    }

    public static void addDataInstant(long timems, Object ... values) {
        if (!StatsConf.isStatsEnabled()) {
            return;
        }
        String statKey = (String)values[0];
        if (!initialized) {
            LOGGER.warning("PS --> StatsDB NOT initialized statkey=" + statKey);
            return;
        }
        if (drainMode) {
            LOGGER.warning("PS --> Drain Mode is Enabled statkey=" + statKey);
            return;
        }
        if (StatsDB.isStatKeyBlocked(statKey)) {
            return;
        }
        StatRecord record = statMap.get(statKey);
        if (record == null) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_NOT_INITIALIZED.getErrorCode(), 1L);
            StatsDB.addData("statsdberror", values[0], "statKey_not_defined", DC.getCluster(), DC.getServertype(), "stats_error", 1);
            return;
        }
        if (record.isInstantDispatch()) {
            record.dispatchData(timems, values);
        } else {
            StatsDB.addData("statsdberror", values[0], "statKey_not_instant_dispatch", DC.getCluster(), DC.getServertype(), "stats_error", 1);
        }
    }

    public static void updateDataInstantly(long timems, Object ... values) {
        if (!StatsConf.isStatsEnabled()) {
            return;
        }
        String statKey = (String)values[0];
        if (!initialized) {
            LOGGER.warning("PS --> StatsDB NOT initialized statkey=" + statKey);
            return;
        }
        if (drainMode) {
            LOGGER.warning("PS --> Drain Mode is Enabled statkey=" + statKey);
            return;
        }
        if (StatsDB.isStatKeyBlocked(statKey)) {
            return;
        }
        StatRecord record = statMap.get(statKey);
        if (record == null) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_NOT_INITIALIZED.getErrorCode(), 1L);
            StatsDB.addData("statsdberror", values[0], "statKey_not_defined", DC.getCluster(), DC.getServertype(), "stats_error", 1);
            return;
        }
        record.dispatchUpdatedData(timems, values);
    }

    public static void addDataToDB(String database, Object ... values) {
        if (!StatsConf.isStatsEnabled()) {
            return;
        }
        String statKey = (String)values[0];
        if (!initialized) {
            LOGGER.warning("PS --> StatsDB NOT initialized statkey=" + statKey);
            return;
        }
        if (drainMode) {
            LOGGER.warning("PS --> Drain Mode is Enabled statkey=" + statKey);
            return;
        }
        if (StatsDB.isStatKeyBlocked(statKey)) {
            return;
        }
        StatRecord record = statMap.get(statKey + '@' + database);
        if (record == null) {
            try {
                record = new StatRecord(statKey, StatsConf.getStatDef(statKey));
                record.updateDB(database);
                statMap.put(statKey + '@' + database, record);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "PS --> Issue while creating dynamic DB");
                StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_NOT_INITIALIZED.getErrorCode(), 1L);
                StatsDB.addData("statsdberror", values[0], "statKey_not_defined", DC.getCluster(), DC.getServertype(), "stats_error", 1);
                return;
            }
        }
        if (record.isRangeData()) {
            record.addRangeData(values);
        } else if (record.isInstantDispatch()) {
            record.dispatchData(System.currentTimeMillis(), values);
        } else if (record.isSampleTimeAvailable()) {
            values = StatsDB.addPos(values, System.currentTimeMillis() / record.getSampleTimeInMills());
            record.addData(values);
        } else {
            record.addData(values);
        }
    }

    public static void exportData(Object ... values) {
        if (!StatsConf.isStatsEnabled()) {
            return;
        }
        String statKey = (String)values[0];
        if (!initialized) {
            LOGGER.warning("PS --> StatsDB NOT initialized statkey=" + statKey);
            return;
        }
        if (drainMode) {
            LOGGER.warning("PS --> Drain Mode is Enabled statkey=" + statKey);
            return;
        }
        if (StatsDB.isStatKeyBlocked(statKey)) {
            return;
        }
        StatRecord record = statMap.get(statKey);
        if (record == null) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_NOT_INITIALIZED.getErrorCode(), 1L);
            StatsDB.addData("statsdberror", values[0], "statKey_not_defined", DC.getCluster(), DC.getServertype(), "stats_error", 1);
            return;
        }
        if (record.isRangeData()) {
            record.addRangeData(values);
        } else if (record.isInstantDispatch()) {
            record.dispatchData(System.currentTimeMillis(), values);
        } else if (record.isSampleTimeAvailable()) {
            values = StatsDB.addPos(values, System.currentTimeMillis() / record.getSampleTimeInMills());
            record.addData(values);
        } else {
            record.addData(values);
        }
    }

    public static void recordError(int moduleCode, int errorCode, long count) {
        StatsDB.recordFailure(moduleCode, count);
        StatsDB.addData("moduleerror", moduleCode, errorCode, count);
    }

    private static void recordFailure(int moduleCode, long count) {
        if (DC.getServertype() != null) {
            StatsDB.addData("modulefailure", DC.getServertype(), moduleCode, count);
        }
    }

    protected static ConcurrentHashMap getStatsMap() {
        return statMap;
    }

    protected static String getStatsValue(String statKey) {
        StatRecord statRecord = statMap.get(statKey);
        return statRecord != null ? statRecord.getStatDef().toString() : null;
    }

    public static ArrayList<String> getDatabases(String statType) throws WMSException, IOException {
        try {
            ArrayList results = (ArrayList)StatsDB.execute("show databases", "POST", ResultFormat.STAEMENTRESULTS, statType, "show DB", false);
            StatementResult result = (StatementResult)results.get(0);
            return result.getDatabases();
        }
        catch (Exception e) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.HTTP_GET_DB_NULL.getErrorCode(), 1L);
            LOGGER.log(Level.WARNING, "PS --> :: HTTP_GET_DB_NULL :: Cannot get db for stattype : -> " + statType, e);
            return null;
        }
    }

    public static ArrayList<String> getDatabases(String ip, int port) throws WMSException, IOException {
        try {
            ArrayList results = (ArrayList)StatsDB.execute("show databases", "POST", ResultFormat.STAEMENTRESULTS, ip, port, "show DB", false);
            StatementResult result = (StatementResult)results.get(0);
            return result.getDatabases();
        }
        catch (Exception e) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.HTTP_GET_DB_NULL.getErrorCode(), 1L);
            LOGGER.log(Level.WARNING, "PS --> :: HTTP_GET_DB_NULL :: Cannot get db for [ip : " + ip + "][port : " + port + "]", e);
            return null;
        }
    }

    public static ArrayList<String> getCQueries(String statType) throws WMSException, IOException {
        ArrayList results = (ArrayList)StatsDB.execute("show continuous queries", "POST", ResultFormat.STAEMENTRESULTS, statType, "show CQ", false);
        StatementResult result = (StatementResult)results.get(0);
        return result.getCQueries();
    }

    public static ArrayList<String> getCQueries(String ip, int port) throws WMSException, IOException {
        ArrayList results = (ArrayList)StatsDB.execute("show continuous queries", "POST", ResultFormat.STAEMENTRESULTS, ip, port, "show CQ", false);
        StatementResult result = (StatementResult)results.get(0);
        return result.getCQueries();
    }

    public static Hashtable doSubmit(String query) throws WMSException, SocketException, IOException {
        return (Hashtable)StatsDB.execute(query, "POST", ResultFormat.HASHTABLE, STATTYPE_QOS, "doSubmit", false);
    }

    public static Hashtable doSubmit(String statType, String query) throws WMSException, SocketException, IOException {
        return (Hashtable)StatsDB.execute(query, "POST", ResultFormat.HASHTABLE, statType, "doSubmit", false);
    }

    public static Hashtable doSubmit(String statType, String db, String query) throws WMSException, SocketException, IOException {
        return (Hashtable)StatsDB.execute(query, "POST", ResultFormat.HASHTABLE, statType, db, true);
    }

    public static Hashtable doSubmit(String ip, int port, String query) throws WMSException, SocketException, IOException {
        return (Hashtable)StatsDB.execute(query, "POST", ResultFormat.HASHTABLE, ip, port, "doSubmit", false);
    }

    public static Hashtable doSubmit(String ip, int port, String db, String query) throws WMSException, SocketException, IOException {
        return (Hashtable)StatsDB.execute(query, "POST", ResultFormat.HASHTABLE, ip, port, db, true);
    }

    public static Hashtable doFetch(String db, String query) throws WMSException, SocketException, IOException {
        return (Hashtable)StatsDB.execute(query, "GET", ResultFormat.HASHTABLE, STATTYPE_QOS, db, true);
    }

    public static Hashtable doFetch(String statType, String db, String query) throws WMSException, SocketException, IOException {
        return (Hashtable)StatsDB.execute(query, "GET", ResultFormat.HASHTABLE, statType, db, true);
    }

    public static Hashtable doFetch(String ip, int port, String db, String query) throws WMSException, SocketException, IOException {
        return (Hashtable)StatsDB.execute(query, "GET", ResultFormat.HASHTABLE, ip, port, db, true);
    }

    public static String doFetchAsJSON(String db, String query) throws WMSException, SocketException, IOException {
        return (String)StatsDB.execute(query, "GET", ResultFormat.JSON, STATTYPE_QOS, db, true);
    }

    public static String doFetchAsJSON(String statType, String db, String query) throws WMSException, SocketException, IOException {
        return (String)StatsDB.execute(query, "GET", ResultFormat.JSON, statType, db, true);
    }

    public static String doFetchAsJSON(String ip, int port, String db, String query) throws WMSException, SocketException, IOException {
        return (String)StatsDB.execute(query, "GET", ResultFormat.JSON, ip, port, db, true);
    }

    public static ArrayList<StatementResult> doFetchAsStatement(String db, String query) throws WMSException, SocketException, IOException {
        return (ArrayList)StatsDB.execute(query, "GET", ResultFormat.STAEMENTRESULTS, STATTYPE_QOS, db, true);
    }

    public static ArrayList<StatementResult> doFetchAsStatement(String statType, String db, String query) throws WMSException, SocketException, IOException {
        return (ArrayList)StatsDB.execute(query, "GET", ResultFormat.STAEMENTRESULTS, statType, db, true);
    }

    public static ArrayList<StatementResult> doFetchAsStatement(String ip, int port, String db, String query) throws WMSException, SocketException, IOException {
        return (ArrayList)StatsDB.execute(query, "GET", ResultFormat.STAEMENTRESULTS, ip, port, db, true);
    }

    public static InputStream doFetchAsStream(String db, String query) throws WMSException, SocketException, IOException {
        return (InputStream)StatsDB.execute(query, "GET", ResultFormat.STREAM, STATTYPE_QOS, db, true);
    }

    public static InputStream doFetchAsCSVStream(String db, String query) throws WMSException, SocketException, IOException {
        return (InputStream)StatsDB.execute(query, "GET", ResultFormat.CSVSTREAM, STATTYPE_QOS, db, true);
    }

    public static InputStream doFetchAsStream(String statType, String db, String query) throws WMSException, SocketException, IOException {
        return (InputStream)StatsDB.execute(query, "GET", ResultFormat.STREAM, statType, db, true);
    }

    public static InputStream doFetchAsCSVStream(String statType, String db, String query) throws WMSException, SocketException, IOException {
        return (InputStream)StatsDB.execute(query, "GET", ResultFormat.CSVSTREAM, statType, db, true);
    }

    public static InputStream doFetchAsStream(String ip, int port, String db, String query) throws WMSException, SocketException, IOException {
        return (InputStream)StatsDB.execute(query, "GET", ResultFormat.STREAM, ip, port, db, true);
    }

    public static InputStream doFetchAsCSVStream(String ip, int port, String db, String query) throws WMSException, SocketException, IOException {
        return (InputStream)StatsDB.execute(query, "GET", ResultFormat.CSVSTREAM, ip, port, db, true);
    }

    public static HttpURLConnection doFetchAsURLConnections(String db, String query) throws WMSException, SocketException, IOException {
        return (HttpURLConnection)StatsDB.execute(query, "GET", ResultFormat.URLCONNECTION, STATTYPE_QOS, db, true);
    }

    public static HttpURLConnection doFetchAsURLConnections(String statType, String db, String query) throws WMSException, SocketException, IOException {
        return (HttpURLConnection)StatsDB.execute(query, "GET", ResultFormat.URLCONNECTION, statType, db, true);
    }

    public static HttpURLConnection doFetchAsURLConnections(String ip, int port, String db, String query) throws WMSException, SocketException, IOException {
        return (HttpURLConnection)StatsDB.execute(query, "GET", ResultFormat.URLCONNECTION, ip, port, db, true);
    }

    public static void startInstrumentation() {
        queryInstrumentation.set(new Long[]{0L, 0L});
    }

    public static void updateQueryDuration(long duration) {
        try {
            Long[] instrumentedValues = queryInstrumentation.get();
            if (instrumentedValues != null) {
                Long[] longArray = instrumentedValues;
                Long.valueOf(longArray[1] + duration);
                queryInstrumentation.set(instrumentedValues);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while queryDuration instrumentation. \n", e);
        }
    }

    public static Long[] stopInstrumentation() {
        Long[] instrumentedValues = null;
        try {
            instrumentedValues = queryInstrumentation.get();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while getting instrumentation. \n", e);
        }
        finally {
            try {
                queryInstrumentation.remove();
            }
            catch (Exception exception) {}
        }
        return instrumentedValues;
    }

    private static Object execute(String query, String reqMethod, ResultFormat format, String statType, String db, boolean isDBPresent) throws WMSException, SocketException, IOException {
        return StatsDB.execute(StatsDB.getQueryBaseUrl(statType, db, isDBPresent), query, reqMethod, format, statType, db);
    }

    private static Object execute(String query, String reqMethod, ResultFormat format, String ip, int port, String db, boolean isDBPresent) throws WMSException, SocketException, IOException {
        if (isDBPresent) {
            return StatsDB.execute("http://" + ip + ":" + port + "/query?db=" + db, query, reqMethod, format, ip, db);
        }
        return StatsDB.execute("http://" + ip + ":" + port + "/query?", query, reqMethod, format, ip, db);
    }

    /*
     * Exception decompiling
     */
    private static Object execute(String url, String query, String reqMethod, ResultFormat format, String statType, String db) throws WMSException, SocketException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[TRYBLOCK]], but top level block is 27[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void close(HttpURLConnection ht, DataInputStream dis) {
        try {
            if (dis != null) {
                dis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (ht != null) {
                ht.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Hashtable formatResult(String str) {
        return (Hashtable)HttpDataWraper.getObject((String)str);
    }

    private static ArrayList<StatementResult> getStatementResults(String str) {
        ArrayList<StatementResult> list = new ArrayList<StatementResult>();
        try {
            ArrayList resultList = (ArrayList)StatsDB.formatResult(str).get("results");
            for (Hashtable result : resultList) {
                if (!result.containsKey("series")) continue;
                list.add(new StatementResult(result));
            }
        }
        catch (Exception e) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.EXCEPTION_IN_STATEMENT_RESULT.getErrorCode(), 1L);
            LOGGER.log(Level.SEVERE, "PS --> :: EXCEPTION_IN_STATEMENT_RESULT :: Exception in getStatementResult...", e);
        }
        return list.size() > 0 ? list : null;
    }

    public static void resetConfiguration() {
        StatsDispatchManager.resetDispatcherConfigs();
    }

    private static Object[] addPos(Object[] src, long num) {
        Object[] temp = new Object[src.length + 1];
        System.arraycopy(src, 0, temp, 0, 1);
        System.arraycopy(src, 1, temp, 2, src.length - 1);
        temp[1] = num;
        return temp;
    }

    static ArrayList<String> getStatKeys() {
        return new ArrayList<String>(statMap.keySet());
    }

    protected static ConcurrentHashMap getStats(String statKey) {
        return statMap.get(statKey).getStats();
    }

    static synchronized void blockStatKey(String statName, String zuid, Hashtable<String, String> details) {
        if (statBlockMap == null) {
            LOGGER.severe("STATS_ERROR --> StatsBlockList is null, Created new one, in blockStatKey method with statKeys : " + statName);
            StatsDB.addData("statsdberror", statName, "blockstatskey_block_null", DC.getCluster(), DC.getServertype(), "stats_error", 1);
            statBlockMap = new ConcurrentHashMap();
        }
        if (!statBlockMap.containsKey(statName)) {
            if (statMap != null && statMap.containsKey(statName)) {
                ArrayList<Object> userDetails = new ArrayList<Object>();
                userDetails.add(System.currentTimeMillis());
                userDetails.add(zuid);
                statBlockMap.put(statName, userDetails);
                details.put(statName, "Added to block stats list");
            } else {
                details.put(statName, "StatKey is not defined in statKeyList");
            }
        } else {
            details.put(statName, "StatKey is already blocked");
        }
    }

    static boolean unblockStatKey(String statName) {
        if (statBlockMap == null) {
            LOGGER.severe("STATS_ERROR --> StatsBlockList is null, Created new one, in removeBlockStats method with statKeys : " + statName);
            StatsDB.addData("statsdberror", statName, "blockstatskey_unblock_null", DC.getCluster(), DC.getServertype(), "stats_error", 1);
            statBlockMap = new ConcurrentHashMap();
        }
        return statBlockMap.remove(statName) != null;
    }

    static ConcurrentHashMap<String, ArrayList<Object>> listBlockStatsKey() {
        if (statBlockMap == null) {
            LOGGER.severe("STATS_ERROR --> StatsBlockList is null, Created new one, in listBlockStats method");
            statBlockMap = new ConcurrentHashMap();
        }
        return statBlockMap;
    }

    static Set<String> clearAllBlockStatsKey() {
        if (statBlockMap == null) {
            LOGGER.severe("STATS_ERROR --> StatsBlockList is null, Created new one, in clearAllBlockStats method");
            statBlockMap = new ConcurrentHashMap();
        }
        HashSet<String> statNames = new HashSet<String>(statBlockMap.keySet());
        statBlockMap.clear();
        return statNames;
    }

    private static boolean isStatKeyBlocked(String statkey) {
        return statBlockMap.containsKey(statkey);
    }

    static void setReadQueryLogThreshold(int time) {
        readQueryLogThreshold = time;
    }

    static int getReadQueryLogThreshold() {
        return readQueryLogThreshold;
    }

    public static void drain() {
        drainMode = true;
        try {
            MODULE_LOCK.lock();
            statsCollector.interrupt();
            LOGGER.info("PS --> Drain for statsCollector");
            boolean status = MODULE_COMPLETED.await(10L, TimeUnit.SECONDS);
            LOGGER.info("PS --> Drain StatusCollector status for await : " + status);
            statsByteArrayUploader.interrupt();
            LOGGER.info("PS --> Drain for StatsByteArrayUploader");
            status = MODULE_COMPLETED.await(10L, TimeUnit.SECONDS);
            LOGGER.info("PS --> Drain StatsByteArrayUploader status for await : " + status);
            LOGGER.info("PS --> Drain for StatsDispatchManager");
            StatsDispatchManager.interrupt();
            LOGGER.info("PS --> Drain StatsDispatchManager status for await from StatsDB : " + status);
        }
        catch (Exception exp) {
            LOGGER.log(Level.SEVERE, "PS --> Error during drainStats...", exp);
        }
        finally {
            MODULE_LOCK.unlock();
        }
    }

    public static boolean isDrainMode() {
        return drainMode;
    }

    static void notifyComplete(String module) {
        try {
            MODULE_LOCK.lock();
            LOGGER.info("PS --> Signalling for module : " + module);
            MODULE_COMPLETED.signal();
        }
        catch (Exception exp) {
            LOGGER.log(Level.SEVERE, "PS --> Error during notifyComplete for drain for Module : " + module, exp);
        }
        finally {
            MODULE_LOCK.unlock();
        }
    }

    private static String findMsrFromQuery(String query) {
        String actualQuery = query;
        try {
            if (!query.contains(" from ")) {
                if (query.substring(0, query.indexOf(" ")).toLowerCase().contains("show")) {
                    return "exploring_schema_data";
                }
                LOGGER.info("PS --> [findMsrFromQuery : " + actualQuery + "]");
                return "UNKNOWN";
            }
            if ((query = query.substring(query.indexOf(" from ") + 6).trim()).contains(" from ")) {
                return StatsDB.findMsrFromQuery(query);
            }
            query = query.replace("\"", "");
            int rpMsr = (query = query.replace("\\", "")).indexOf(" ");
            if (rpMsr > 0) {
                query = query.substring(0, rpMsr);
            }
            int msrIndex = query.lastIndexOf(".");
            return query.substring(msrIndex + 1);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "MK --> Error in findMsrFromQuery.[query : " + actualQuery + "]", e);
            return "UNKNOWN";
        }
    }

    public static ArrayList<String> getMeasurements(String statType, String database) {
        ArrayList<String> measurement = new ArrayList<String>();
        try {
            StatementResult statementResult;
            ArrayList<Hashtable> series;
            ArrayList<StatementResult> srList = StatsDB.doFetchAsStatement(statType, database, "show measurements");
            if (srList != null && srList.size() > 0 && (series = (statementResult = srList.get(0)).getSeries()).get(0).get("values") != null) {
                ArrayList list = (ArrayList)series.get(0).get("values");
                for (Object o : list) {
                    measurement.add((String)((ArrayList)o).get(0));
                }
            }
        }
        catch (Exception e) {
            measurement = null;
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.HTTP_GET_MSR_NULL.getErrorCode(), 1L);
            LOGGER.log(Level.WARNING, "PS --> :: HTTP_GET_MSR_NULL :: Cannot get msr for db : -> " + database, e);
        }
        return measurement;
    }

    private static String getQueryBaseUrl(String statType, String db, boolean dbAppender) {
        return StatsDB.getBaseUrl(statType, "query", db, dbAppender);
    }

    public static String getWriteBaseUrl(String statType, String db, String rp) {
        if (!CommonUtil.isEmpty((String)rp)) {
            return StatsDB.getBaseUrl(statType, "write", db, true) + "&rp=" + rp;
        }
        return StatsDB.getBaseUrl(statType, "write", db, true);
    }

    private static String getBaseUrl(String statType, String subResource, String db, boolean dbAppender) {
        String url = "http://" + StatsConf.getWnet(statType) + "/" + subResource + "?" + StatsConf.getAuth(statType);
        if (dbAppender) {
            url = url + "&db=" + db;
        }
        return url;
    }

    public static boolean isDBPresent(String statType, String database) {
        database = StatsDB.getInfluxPrefix() + database;
        try {
            ArrayList<String> list = DATABASE_LIST.get(statType);
            if (CommonUtil.isEmpty(list)) {
                list = StatsDB.getDatabases(statType);
                DATABASE_LIST.put(statType, list);
            }
            if (!list.contains(database)) {
                StatsDB.doSubmit(statType, "create database " + database + " with duration 28d replication 1 shard duration 1d name \"autogen\"");
                StatsDB.addData("influx_db_created", statType, database, 1);
                list = StatsDB.getDatabases(statType);
                DATABASE_LIST.put(statType, list);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static {
        queryInstrumentation = new ThreadLocal();
        DATABASE_LIST = new ConcurrentHashMap();
        drainMode = false;
        MODULE_LOCK = new ReentrantLock();
        MODULE_COMPLETED = MODULE_LOCK.newCondition();
    }

    public static enum ResultFormat {
        JSON("Json"),
        CSV("CSV"),
        HASHTABLE("Hashtable"),
        STREAM("Stream"),
        CSVSTREAM("CSV_Stream"),
        URLCONNECTION("UrlConnection"),
        STAEMENTRESULTS("StatementResult");

        private final String resultFormatName;

        private ResultFormat(String resultFormatName) {
            this.resultFormatName = resultFormatName;
        }

        public String getResultFormatName() {
            return this.resultFormatName;
        }
    }
}

