/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.stats.influx;

import com.adventnet.wms.common.CommonUtil;

public class SelectStatement {
    private String statType;
    private String database;
    private String retentionPolicy;
    private String measurement;
    private String selectClause;
    private String whereClause;
    private String groupByTime;
    private String groupByTag;
    private long sTime = -1L;
    private long eTime = -1L;
    private int limit = -1;
    private String sTimeRange;
    private String fill = "";

    public SelectStatement(String statType, String database, String measurement) {
        this.statType = statType;
        this.database = database;
        this.measurement = measurement;
    }

    public SelectStatement(String statType, String database, String retentionPolicy, String measurement) {
        this.statType = statType;
        this.database = database;
        this.retentionPolicy = retentionPolicy;
        this.measurement = measurement;
    }

    public String getQuery() {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("SELECT ");
            if (CommonUtil.isEmpty((String)this.selectClause)) {
                throw new Exception("EXP --> Select clause is empty");
            }
            builder.append(this.selectClause);
            builder.append(" FROM ");
            if (!CommonUtil.isEmpty((String)this.retentionPolicy)) {
                builder.append(SelectStatement.getDQuote(this.retentionPolicy));
                builder.append('.');
            }
            if (CommonUtil.isEmpty((String)this.measurement)) {
                throw new Exception("EXP --> Measurement is empty");
            }
            builder.append(SelectStatement.getDQuote(this.measurement));
            builder.append(" WHERE ");
            if (this.sTime > -1L && this.eTime > -1L) {
                builder.append(" time >= ").append(this.sTime).append(" and time <= ").append(this.eTime).append(" ");
            } else if (!CommonUtil.isEmpty((String)this.sTimeRange)) {
                builder.append(" time >= now()-").append(this.sTimeRange).append(" ");
            } else {
                throw new Exception("EXP --> No time is empty");
            }
            if (!CommonUtil.isEmpty((String)this.whereClause)) {
                builder.append(" and ").append(this.whereClause).append(" ");
            }
            if (!CommonUtil.isEmpty((String)this.groupByTime) || !CommonUtil.isEmpty((String)this.groupByTag)) {
                builder.append(" GROUP BY ");
            }
            if (!CommonUtil.isEmpty((String)this.groupByTime)) {
                builder.append(this.groupByTime);
                if (!CommonUtil.isEmpty((String)this.groupByTag)) {
                    builder.append(", ");
                }
            }
            if (!CommonUtil.isEmpty((String)this.groupByTag)) {
                builder.append(this.groupByTag);
            }
            if (!CommonUtil.isEmpty((String)this.fill)) {
                builder.append(" FILL(").append(this.fill).append(") ");
            }
            if (this.limit > 0) {
                builder.append(" LIMIT ").append(this.limit);
            }
            return builder.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public SelectStatement setSelectClause(String str) {
        this.selectClause = str;
        return this;
    }

    public SelectStatement setWhereClause(String str) {
        this.whereClause = str;
        return this;
    }

    public SelectStatement setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public SelectStatement setFill(String str) {
        this.fill = str;
        return this;
    }

    public SelectStatement setTimeRange(String str) {
        this.sTimeRange = str;
        return this;
    }

    public SelectStatement setGroupByTag(String str) {
        this.groupByTag = str;
        return this;
    }

    public SelectStatement setGroupByTime(String str) {
        this.groupByTime = str;
        return this;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public String getStatType() {
        return this.statType;
    }

    public String getMeasurement() {
        return this.measurement;
    }

    public String getSelectClause() {
        return this.selectClause;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public String getGroupByTime() {
        return this.groupByTime;
    }

    public String getGroupByTag() {
        return this.groupByTag;
    }

    public long getsTime() {
        return this.sTime;
    }

    public long geteTime() {
        return this.eTime;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getsTimeRange() {
        return this.sTimeRange;
    }

    public String getFill() {
        return this.fill;
    }

    private static String getSQuote(String str) {
        return '\'' + str + '\'';
    }

    private static String getDQuote(String str) {
        return '\"' + str + '\"';
    }
}

