/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.serialization;

import com.adventnet.wms.servercommon.serialization.WMSSerialization;
import com.adventnet.wms.servercommon.serialization.WMSSerializationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JDKSerialization
extends WMSSerialization {
    private static Logger logger = Logger.getLogger(JDKSerialization.class.getName());
    private int mode;
    private FileInputStream fin = null;
    private FileOutputStream fout = null;
    private ObjectInputStream ois = null;
    private ObjectOutputStream oos = null;
    private String writeFilePath = null;
    private String readFilePath = null;

    public JDKSerialization(int mode) throws WMSSerializationException {
        if (!WMSSerialization.isValidMode(mode)) {
            throw new WMSSerializationException("Invalid mode. Given Mode : " + mode);
        }
        this.mode = mode;
    }

    @Override
    public void writeObject(Object obj) throws WMSSerializationException {
        try {
            if (this.oos == null) {
                throw new WMSSerializationException("File not found. Please open the stream first before writing the object.");
            }
            this.oos.writeObject(obj);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "HB_ERR --> Unable to write the Object, mode=" + this.mode + ", filePath=" + this.writeFilePath, e);
        }
    }

    @Override
    public Object readObject() throws WMSSerializationException {
        Object obj = null;
        if (this.ois != null) {
            try {
                obj = this.ois.readObject();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "HB_ERR --> Unable to read the Object from disk [readObject] filePath=" + this.readFilePath, e);
            }
        } else {
            throw new WMSSerializationException("File not found. Please open the stream first before reading the object.");
        }
        return obj;
    }

    @Override
    public void closeStream() throws WMSSerializationException {
        block9: {
            if (this.mode != 0) {
                try {
                    if (this.mode == 2) {
                        if (this.oos != null) {
                            this.oos.close();
                            this.oos = null;
                        }
                        if (this.fout != null) {
                            this.fout.close();
                            this.fout = null;
                            this.writeFilePath = null;
                        }
                    }
                    if (this.mode != 1) break block9;
                    if (this.fin != null) {
                        this.fin.close();
                        this.fin = null;
                    }
                    if (this.ois != null) {
                        this.ois.close();
                        this.ois = null;
                        this.readFilePath = null;
                    }
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "HB_ERR --> Unable to close the Stream, mode=" + this.mode + ", readFilePath=" + this.readFilePath + ", writeFilePath=" + this.writeFilePath, e);
                }
            } else {
                throw new WMSSerializationException("Cannot close the stream!. Have to set the operation mode (read/write).");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveToFile(String filePath, Object obj) throws Exception {
        FileOutputStream fileOut = null;
        ObjectOutputStream jdkOos = null;
        try {
            fileOut = new FileOutputStream(filePath);
            jdkOos = new ObjectOutputStream(fileOut);
            jdkOos.writeObject(obj);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "HB_ERR --> Unable to write the Object to disk [saveToFile] mode=" + this.mode + ", filePath=" + filePath, e);
        }
        finally {
            if (fileOut != null) {
                fileOut.close();
                fileOut = null;
            }
            if (jdkOos != null) {
                jdkOos.close();
                jdkOos = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object loadFromFile(String filePath) throws WMSSerializationException, ClassNotFoundException, IOException {
        Object obj = null;
        FileInputStream fileFin = null;
        ObjectInputStream jdkOis = null;
        try {
            fileFin = new FileInputStream(filePath);
            jdkOis = new ObjectInputStream(fileFin);
            obj = jdkOis.readObject();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "HB_ERR --> Unable to read the Object from disk [loadFromFile] mode=" + this.mode + ", filePath=" + filePath, e);
        }
        finally {
            if (jdkOis != null) {
                jdkOis.close();
                jdkOis = null;
            }
            if (fileFin != null) {
                fileFin.close();
                fileFin = null;
            }
        }
        return obj;
    }

    @Override
    public void openStream(String filePath) throws WMSSerializationException {
        if (this.mode != 0) {
            if (this.mode == 2) {
                try {
                    this.writeFilePath = filePath;
                    this.fout = new FileOutputStream(filePath);
                    this.oos = new ObjectOutputStream(this.fout);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "HB_ERR --> Unable to open the Stream, mode=" + this.mode + ", filePath=" + filePath, e);
                }
            }
            if (this.mode == 1) {
                try {
                    this.readFilePath = filePath;
                    this.fin = new FileInputStream(filePath);
                    this.ois = new ObjectInputStream(this.fin);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "HB_ERR --> Unable to open the Stream, mode=" + this.mode + ", filePath=" + filePath, e);
                }
            }
        } else {
            throw new WMSSerializationException("Cannot initialize the stream!. Have to set the operation mode (read/write).");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toBytes(Object obj) throws WMSSerializationException {
        byte[] bytes = null;
        ObjectOutputStream bOos = null;
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            bOos = new ObjectOutputStream(bos);
            bOos.writeObject(obj);
            bOos.flush();
            bytes = bos.toByteArray();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "HB_ERR --> Unable to convert toBytes, mode=" + this.mode, e);
        }
        finally {
            if (bOos != null) {
                try {
                    bOos.close();
                    bOos = null;
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "HB_ERR --> Unable to close the Stream, mode=" + this.mode, e);
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                    bos = null;
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "HB_ERR --> Unable to close the Stream, mode=" + this.mode, e);
                }
            }
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object toObject(byte[] byteArray) throws WMSSerializationException {
        Object obj = null;
        ObjectInputStream bOis = null;
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(byteArray);
            bOis = new ObjectInputStream(bis);
            obj = bOis.readObject();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "HB_ERR --> Unable to convert toObject, mode=" + this.mode, e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                    bis = null;
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "HB_ERR --> Unable to close the Stream, mode=" + this.mode, e);
                }
            }
            if (bOis != null) {
                try {
                    bOis.close();
                    bOis = null;
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "HB_ERR --> Unable to close the Stream, mode=" + this.mode, e);
                }
            }
        }
        return obj;
    }
}

