/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.serialization;

import com.adventnet.wms.servercommon.serialization.WMSSerialization;
import com.adventnet.wms.servercommon.serialization.WMSSerializationException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

public class FSTSerialization
extends WMSSerialization {
    private static Logger logger = Logger.getLogger(FSTSerialization.class.getName());
    static FSTConfiguration conf = FSTConfiguration.createDefaultConfiguration();
    private int mode;
    private FileInputStream fin = null;
    private FileOutputStream fout = null;
    private FSTObjectInput in = null;
    private FSTObjectOutput out = null;
    private String writeFilePath = null;
    private String readFilePath = null;

    public FSTSerialization(int mode) throws WMSSerializationException {
        if (!WMSSerialization.isValidMode(mode)) {
            throw new WMSSerializationException("Invalid mode. Given Mode : " + mode);
        }
        this.mode = mode;
    }

    @Override
    public void writeObject(Object obj) throws WMSSerializationException {
        if (this.out != null) {
            try {
                this.out.writeObject(obj);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "HB_ERR --> Unable to write the Object to disk. filePath=" + this.writeFilePath, e);
            }
        } else {
            throw new WMSSerializationException("File not found. Please open the stream first before writing the object.");
        }
    }

    @Override
    public Object readObject() throws WMSSerializationException {
        Object obj = null;
        if (this.in != null) {
            try {
                obj = this.in.readObject();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "HB_ERR --> Unable to read the Object from disk [readObject] filePath=" + this.readFilePath, e);
            }
        } else {
            throw new WMSSerializationException("Input Stream is null. Please open the stream first before reading the object");
        }
        return obj;
    }

    @Override
    public void closeStream() throws WMSSerializationException {
        block9: {
            if (this.mode != 0) {
                try {
                    if (this.mode == 2) {
                        if (this.out != null) {
                            this.out.close();
                            this.out = null;
                        }
                        if (this.fout != null) {
                            this.fout.close();
                            this.fout = null;
                            this.writeFilePath = null;
                        }
                    }
                    if (this.mode != 1) break block9;
                    if (this.in != null) {
                        this.in.close();
                        this.in = null;
                    }
                    if (this.fin != null) {
                        this.fin.close();
                        this.fin = null;
                        this.readFilePath = null;
                    }
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "HB_ERR --> Unable to close the stream. mode=" + this.mode + ", readFilePath=" + this.readFilePath + ", writeFilePath=" + this.writeFilePath, e);
                }
            } else {
                throw new WMSSerializationException("Can't close the stream!. Have to set the operation mode (read/write).");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveToFile(String filePath, Object obj) throws Exception {
        FSTObjectOutput fstOut = null;
        FileOutputStream fileOut = null;
        try {
            fileOut = new FileOutputStream(filePath);
            fstOut = conf.getObjectOutput((OutputStream)fileOut);
            fstOut.writeObject(obj);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "HB_ERR --> Unable to write the Object to disk [saveToFile] filePath=" + filePath, e);
        }
        finally {
            if (fstOut != null) {
                fstOut.close();
                fstOut = null;
            }
            if (fileOut != null) {
                fileOut.close();
                fileOut = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object loadFromFile(String filePath) throws WMSSerializationException, ClassNotFoundException, IOException {
        Object obj = null;
        FSTObjectInput fstIn = null;
        FileInputStream fileFin = null;
        try {
            fileFin = new FileInputStream(filePath);
            fstIn = conf.getObjectInput((InputStream)fileFin);
            obj = fstIn.readObject();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "HB_ERR --> Unable to read the Object from disk [loadFromFile] filePath=" + filePath, e);
        }
        finally {
            if (fstIn != null) {
                fstIn.close();
                fstIn = null;
            }
            if (fileFin != null) {
                fileFin.close();
                fileFin = null;
            }
        }
        return obj;
    }

    @Override
    public void openStream(String filePath) throws WMSSerializationException {
        if (this.mode != 0) {
            if (this.mode == 2) {
                try {
                    this.writeFilePath = filePath;
                    this.fout = new FileOutputStream(filePath);
                    this.out = conf.getObjectOutput((OutputStream)this.fout);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "HB_ERR --> Unable to open the Stream, mode=" + this.mode + ", filePath=" + filePath, e);
                }
            }
            if (this.mode == 1) {
                try {
                    this.readFilePath = filePath;
                    this.fin = new FileInputStream(filePath);
                    this.in = conf.getObjectInput((InputStream)this.fin);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "HB_ERR --> Unable to open the Stream, mode=" + this.mode + ", filePath=" + filePath, e);
                }
            }
        } else {
            throw new WMSSerializationException("Can't initialize the stream!. Have to set the operation mode (read/write).");
        }
    }

    @Override
    public byte[] toBytes(Object obj) throws WMSSerializationException {
        byte[] byteArray = null;
        try {
            byteArray = conf.asByteArray(obj);
        }
        catch (Exception e) {
            throw new WMSSerializationException("Cannot convert the Object into Byte array.");
        }
        return byteArray;
    }

    @Override
    public Object toObject(byte[] byteArray) throws WMSSerializationException {
        Object obj = null;
        try {
            obj = conf.asObject(byteArray);
        }
        catch (Exception e) {
            throw new WMSSerializationException("Cannot convert Byte array into Object.");
        }
        return obj;
    }
}

