/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.runtime.cli;

import com.adventnet.wms.servercommon.ServerUtil;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CLICommand {
    private static final Logger LOGGER = Logger.getLogger(CLICommand.class.getName());
    private static String cliConfDir = ServerUtil.serverHome + File.separator + "conf" + File.separator + "cli" + File.separator;
    private String cmd;
    private String man = "";
    private String runtimeKey;
    private Properties cmdHeaders = new Properties();
    private Properties cmdParams = new Properties();
    private Hashtable staticParams = new Hashtable();

    public CLICommand(String cmd, String runtimeKey) {
        this.runtimeKey = runtimeKey;
        this.cmd = cmd;
        this.loadCommandFile();
        this.loadManFile();
    }

    private void loadCommandFile() {
        try {
            Properties cmdProp = ServerUtil.getProperties(cliConfDir + this.cmd + ".cmd");
            for (String key : cmdProp.stringPropertyNames()) {
                String value = (String)cmdProp.get(key);
                if (key.charAt(0) == '-') {
                    this.cmdParams.put(key, value);
                    continue;
                }
                if (key.charAt(0) == '$') {
                    if ((key = key.substring(1)).isEmpty()) continue;
                    this.staticParams.put(key, value);
                    continue;
                }
                this.cmdHeaders.put(key, value);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while reading command file for cmd : " + this.cmd, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadManFile() {
        InputStreamReader reader = null;
        try {
            File file = new File(cliConfDir + this.cmd + ".man");
            if (file.isFile()) {
                reader = new FileReader(file);
                char[] chars = new char[(int)file.length()];
                reader.read(chars);
                this.man = new String(chars);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NS--> Error while getting file as string. ", e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "NS--> Error while closing reader. ", e);
            }
        }
    }

    public String getRuntimeKey() {
        return this.runtimeKey;
    }

    public String getCmd() {
        return this.cmd;
    }

    public String getCmdHeaders(String key) {
        return this.cmdHeaders.getProperty(key);
    }

    public String getCmdParams(String key) {
        return this.cmdParams.getProperty("-" + key);
    }

    public Properties getCmdHeaders() {
        return this.cmdHeaders;
    }

    public Properties getCmdParams() {
        return this.cmdParams;
    }

    public Hashtable getStaticParams() {
        return this.staticParams;
    }

    public String getMan() {
        return this.man;
    }
}

