/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.runtime;

import com.adventnet.wms.servercommon.ServerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimerTask;
import java.util.logging.Logger;

public abstract class WmsRuntime
extends TimerTask {
    private static final Logger LOGGER = Logger.getLogger(WmsRuntime.class.getName());
    private long lastPolledTime = System.currentTimeMillis();
    private String today;
    private String thismonth;
    private String fullday;
    private String name;
    private long dayStartTime = System.currentTimeMillis();
    private SimpleDateFormat df = new SimpleDateFormat("MMM_dd");
    private SimpleDateFormat mf = new SimpleDateFormat("yyyy_MMM");
    private SimpleDateFormat yf = new SimpleDateFormat("dd-MMM-yyyy");

    public WmsRuntime() {
        this.resetDay();
    }

    public WmsRuntime(String name) {
        this();
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract Hashtable getInfo(Hashtable var1);

    public void periodicInfoCollector(long timeElapsed) {
    }

    protected void periodicCollector(long timeElapsed) {
    }

    protected void endOfDay(String day) {
    }

    protected void endOfMonth(String month) {
    }

    protected void importData(long storedtime, Hashtable data) {
    }

    protected Hashtable exportData() {
        throw new UnsupportedOperationException("Default");
    }

    private String currentDay() {
        return this.df.format(new Date());
    }

    private String currentMonth() {
        return this.mf.format(new Date());
    }

    private void resetDay() {
        this.today = this.currentDay();
        this.thismonth = this.currentMonth();
        this.fullday = this.yf.format(new Date());
        this.dayStartTime = System.currentTimeMillis();
    }

    protected String getFilePath() {
        File dir = new File(ServerUtil.dataHome + "runtime" + File.separator);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return ServerUtil.dataHome + "runtime" + File.separator + this.name + ".data";
    }

    public long getTimeElapsedSinceToday() {
        return System.currentTimeMillis() - this.dayStartTime;
    }

    public long getTimeElapsedSinceLastPoll() {
        return System.currentTimeMillis() - this.lastPolledTime;
    }

    public String getTodayString() {
        return this.today;
    }

    public String getFullDayString() {
        return this.fullday;
    }

    public static Date getYesterday() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        return cal.getTime();
    }

    @Override
    public void run() {
        try {
            this.periodicCollector(System.currentTimeMillis() - this.lastPolledTime);
            Hashtable data = this.exportData();
            if (data != null) {
                this.saveToStore(data);
            }
        }
        catch (UnsupportedOperationException data) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.lastPolledTime = System.currentTimeMillis();
        }
        if (!this.currentDay().equals(this.today)) {
            try {
                try {
                    this.endOfDay(this.today);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!this.currentMonth().equals(this.thismonth)) {
                    try {
                        this.endOfMonth(this.thismonth);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            finally {
                this.resetDay();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToStore(Hashtable data) {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            File f = new File(this.getFilePath());
            if (data == null) {
                f.delete();
                return;
            }
            fos = new FileOutputStream(f);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(data);
        }
        catch (Exception e) {
            LOGGER.severe("Unable to save data to store " + this.name + " exp:" + e.getMessage());
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception exception) {}
            try {
                oos.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFromStore() {
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            File f = new File(this.getFilePath());
            fis = new FileInputStream(f);
            ois = new ObjectInputStream(fis);
            this.importData(f.lastModified(), (Hashtable)ois.readObject());
            LOGGER.info("Runtime data loaded from file " + f.getName());
        }
        catch (FileNotFoundException f) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LOGGER.severe("Unable to load file from store " + this.name + " exp:" + ex.getMessage());
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception exception) {}
            try {
                ois.close();
            }
            catch (Exception exception) {}
        }
    }
}

