/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.logging.asynclogs;

import com.adventnet.wms.servercommon.ServerUtil;
import com.adventnet.wms.servercommon.components.executor.WMSThreadPoolExecutor;
import com.adventnet.wms.servercommon.components.executor.WmsTask;
import com.adventnet.wms.servercommon.components.queue.BufferedQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

class AsyncLogsProcessor {
    private static final Logger LOGGER = Logger.getLogger(AsyncLogsProcessor.class.getName());
    private static int maxPoolSize = 1;
    private static int corePoolSize = 1;
    private static int queueSize = 1000;
    private static BufferedQueue bq = null;
    private static String propsFile = null;
    private static String loggerHome = null;
    private static boolean isInitialized = false;
    private static ThreadPoolExecutor executor = null;
    private static WMSThreadPoolExecutor wmsTPE = null;

    AsyncLogsProcessor() {
    }

    private static boolean initialize() {
        if (isInitialized) {
            LOGGER.log(Level.INFO, "AsyncLogProcessor already Initialized.");
            return true;
        }
        propsFile = loggerHome + File.separator + "conf" + File.separator + "asynclogs.properties";
        try {
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(propsFile));
                LOGGER.info("HB--> propsPath=" + propsFile);
                LOGGER.info("HB--> props=" + props.toString());
                if (props != null) {
                    corePoolSize = Integer.parseInt(props.getProperty("corepoolsize", "" + corePoolSize));
                    maxPoolSize = Integer.parseInt(props.getProperty("maxpoolsize", "" + maxPoolSize));
                    queueSize = Integer.parseInt(props.getProperty("queuesize", "" + queueSize));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            bq = new BufferedQueue(ServerUtil.dataHome + File.separator + "asynclogs", "logs", queueSize, false);
            LOGGER.log(Level.INFO, "HB_INFO--> BQFileName=" + bq.getFileName() + " BQFilePath=" + bq.getFilePath());
            wmsTPE = new WMSThreadPoolExecutor("WCP/AsyncLogProcessor", corePoolSize, maxPoolSize, 100L, TimeUnit.MICROSECONDS, bq, new AysncLogger());
            isInitialized = true;
            LOGGER.log(Level.INFO, "HB--> AsyncLogProcessor Initialized. corePoolSize=" + corePoolSize + " maxlogprocessorcount=" + maxPoolSize + " queueSize=" + queueSize);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "HB_ERR--> Unable to Initialize AsyncLogProcessor", ex);
        }
        return isInitialized;
    }

    public static boolean shutdown() {
        boolean status = false;
        try {
            if (executor == null) {
                return true;
            }
            status = wmsTPE.shutdown();
            bq.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception in eventdispatcher shutdown ", e);
        }
        return status;
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    static void process(Logger logger, Level level, String message) {
        if (isInitialized) {
            try {
                wmsTPE.execute(new LogDispatcher(logger, level, message));
                return;
            }
            catch (Exception exp) {
                LOGGER.log(Level.SEVERE, "Exception in log dispatch ", exp);
            }
        }
    }

    static void process(Logger logger, Level level, String message, Object param) {
        if (isInitialized) {
            try {
                wmsTPE.execute(new TmpA(logger, level, message, param));
                return;
            }
            catch (Exception exp) {
                LOGGER.log(Level.SEVERE, "Exception in log dispatch ", exp);
            }
        }
    }

    static void process(Logger logger, Level level, String message, Object[] params) {
        if (isInitialized) {
            try {
                wmsTPE.execute(new TmpB(logger, level, message, params));
                return;
            }
            catch (Exception exp) {
                LOGGER.log(Level.SEVERE, "Exception in log dispatch ", exp);
            }
        }
    }

    static void process(Logger logger, Level level, String message, Throwable thrown) {
        if (isInitialized) {
            try {
                wmsTPE.execute(new TmpC(logger, level, message, thrown));
                return;
            }
            catch (Exception exp) {
                LOGGER.log(Level.SEVERE, "Exception in log dispatch ", exp);
            }
        }
    }

    static void process(Logger logger, LogRecord record) {
        if (isInitialized) {
            try {
                wmsTPE.execute(new LogRecordDispatcher(logger, record));
                return;
            }
            catch (Exception exp) {
                LOGGER.log(Level.SEVERE, "Exception in log dispatch ", exp);
            }
        }
    }

    private static void log(Logger logger, Level level, String message) {
        logger.log(level, message);
    }

    private static void log(Logger logger, Level level, String message, Object param) {
        logger.log(level, message, param);
    }

    private static void log(Logger logger, Level level, String message, Object[] params) {
        logger.log(level, message, params);
    }

    private static void log(Logger logger, Level level, String message, Throwable thrown) {
        logger.log(level, message, thrown);
    }

    private static void log(Logger logger, LogRecord record) {
        logger.log(record);
    }

    public static int queueSize() {
        if (bq != null) {
            return bq.size();
        }
        return -1;
    }

    static {
        loggerHome = System.getProperty("server.home");
        AsyncLogsProcessor.initialize();
    }

    public static interface AsyncLoggerObject {
        public void handle();
    }

    static class AysncLogger
    implements WmsTask {
        AysncLogger() {
        }

        @Override
        public void handle(Object obj) {
            AsyncLoggerObject async = (AsyncLoggerObject)obj;
            async.handle();
        }
    }

    static class LogRecordDispatcher
    implements AsyncLoggerObject,
    Serializable {
        private Logger logger;
        private LogRecord record;

        LogRecordDispatcher(Logger logger, LogRecord record) {
            this.logger = logger;
            this.record = record;
        }

        @Override
        public void handle() {
            try {
                AsyncLogsProcessor.log(this.logger, this.record);
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, "[Exception][AsyncLogsProcessor - Run]", ex);
            }
        }
    }

    static class TmpC
    extends LogDispatcher
    implements AsyncLoggerObject,
    Serializable {
        private Throwable thrown;

        TmpC(Logger logger, Level level, String message, Throwable thrown) {
            super(logger, level, message);
            this.thrown = thrown;
        }

        @Override
        public void handle() {
            try {
                AsyncLogsProcessor.log(this.logger, this.level, this.message, this.thrown);
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, "[Exception][AsyncLogsProcessor - Run]", ex);
            }
        }
    }

    static class TmpB
    extends LogDispatcher
    implements AsyncLoggerObject,
    Serializable {
        private Object[] params;

        TmpB(Logger logger, Level level, String message, Object[] params) {
            super(logger, level, message);
            this.params = params;
        }

        public void hanlde() {
            try {
                AsyncLogsProcessor.log(this.logger, this.level, this.message, this.params);
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, "[Exception][AsyncLogsProcessor - Run]", ex);
            }
        }
    }

    static class TmpA
    extends LogDispatcher
    implements AsyncLoggerObject,
    Serializable {
        private Object param;

        TmpA(Logger logger, Level level, String message, Object param) {
            super(logger, level, message);
            this.param = param;
        }

        @Override
        public void handle() {
            try {
                AsyncLogsProcessor.log(this.logger, this.level, this.message, this.param);
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, "[Exception][AsyncLogsProcessor - Run]", ex);
            }
        }
    }

    static class LogDispatcher
    implements AsyncLoggerObject,
    Serializable {
        protected Logger logger;
        protected Level level;
        protected String message;

        LogDispatcher(Logger logger, Level level, String message) {
            this.logger = logger;
            this.level = level;
            this.message = message;
        }

        @Override
        public void handle() {
            try {
                AsyncLogsProcessor.log(this.logger, this.level, this.message);
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, "[Exception][AsyncLogsProcessor - Run]", ex);
            }
        }
    }
}

